/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.sparql.util.NodeFactoryExtra;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexLucene
implements TextIndex {
    private static Logger log = LoggerFactory.getLogger(TextIndexLucene.class);
    private static int MAX_N = 10000;
    public static final Version VER = Version.LUCENE_46;
    public static final FieldType ftIRI = new FieldType();
    public static final FieldType ftString;
    public static final FieldType ftText;
    private final EntityDefinition docDef;
    private final Directory directory;
    private IndexWriter indexWriter;
    private Analyzer analyzer;

    public TextIndexLucene(Directory directory, EntityDefinition def) {
        this.directory = directory;
        this.docDef = def;
        HashMap<String, Object> analyzerPerField = new HashMap<String, Object>();
        analyzerPerField.put(def.getEntityField(), new KeywordAnalyzer());
        if (def.getGraphField() != null) {
            analyzerPerField.put(def.getGraphField(), new KeywordAnalyzer());
        }
        for (String field : def.fields()) {
            Analyzer analyzer = def.getAnalyzer(field);
            if (analyzer == null) continue;
            analyzerPerField.put(field, analyzer);
        }
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer(VER), analyzerPerField);
        this.startIndexing();
        this.finishIndexing();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public void startIndexing() {
        try {
            IndexWriterConfig wConfig = new IndexWriterConfig(VER, this.analyzer);
            this.indexWriter = new IndexWriter(this.directory, wConfig);
        }
        catch (IOException e) {
            TextIndexLucene.exception(e);
        }
    }

    @Override
    public void finishIndexing() {
        try {
            this.indexWriter.commit();
            this.indexWriter.close();
            this.indexWriter = null;
        }
        catch (IOException e) {
            TextIndexLucene.exception(e);
        }
    }

    @Override
    public void abortIndexing() {
        try {
            this.indexWriter.rollback();
        }
        catch (IOException ex) {
            TextIndexLucene.exception(ex);
        }
    }

    public void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException ex) {
                TextIndexLucene.exception(ex);
            }
        }
    }

    @Override
    public void addEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            log.debug("Add entity: " + entity);
        }
        try {
            boolean autoBatch = this.indexWriter == null;
            Document doc = this.doc(entity);
            if (autoBatch) {
                this.startIndexing();
            }
            this.indexWriter.addDocument((Iterable)doc);
            if (autoBatch) {
                this.finishIndexing();
            }
        }
        catch (IOException e) {
            TextIndexLucene.exception(e);
        }
    }

    private Document doc(Entity entity) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), entity.getId(), ftIRI);
        doc.add((IndexableField)entField);
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            Field gField = new Field(graphField, entity.getGraph(), ftString);
            doc.add((IndexableField)gField);
        }
        for (Map.Entry<String, Object> e : entity.getMap().entrySet()) {
            Field field = new Field(e.getKey(), (String)e.getValue(), ftText);
            doc.add((IndexableField)field);
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        try {
            DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);
            List<Map<String, Node>> x = this.get$((IndexReader)indexReader, uri);
            if (x.size() == 0) {
                return null;
            }
            return x.get(0);
        }
        catch (Exception ex) {
            TextIndexLucene.exception(ex);
            return null;
        }
    }

    private static Query parseQuery(String queryString, String primaryField, Analyzer analyzer) throws ParseException {
        QueryParser queryParser = new QueryParser(VER, primaryField, analyzer);
        queryParser.setAllowLeadingWildcard(true);
        Query query = queryParser.parse(queryString);
        return query;
    }

    private List<Map<String, Node>> get$(IndexReader indexReader, String uri) throws ParseException, IOException {
        String escaped = QueryParserBase.escape((String)uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        Query query = TextIndexLucene.parseQuery(qs, this.docDef.getPrimaryField(), this.analyzer);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)1).scoreDocs;
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        for (ScoreDoc sd : sDocs) {
            Document doc = indexSearcher.doc(sd.doc);
            String[] x = doc.getValues(this.docDef.getEntityField());
            if (x.length != 1) {
                // empty if block
            }
            String uriStr = x[0];
            HashMap<String, Node> record = new HashMap<String, Node>();
            Node entity = NodeFactory.createURI((String)uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                String[] values;
                for (String v : values = doc.getValues(f)) {
                    Node n = this.entryToNode(v);
                    record.put(f, n);
                }
                records.add(record);
            }
        }
        return records;
    }

    @Override
    public List<Node> query(String qs) {
        return this.query(qs, MAX_N);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Node> query(String qs, int limit) {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            List<Node> list = this.query$((IndexReader)indexReader, qs, limit);
            return list;
        }
        catch (Exception ex) {
            TextIndexLucene.exception(ex);
            return null;
        }
    }

    private List<Node> query$(IndexReader indexReader, String qs, int limit) throws ParseException, IOException {
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        Query query = TextIndexLucene.parseQuery(qs, this.docDef.getPrimaryField(), this.analyzer);
        if (limit <= 0) {
            limit = MAX_N;
        }
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)limit).scoreDocs;
        ArrayList<Node> results = new ArrayList<Node>();
        for (ScoreDoc sd : sDocs) {
            String[] values;
            Document doc = indexSearcher.doc(sd.doc);
            for (String v : values = doc.getValues(this.docDef.getEntityField())) {
                Node n = TextQueryFuncs.stringToNode(v);
                results.add(n);
            }
        }
        return results;
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode((String)v, null, null);
    }

    private static void exception(Exception ex) {
        throw new TextIndexException(ex);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexed(true);
        ftIRI.freeze();
        ftString = StringField.TYPE_NOT_STORED;
        ftText = TextField.TYPE_NOT_STORED;
    }
}

