/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ParameterizedSparqlString;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.atlas.lib.MultiMap;
import org.apache.jena.atlas.lib.MultiMapToList;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.lucene.analysis.Analyzer;

public class EntityDefinitionAssembler
extends AssemblerBase
implements Assembler {
    public EntityDefinition open(Assembler a, Resource root, Mode mode) {
        Collection c;
        String prologue = "PREFIX : <http://jena.apache.org/text#>   PREFIX list: <http://jena.hpl.hp.com/ARQ/list#> ";
        Model model = root.getModel();
        String qs1 = StrUtils.strjoinNL((String[])new String[]{prologue, "SELECT * {", "  ?eMap  :entityField  ?entityField ;", "         :map ?map ;", "         :defaultField ?dftField .", "  OPTIONAL {", "    ?eMap :graphField ?graphField", "  }", "}"});
        ParameterizedSparqlString pss = new ParameterizedSparqlString(qs1);
        pss.setIri("eMap", root.getURI());
        Query query1 = QueryFactory.create((String)pss.toString());
        QueryExecution qexec1 = QueryExecutionFactory.create((Query)query1, (Model)model);
        ResultSet rs1 = qexec1.execSelect();
        List results = ResultSetFormatter.toList((ResultSet)rs1);
        if (results.size() == 0) {
            Log.warn((Object)((Object)this), (String)("Failed to find a valid EntityMap for : " + root));
            throw new TextIndexException("Failed to find a valid EntityMap for : " + root);
        }
        if (results.size() != 1) {
            Log.warn((Object)((Object)this), (String)("Multiple matches for EntityMap for : " + root));
            throw new TextIndexException("Multiple matches for EntityMap for : " + root);
        }
        QuerySolution qsol1 = (QuerySolution)results.get(0);
        String entityField = qsol1.getLiteral("entityField").getLexicalForm();
        String graphField = qsol1.contains("graphField") ? qsol1.getLiteral("graphField").getLexicalForm() : null;
        String defaultField = qsol1.contains("dftField") ? qsol1.getLiteral("dftField").getLexicalForm() : null;
        MultiMapToList mapDefs = MultiMap.createMapList();
        HashMap<String, Analyzer> analyzerDefs = new HashMap<String, Analyzer>();
        Statement listStmt = root.getProperty(TextVocab.pMap);
        while (listStmt != null) {
            RDFNode n = listStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text list node is not a resource : " + n);
            }
            Resource listResource = (Resource)n;
            if (listResource.equals((Object)RDF.nil)) break;
            Statement listEntryStmt = listResource.getProperty(RDF.first);
            if (listEntryStmt == null) {
                throw new TextIndexException("Text map list is not well formed.  No rdf:first property");
            }
            n = listEntryStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text map list entry is not a resource : " + n);
            }
            Resource listEntry = (Resource)n;
            Statement fieldStatement = listEntry.getProperty(TextVocab.pField);
            if (fieldStatement == null) {
                throw new TextIndexException("Text map entry has no field property");
            }
            n = fieldStatement.getObject();
            if (!n.isLiteral()) {
                throw new TextIndexException("Text map entry field property has no literal value : " + n);
            }
            String field = ((Literal)n).getLexicalForm();
            Statement predicateStatement = listEntry.getProperty(TextVocab.pPredicate);
            if (predicateStatement == null) {
                throw new TextIndexException("Text map entry has no predicate property");
            }
            n = predicateStatement.getObject();
            if (!n.isURIResource()) {
                throw new TextIndexException("Text map entry predicate property has non resource value : " + n);
            }
            Resource predicate = (Resource)n;
            mapDefs.put((Object)field, (Object)predicate.asNode());
            Statement analyzerStatement = listEntry.getProperty(TextVocab.pAnalyzer);
            if (analyzerStatement != null) {
                n = analyzerStatement.getObject();
                if (!n.isResource()) {
                    throw new TextIndexException("Text map entry analyzer property is not a resource : " + n);
                }
                Resource analyzerResource = (Resource)n;
                Analyzer analyzer = (Analyzer)a.open(analyzerResource);
                analyzerDefs.put(field, analyzer);
            }
            listStmt = listResource.getProperty(RDF.rest);
        }
        if (defaultField != null && (c = mapDefs.get((Object)defaultField)) == null) {
            throw new TextIndexException("No definition of primary field '" + defaultField + "'");
        }
        EntityDefinition docDef = new EntityDefinition(entityField, defaultField, graphField);
        for (String f : mapDefs.keys()) {
            for (Node p : mapDefs.get((Object)f)) {
                docDef.set(f, p);
            }
        }
        for (String f : analyzerDefs.keySet()) {
            docDef.setAnalyzer(f, (Analyzer)analyzerDefs.get(f));
        }
        return docDef;
    }
}

