/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.util.QueryExecUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenaTextExample1 {
    static Logger log;

    public static void main(String ... argv) {
        TextQuery.init();
        Dataset ds = JenaTextExample1.createCode();
        JenaTextExample1.loadData(ds, "data.ttl");
        JenaTextExample1.queryData(ds);
    }

    public static Dataset createCode() {
        log.info("Construct an in-memory dataset with in-memory lucene index using code");
        Dataset ds1 = DatasetFactory.createMem();
        EntityDefinition entDef = new EntityDefinition("uri", "text", RDFS.label.asNode());
        RAMDirectory dir = new RAMDirectory();
        Dataset ds = TextDatasetFactory.createLucene(ds1, (Directory)dir, entDef, null);
        return ds;
    }

    public static Dataset createAssembler() {
        log.info("Construct text dataset using an assembler description");
        Dataset ds = DatasetFactory.assemble((String)"text-config.ttl", (String)"http://localhost/jena_example/#text_dataset");
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadData(Dataset dataset, String file) {
        log.info("Start loading");
        long startTime = System.nanoTime();
        dataset.begin(ReadWrite.WRITE);
        try {
            Model m = dataset.getDefaultModel();
            RDFDataMgr.read((Model)m, (String)file);
            dataset.commit();
        }
        finally {
            dataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("Finish loading - %.2fms", time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queryData(Dataset dataset) {
        log.info("START");
        long startTime = System.nanoTime();
        String pre = StrUtils.strjoinNL((String[])new String[]{"PREFIX : <http://example/>", "PREFIX text: <http://jena.apache.org/text#>", "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>"});
        String qs = StrUtils.strjoinNL((String[])new String[]{"SELECT * ", " { ?s text:query (rdfs:label 'X1') ;", "      rdfs:label ?label", " }"});
        dataset.begin(ReadWrite.READ);
        try {
            Query q = QueryFactory.create((String)(pre + "\n" + qs));
            QueryExecution qexec = QueryExecutionFactory.create((Query)q, (Dataset)dataset);
            QueryExecUtils.executeQuery((Prologue)q, (QueryExecution)qexec);
        }
        finally {
            dataset.end();
        }
        long finishTime = System.nanoTime();
        double time = (double)(finishTime - startTime) / 1000000.0;
        log.info(String.format("FINISH - %.2fms", time));
    }

    static {
        LogCtl.setLog4j();
        log = LoggerFactory.getLogger((String)"JenaTextExample");
    }
}

