/*
 * Decompiled with CFR 0.152.
 */
package jena;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.TextIndexSolr;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class textindexdump
extends CmdARQ {
    private static Logger log = LoggerFactory.getLogger(textindexdump.class);
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, "desc", new String[]{"dataset"});
    protected TextIndex textIndex = null;

    public static void main(String ... argv) {
        TextQuery.init();
        new textindexdump(argv).mainRun();
    }

    protected textindexdump(String[] argv) {
        super(argv);
        super.add(assemblerDescDecl, "--desc=", "Assembler description file");
    }

    protected void processModulesAndArgs() {
        String file;
        super.processModulesAndArgs();
        if (super.contains(assemblerDescDecl)) {
            if (this.getValues(assemblerDescDecl).size() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            if (this.getPositional().size() != 0) {
                throw new CmdException("Additional assembler descriptions given");
            }
            file = this.getValue(assemblerDescDecl);
        } else {
            if (this.getNumPositional() != 1) {
                throw new CmdException("Multiple assembler descriptions given");
            }
            file = this.getPositionalArg(0);
        }
        this.textIndex = (TextIndex)AssemblerUtils.build((String)file, (Resource)TextVocab.textIndex);
    }

    protected String getSummary() {
        return this.getCommandName() + " assemblerFile";
    }

    protected void exec() {
        if (this.textIndex instanceof TextIndexLucene) {
            textindexdump.dump((TextIndexLucene)this.textIndex);
        } else if (this.textIndex instanceof TextIndexSolr) {
            textindexdump.dump((TextIndexSolr)this.textIndex);
        } else {
            System.err.println("Unsupported index type : " + Utils.className((Object)this.textIndex));
        }
    }

    private static void dump(TextIndexSolr textIndex) {
        System.err.println("Not implemented : dump Solr index");
    }

    private static void dump(TextIndexLucene textIndex) {
        try {
            ScoreDoc[] sDocs;
            Directory directory = textIndex.getDirectory();
            Analyzer analyzer = textIndex.getQueryAnalyzer();
            DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
            IndexSearcher indexSearcher = new IndexSearcher((IndexReader)indexReader);
            QueryParser queryParser = new QueryParser(TextIndexLucene.VER, textIndex.getDocDef().getPrimaryField(), analyzer);
            Query query = queryParser.parse("*:*");
            for (ScoreDoc sd : sDocs = indexSearcher.search((Query)query, (int)1000).scoreDocs) {
                System.out.println("Doc: " + sd.doc);
                Document doc = indexSearcher.doc(sd.doc);
                for (IndexableField f : doc) {
                    System.out.println("  " + f.name() + " = " + f.stringValue());
                }
            }
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }
}

