/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.core.DatasetChanges;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphMonitor;
import com.hp.hpl.jena.sparql.core.DatasetGraphWithLock;
import com.hp.hpl.jena.sparql.core.GraphView;
import com.hp.hpl.jena.sparql.core.Transactional;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphText
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphText.class);
    private final TextIndex textIndex;
    private final Transactional dsgtxn;
    private final Graph dftGraph;
    private final boolean closeIndexOnClose;
    private final ThreadLocal<ReadWrite> readWriteMode = new ThreadLocal();

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer) {
        this(dsg, index, producer, false);
    }

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer, boolean closeIndexOnClose) {
        super(dsg, (DatasetChanges)producer);
        this.textIndex = index;
        this.dsgtxn = dsg instanceof Transactional ? (Transactional)dsg : new DatasetGraphWithLock(dsg);
        this.dftGraph = GraphView.createDefaultGraph((DatasetGraph)this);
        this.closeIndexOnClose = closeIndexOnClose;
    }

    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public TextIndex getTextIndex() {
        return this.textIndex;
    }

    public Iterator<Node> search(String queryString) {
        return this.search(queryString, null);
    }

    public Iterator<Node> search(String queryString, Node predicate) {
        return this.search(queryString, predicate, -1);
    }

    public Iterator<Node> search(String queryString, int limit) {
        return this.search(queryString, null, limit);
    }

    public Iterator<Node> search(String queryString, Node predicate, int limit) {
        queryString = QueryParserBase.escape((String)queryString);
        if (predicate != null) {
            String f = this.textIndex.getDocDef().getField(predicate);
            queryString = f + ":" + queryString;
        }
        List<Node> results = this.textIndex.query(queryString, limit);
        return results.iterator();
    }

    public void begin(ReadWrite readWrite) {
        this.readWriteMode.set(readWrite);
        this.dsgtxn.begin(readWrite);
        super.getMonitor().start();
    }

    public void abort() {
        try {
            this.dsgtxn.abort();
        }
        catch (Throwable t) {
            log.warn("Exception in abort: " + t.getMessage(), t);
        }
        try {
            this.textIndex.rollback();
        }
        catch (Throwable t) {
            log.warn("Exception in abort: " + t.getMessage(), t);
        }
        this.readWriteMode.set(null);
        super.getMonitor().finish();
    }

    public void commit() {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            try {
                this.textIndex.prepareCommit();
            }
            catch (Throwable t) {
                log.error("Exception in prepareCommit: " + t.getMessage(), t);
                this.abort();
                throw new TextIndexException(t);
            }
        }
        try {
            this.dsgtxn.commit();
            if (this.readWriteMode.get() == ReadWrite.WRITE) {
                this.textIndex.commit();
            }
        }
        catch (Throwable t) {
            log.error("Exception in commit: " + t.getMessage(), t);
            this.abort();
            throw new TextIndexException(t);
        }
        this.readWriteMode.set(null);
        super.getMonitor().finish();
    }

    public boolean isInTransaction() {
        return this.readWriteMode.get() != null;
    }

    public void end() {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            try {
                this.textIndex.rollback();
            }
            catch (Throwable t) {
                log.warn("Exception in end: " + t.getMessage(), t);
            }
        }
        try {
            this.dsgtxn.end();
        }
        catch (Throwable t) {
            log.warn("Exception in end: " + t.getMessage(), t);
        }
        this.readWriteMode.set(null);
        super.getMonitor().finish();
    }

    public void close() {
        super.close();
        if (this.closeIndexOnClose) {
            this.textIndex.close();
        }
    }
}

