/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.util.CharArraySet;

public class StandardAnalyzerAssembler
extends AssemblerBase {
    public Analyzer open(Assembler a, Resource root, Mode mode) {
        if (root.hasProperty(TextVocab.pStopWords)) {
            return this.analyzerWithStopWords(root);
        }
        return new StandardAnalyzer(TextIndexLucene.VER);
    }

    private Analyzer analyzerWithStopWords(Resource root) {
        RDFNode node = root.getProperty(TextVocab.pStopWords).getObject();
        if (!node.isResource()) {
            throw new TextIndexException("text:stopWords property takes a list as a value : " + node);
        }
        CharArraySet stopWords = this.toCharArraySet((Resource)node);
        return new StandardAnalyzer(TextIndexLucene.VER, stopWords);
    }

    private CharArraySet toCharArraySet(Resource list) {
        return new CharArraySet(TextIndexLucene.VER, this.toList(list), false);
    }

    private List<String> toList(Resource list) {
        ArrayList<String> result = new ArrayList<String>();
        Resource current = list;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement stmt = current.getProperty(RDF.first);
            if (stmt == null) {
                throw new TextIndexException("stop word list not well formed");
            }
            RDFNode node = stmt.getObject();
            if (!node.isLiteral()) {
                throw new TextIndexException("stop word is not a literal : " + node);
            }
            result.add(((Literal)node).getLexicalForm());
            stmt = current.getProperty(RDF.rest);
            if (stmt == null) {
                throw new TextIndexException("stop word list not terminated by rdf:nil");
            }
            node = stmt.getObject();
            if (!node.isResource()) {
                throw new TextIndexException("stop word list node is not a resource : " + node);
            }
            current = (Resource)node;
        }
        return result;
    }
}

