/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.assembler.DatasetAssembler;
import com.hp.hpl.jena.sparql.util.Loader;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import java.lang.reflect.Constructor;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.assembler.TextVocab;

public class TextDatasetAssembler
extends AssemblerBase
implements Assembler {
    private DatasetAssembler datasetAssembler = new DatasetAssembler();

    public static Resource getType() {
        return TextVocab.textDataset;
    }

    public Dataset open(Assembler a, Resource root, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pDataset);
        Resource index = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pIndex);
        Resource textDocProducerNode = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pTextDocProducer);
        Dataset ds = (Dataset)a.open(dataset);
        TextIndex textIndex = (TextIndex)a.open(index);
        TextDocProducer textDocProducer = null;
        if (null != textDocProducerNode) {
            Class c = Loader.loadClass((String)textDocProducerNode.getURI(), TextDocProducer.class);
            try {
                Constructor ctor = c.getConstructor(TextIndex.class);
                textDocProducer = (TextDocProducer)ctor.newInstance(textIndex);
            }
            catch (Exception ex) {
                String className = textDocProducerNode.getURI().substring("java:".length());
                Log.warn(Loader.class, (String)("Exception during instantiation '" + className + "': " + ex.getMessage()));
                return null;
            }
        }
        Dataset dst = TextDatasetFactory.create(ds, textIndex, true, textDocProducer);
        return dst;
    }
}

