/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;

public class TextQueryFuncs {
    public static String subjectToString(Node s) {
        if (s == null) {
            throw new IllegalArgumentException("Subject node can not be null");
        }
        if (!s.isURI() && !s.isBlank()) {
            throw new TextIndexException("Found a subject that is not a URI nor a blank node: " + s);
        }
        return TextQueryFuncs.nodeToString(s);
    }

    public static String graphNodeToString(Node g) {
        if (g == null) {
            return null;
        }
        if (!g.isURI() && !g.isBlank()) {
            throw new TextIndexException("Found a graph label that is not a URI nor a blank node: " + g);
        }
        return TextQueryFuncs.nodeToString(g);
    }

    private static String nodeToString(Node n) {
        return n.isURI() ? n.getURI() : "_:" + n.getBlankNodeLabel();
    }

    public static Node stringToNode(String v) {
        if (v.startsWith("_:")) {
            v = v.substring("_:".length());
            return NodeFactory.createBlankNode((String)v);
        }
        return NodeFactory.createURI((String)v);
    }

    public static Entity entityFromQuad(EntityDefinition defn, Quad quad) {
        return TextQueryFuncs.entityFromQuad(defn, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public static Entity entityFromQuad(EntityDefinition defn, Node g, Node s, Node p, Node o) {
        String field = defn.getField(p);
        if (field == null) {
            return null;
        }
        String x = TextQueryFuncs.subjectToString(s);
        String graphText = TextQueryFuncs.graphNodeToString(g);
        String language = o.getLiteral().language();
        RDFDatatype datatype = o.getLiteral().getDatatype();
        Entity entity = new Entity(x, graphText, language, datatype);
        String graphField = defn.getGraphField();
        if (defn.getGraphField() != null) {
            entity.put(graphField, graphText);
        }
        if (!o.isLiteral()) {
            Log.warn(TextQuery.class, (String)("Not a literal value for mapped field-predicate: " + field + " :: " + FmtUtils.stringForString((String)field)));
            return null;
        }
        entity.put(field, o.getLiteralLexicalForm());
        return entity;
    }
}

