/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexSolr
implements TextIndex {
    private static final Logger log = LoggerFactory.getLogger(TextIndexSolr.class);
    private final SolrServer solrServer;
    private final EntityDefinition docDef;
    private static final int MAX_N = 10000;

    public TextIndexSolr(SolrServer server, EntityDefinition def) {
        this.solrServer = server;
        this.docDef = def;
    }

    @Override
    public void updateEntity(Entity entity) {
        throw new RuntimeException("TextIndexSolr.updateEntity not implemented.");
    }

    @Override
    public void prepareCommit() {
    }

    @Override
    public void commit() {
        try {
            this.solrServer.commit();
        }
        catch (SolrServerException e) {
            throw new TextIndexException(e);
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    @Override
    public void rollback() {
        try {
            this.solrServer.rollback();
        }
        catch (SolrServerException e) {
            throw new TextIndexException(e);
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    public void close() {
        if (this.solrServer != null) {
            this.solrServer.shutdown();
        }
    }

    @Override
    public void addEntity(Entity entity) {
        try {
            SolrInputDocument doc = this.solrDoc(entity);
            this.solrServer.add(doc);
        }
        catch (Exception e) {
            TextIndexSolr.exception(e);
        }
    }

    @Override
    public void deleteEntity(Entity entity) {
    }

    private SolrInputDocument solrDoc(Entity entity) {
        SolrInputDocument doc = new SolrInputDocument();
        doc.addField(this.docDef.getEntityField(), (Object)entity.getId());
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            doc.addField(graphField, (Object)entity.getGraph());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : entity.getMap().entrySet()) {
            map.put("add", e.getValue());
            doc.addField(e.getKey(), map);
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        String escaped = ClientUtils.escapeQueryChars((String)uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        SolrDocumentList solrResults = this.solrQuery(qs, 1);
        List<Map<String, Node>> records = this.process(solrResults);
        if (records.size() == 0) {
            return null;
        }
        if (records.size() > 1) {
            log.warn("Multiple docs for one URI: " + uri);
        }
        return records.get(0);
    }

    private List<Map<String, Node>> process(SolrDocumentList solrResults) {
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        for (SolrDocument sd : solrResults) {
            HashMap<String, Node> record = new HashMap<String, Node>();
            String uriStr = (String)sd.getFieldValue(this.docDef.getEntityField());
            Node entity = NodeFactory.createURI((String)uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                Object obj = sd.getFieldValue(f);
                if (obj == null) continue;
                if (obj instanceof List) {
                    List vals = (List)obj;
                    continue;
                }
                String v = (String)obj;
                Node n = this.entryToNode(v);
                record.put(f, n);
            }
            records.add(record);
        }
        return records;
    }

    @Override
    public List<TextHit> query(Node property, String qs) {
        return this.query(property, qs, 0);
    }

    @Override
    public List<TextHit> query(Node property, String qs, int limit) {
        SolrDocumentList solrResults = this.solrQuery(qs, limit);
        List<TextHit> results = new ArrayList<TextHit>();
        for (SolrDocument sd : solrResults) {
            String str = (String)sd.getFieldValue(this.docDef.getEntityField());
            Node n = TextQueryFuncs.stringToNode(str);
            Float score = (Float)sd.getFirstValue("score");
            Node literal = null;
            String field = property != null ? this.docDef.getField(property) : this.docDef.getPrimaryField();
            String value = (String)sd.getFirstValue(field);
            if (value != null) {
                literal = NodeFactory.createLiteral((String)value);
            }
            TextHit hit = new TextHit(n, score.floatValue(), literal);
            results.add(hit);
        }
        if (limit > 0 && results.size() > limit) {
            results = results.subList(0, limit);
        }
        return results;
    }

    private SolrDocumentList solrQuery(String qs, int limit) {
        SolrQuery sq = new SolrQuery(qs);
        sq.setIncludeScore(true);
        if (limit > 0) {
            sq.setRows(Integer.valueOf(limit));
        } else {
            sq.setRows(Integer.valueOf(10000));
        }
        try {
            sq.add("df", new String[]{this.docDef.getPrimaryField()});
            QueryResponse rsp = this.solrServer.query((SolrParams)sq);
            SolrDocumentList docs = rsp.getResults();
            return docs;
        }
        catch (SolrServerException e) {
            TextIndexSolr.exception((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode((String)v, null, null);
    }

    public SolrServer getServer() {
        return this.solrServer;
    }

    private static Void exception(Exception ex) {
        throw new TextIndexException(ex);
    }
}

