/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.io.IOException;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexLucene;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;

public class TextIndexLuceneMultilingual
extends TextIndexLucene {
    public TextIndexLuceneMultilingual(Directory directory, TextIndexConfig config) {
        super(directory, config);
        if (config.getEntDef().getLangField() == null) {
            config.getEntDef().setLangField("lang");
        }
    }

    @Override
    protected void updateDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        Term term = new Term(this.getDocDef().getEntityField(), entity.getId());
        Analyzer analyzer = Util.getLocalizedAnalyzer(entity.getLanguage());
        if (analyzer == null) {
            analyzer = this.getAnalyzer();
        }
        this.getIndexWriter().updateDocument(term, (Iterable)doc, analyzer);
    }

    @Override
    protected void addDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        Analyzer analyzer = Util.getLocalizedAnalyzer(entity.getLanguage());
        if (analyzer == null) {
            analyzer = this.getAnalyzer();
        }
        this.getIndexWriter().addDocument((Iterable)doc, analyzer);
    }

    @Override
    protected Query preParseQuery(String queryString, Analyzer analyzer) throws ParseException {
        String lang;
        if (queryString.contains(this.getDocDef().getLangField() + ":") && !"*".equals(lang = queryString.substring(queryString.lastIndexOf(":") + 1))) {
            analyzer = Util.getLocalizedAnalyzer(lang);
        }
        return super.preParseQuery(queryString, analyzer);
    }
}

