/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import org.apache.jena.graph.Node;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.core.QuadAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextDocProducerTriples
implements TextDocProducer {
    private static Logger log = LoggerFactory.getLogger(TextDocProducerTriples.class);
    private final EntityDefinition defn;
    private final TextIndex indexer;
    private final ThreadLocal<Boolean> inTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public TextDocProducerTriples(TextIndex indexer) {
        this.defn = indexer.getDocDef();
        this.indexer = indexer;
    }

    public void start() {
        this.inTransaction.set(true);
    }

    public void finish() {
        this.inTransaction.set(false);
    }

    public void reset() {
    }

    public void change(QuadAction qaction, Node g, Node s, Node p, Node o) {
        if (qaction != QuadAction.ADD && qaction != QuadAction.DELETE) {
            return;
        }
        Entity entity = TextQueryFuncs.entityFromQuad(this.defn, g, s, p, o);
        if (entity != null) {
            if (qaction == QuadAction.ADD) {
                this.indexer.addEntity(entity);
                if (!this.inTransaction.get().booleanValue()) {
                    this.indexer.commit();
                }
            } else if (qaction == QuadAction.DELETE) {
                this.indexer.deleteEntity(entity);
                if (!this.inTransaction.get().booleanValue()) {
                    this.indexer.commit();
                }
            }
        }
    }
}

