/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.analyzer.ConfigurableAnalyzer;
import org.apache.jena.query.text.assembler.GenericTokenizerAssembler;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;

public class DefineTokenizersAssembler {
    public static boolean open(Assembler a, Resource list) {
        Resource current = list;
        boolean isMultilingualSupport = false;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement restStmt;
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("parameter list not well formed: " + current);
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isResource()) {
                throw new TextIndexException("parameter specification must be an anon resource : " + first);
            }
            Resource adding = (Resource)first;
            if (adding.hasProperty(TextVocab.pTokenizer)) {
                Statement tokenizerStmt = adding.getProperty(TextVocab.pTokenizer);
                RDFNode tokenizerNode = tokenizerStmt.getObject();
                if (!tokenizerNode.isResource()) {
                    throw new TextIndexException("addTokenizers text:tokenizer must be an tokenizer spec resource: " + tokenizerNode);
                }
                GenericTokenizerAssembler.TokenizerSpec spec = (GenericTokenizerAssembler.TokenizerSpec)a.open((Resource)tokenizerNode);
                if (adding.hasProperty(TextVocab.pDefTokenizer)) {
                    Statement defStmt = adding.getProperty(TextVocab.pDefTokenizer);
                    Resource id = defStmt.getResource();
                    if (id.getURI() != null) {
                        ConfigurableAnalyzer.defineTokenizer(id.getURI(), spec);
                    } else {
                        throw new TextIndexException("addTokenizers text:defineTokenizer property must be a non-blank resource: " + adding);
                    }
                }
            }
            if ((restStmt = current.getProperty(RDF.rest)) == null) {
                throw new TextIndexException("parameter list not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("parameter list node is not a resource : " + rest);
            }
            current = (Resource)rest;
        }
        return isMultilingualSupport;
    }
}

