/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.io.File;
import java.io.IOException;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;

public class TextIndexLuceneAssembler
extends AssemblerBase {
    public TextIndex open(Assembler a, Resource root, Mode mode) {
        try {
            RAMDirectory directory;
            if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)TextVocab.pDirectory)) {
                throw new TextIndexException("No 'text:directory' property on " + root);
            }
            RDFNode n = root.getProperty(TextVocab.pDirectory).getObject();
            if (n.isLiteral()) {
                String literalValue = n.asLiteral().getLexicalForm();
                if (literalValue.equals("mem")) {
                    directory = new RAMDirectory();
                } else {
                    File dir = new File(literalValue);
                    directory = FSDirectory.open((File)dir);
                }
            } else {
                Resource x = n.asResource();
                String path = IRILib.IRIToFilename((String)x.getURI());
                File dir = new File(path);
                directory = FSDirectory.open((File)dir);
            }
            Analyzer analyzer = null;
            Statement analyzerStatement = root.getProperty(TextVocab.pAnalyzer);
            if (null != analyzerStatement) {
                RDFNode aNode = analyzerStatement.getObject();
                if (!aNode.isResource()) {
                    throw new TextIndexException("Text analyzer property is not a resource : " + aNode);
                }
                Resource analyzerResource = (Resource)aNode;
                analyzer = (Analyzer)a.open(analyzerResource);
            }
            Analyzer queryAnalyzer = null;
            Statement queryAnalyzerStatement = root.getProperty(TextVocab.pQueryAnalyzer);
            if (null != queryAnalyzerStatement) {
                RDFNode qaNode = queryAnalyzerStatement.getObject();
                if (!qaNode.isResource()) {
                    throw new TextIndexException("Text query analyzer property is not a resource : " + qaNode);
                }
                Resource analyzerResource = (Resource)qaNode;
                queryAnalyzer = (Analyzer)a.open(analyzerResource);
            }
            String queryParser = null;
            Statement queryParserStatement = root.getProperty(TextVocab.pQueryParser);
            if (null != queryParserStatement) {
                RDFNode qpNode = queryParserStatement.getObject();
                if (!qpNode.isResource()) {
                    throw new TextIndexException("Text query parser property is not a resource : " + qpNode);
                }
                Resource parserResource = (Resource)qpNode;
                queryParser = parserResource.getLocalName();
            }
            boolean isMultilingualSupport = false;
            Statement mlSupportStatement = root.getProperty(TextVocab.pMultilingualSupport);
            if (null != mlSupportStatement) {
                RDFNode mlsNode = mlSupportStatement.getObject();
                if (!mlsNode.isLiteral()) {
                    throw new TextIndexException("text:multilingualSupport property must be a string : " + mlsNode);
                }
                isMultilingualSupport = mlsNode.asLiteral().getBoolean();
            }
            boolean storeValues = false;
            Statement storeValuesStatement = root.getProperty(TextVocab.pStoreValues);
            if (null != storeValuesStatement) {
                RDFNode svNode = storeValuesStatement.getObject();
                if (!svNode.isLiteral()) {
                    throw new TextIndexException("text:storeValues property must be a string : " + svNode);
                }
                storeValues = svNode.asLiteral().getBoolean();
            }
            Resource r = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pEntityMap);
            EntityDefinition docDef = (EntityDefinition)a.open(r);
            TextIndexConfig config = new TextIndexConfig(docDef);
            config.setAnalyzer(analyzer);
            config.setQueryAnalyzer(queryAnalyzer);
            config.setQueryParser(queryParser);
            config.setMultilingualSupport(isMultilingualSupport);
            config.setValueStored(storeValues);
            return TextDatasetFactory.createLuceneIndex((Directory)directory, config);
        }
        catch (IOException e) {
            IO.exception((IOException)e);
            return null;
        }
    }
}

