/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;

public class GenericAnalyzerAssembler
extends AssemblerBase {
    public static final String TYPE_ANALYZER = "TypeAnalyzer";
    public static final String TYPE_BOOL = "TypeBoolean";
    public static final String TYPE_FILE = "TypeFile";
    public static final String TYPE_INT = "TypeInt";
    public static final String TYPE_SET = "TypeSet";
    public static final String TYPE_STRING = "TypeString";

    public Analyzer open(Assembler a, Resource root, Mode mode) {
        if (root.hasProperty(TextVocab.pClass)) {
            String className = root.getProperty(TextVocab.pClass).getString();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Log.error((Object)((Object)this), (String)("Analyzer class " + className + " not found. " + e.getMessage()), (Throwable)e);
                return null;
            }
            if (!Analyzer.class.isAssignableFrom(clazz)) {
                Log.error((Object)((Object)this), (String)(clazz.getName() + " has to be a subclass of " + Analyzer.class.getName()));
                return null;
            }
            if (root.hasProperty(TextVocab.pParams)) {
                RDFNode node = root.getProperty(TextVocab.pParams).getObject();
                if (!node.isResource()) {
                    throw new TextIndexException("text:params must be a list of parameter resources: " + node);
                }
                List<ParamSpec> specs = this.getParamSpecs((Resource)node);
                Class[] paramClasses = new Class[specs.size()];
                Object[] paramValues = new Object[specs.size()];
                for (int i = 0; i < specs.size(); ++i) {
                    ParamSpec spec = specs.get(i);
                    paramClasses[i] = spec.getValueClass();
                    paramValues[i] = spec.getValue();
                }
                return this.newAnalyzer(clazz, paramClasses, paramValues);
            }
            return this.newAnalyzer(clazz, new Class[0], new Object[0]);
        }
        throw new TextIndexException("text:class property is required by GenericAnalyzer: " + root);
    }

    private Analyzer newAnalyzer(Class<?> clazz, Class<?>[] paramClasses, Object[] paramValues) {
        String className = clazz.getName();
        try {
            Constructor<?> cstr = clazz.getDeclaredConstructor(paramClasses);
            return (Analyzer)cstr.newInstance(paramValues);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            Log.error((Object)((Object)this), (String)("Exception while instantiating analyzer class " + className + ". " + e.getMessage()), (Throwable)e);
        }
        catch (NoSuchMethodException ex) {
            Log.error((Object)((Object)this), (String)("Could not find matching analyzer class constructor for " + className + " " + ex.getMessage()), (Throwable)ex);
        }
        return null;
    }

    private List<ParamSpec> getParamSpecs(Resource list) {
        ArrayList<ParamSpec> result = new ArrayList<ParamSpec>();
        Resource current = list;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("parameter list not well formed: " + current);
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isResource()) {
                throw new TextIndexException("parameter specification must be an anon resource : " + first);
            }
            result.add(this.getParamSpec((Resource)first));
            Statement restStmt = current.getProperty(RDF.rest);
            if (restStmt == null) {
                throw new TextIndexException("parameter list not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("parameter list node is not a resource : " + rest);
            }
            current = (Resource)rest;
        }
        return result;
    }

    private ParamSpec getParamSpec(Resource node) {
        Statement nameStmt = node.getProperty(TextVocab.pParamName);
        Statement typeStmt = node.getProperty(TextVocab.pParamType);
        Statement valueStmt = node.getProperty(TextVocab.pParamValue);
        if (typeStmt == null) {
            throw new TextIndexException("Parameter specification must have a text:paramType: " + node);
        }
        Resource typeRes = typeStmt.getResource();
        String type = typeRes.getLocalName();
        String name = this.getStringValue(nameStmt);
        String value = this.getStringValue(valueStmt);
        switch (type) {
            case "TypeString": {
                if (value == null) {
                    throw new TextIndexException("Value for string param: " + name + " must not be empty!");
                }
                return new ParamSpec(name, value, String.class);
            }
            case "TypeFile": {
                if (value == null) {
                    throw new TextIndexException("Value for file param must exist and must contain a file name.");
                }
                try {
                    FileReader fileReader = new FileReader(value);
                    return new ParamSpec(name, fileReader, Reader.class);
                }
                catch (FileNotFoundException ex) {
                    throw new TextIndexException("File " + value + " for param " + name + " not found!");
                }
            }
            case "TypeSet": {
                if (valueStmt == null) {
                    throw new TextIndexException("A set param spec must have a text:paramValue:" + node);
                }
                RDFNode valueNode = valueStmt.getObject();
                if (!valueNode.isResource()) {
                    throw new TextIndexException("A set param spec text:paramValue must be a list of strings: " + valueNode);
                }
                List<String> values = this.toStrings((Resource)valueNode);
                return new ParamSpec(name, new CharArraySet(values, false), CharArraySet.class);
            }
            case "TypeInt": {
                if (value == null) {
                    throw new TextIndexException("Value for int param: " + name + " must not be empty!");
                }
                int n = ((Literal)valueStmt.getObject()).getInt();
                return new ParamSpec(name, n, Integer.TYPE);
            }
            case "TypeBoolean": {
                if (value == null) {
                    throw new TextIndexException("Value for boolean param: " + name + " must not be empty!");
                }
                boolean b = ((Literal)valueStmt.getObject()).getBoolean();
                return new ParamSpec(name, b, Boolean.TYPE);
            }
            case "TypeAnalyzer": {
                if (valueStmt == null) {
                    throw new TextIndexException("Analyzer param spec must have a text:paramValue:" + node);
                }
                RDFNode valueNode = valueStmt.getObject();
                if (!valueNode.isResource()) {
                    throw new TextIndexException("Analyzer param spec text:paramValue must be an analyzer spec resource: " + valueNode);
                }
                Analyzer analyzer = (Analyzer)Assembler.general.open((Resource)valueNode);
                return new ParamSpec(name, analyzer, Analyzer.class);
            }
        }
        Log.error((Object)((Object)this), (String)("Unknown parameter type: " + type + " for param: " + name + " with value: " + value));
        return null;
    }

    private String getStringValue(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        RDFNode node = stmt.getObject();
        if (node.isLiteral()) {
            return ((Literal)node).getLexicalForm();
        }
        return null;
    }

    private List<String> toStrings(Resource list) {
        ArrayList<String> result = new ArrayList<String>();
        Resource current = list;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("param spec of type set not well formed");
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isLiteral()) {
                throw new TextIndexException("param spec of type set item is not a literal: " + first);
            }
            result.add(((Literal)first).getLexicalForm());
            Statement restStmt = current.getProperty(RDF.rest);
            if (restStmt == null) {
                throw new TextIndexException("param spec of type set not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("param spec of type set rest is not a resource: " + rest);
            }
            current = (Resource)rest;
        }
        return result;
    }

    private static final class ParamSpec {
        private final String name;
        private final Object value;
        private final Class<?> clazz;

        public ParamSpec(String key, Object value) {
            this(key, value, value.getClass());
        }

        public ParamSpec(String key, Object value, Class<?> clazz) {
            this.name = key;
            this.value = value;
            this.clazz = clazz;
        }

        public String getKey() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public Class<?> getValueClass() {
            return this.clazz;
        }
    }
}

