/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.sparql.core.DatasetChanges;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphMonitor;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Transactional;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetGraphText
extends DatasetGraphMonitor
implements Transactional {
    private static Logger log = LoggerFactory.getLogger(DatasetGraphText.class);
    private final TextIndex textIndex;
    private final Graph dftGraph;
    private final boolean closeIndexOnClose;
    private final Object txnExitLock = new Object();
    private final ThreadLocal<ReadWrite> readWriteMode = new ThreadLocal();

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer) {
        this(dsg, index, producer, false);
    }

    public DatasetGraphText(DatasetGraph dsg, TextIndex index, TextDocProducer producer, boolean closeIndexOnClose) {
        super(dsg, (DatasetChanges)producer);
        this.textIndex = index;
        this.dftGraph = GraphView.createDefaultGraph((DatasetGraph)this);
        this.closeIndexOnClose = closeIndexOnClose;
    }

    public Graph getDefaultGraph() {
        return this.dftGraph;
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public TextIndex getTextIndex() {
        return this.textIndex;
    }

    public Iterator<TextHit> search(String queryString) {
        return this.search(queryString, null);
    }

    public Iterator<TextHit> search(String queryString, Node predicate) {
        return this.search(queryString, predicate, -1);
    }

    public Iterator<TextHit> search(String queryString, int limit) {
        return this.search(queryString, null, limit);
    }

    public Iterator<TextHit> search(String queryString, Node predicate, int limit) {
        return this.search(queryString, predicate, null, null, limit);
    }

    public Iterator<TextHit> search(String queryString, Node predicate, String graphURI, String lang, int limit) {
        queryString = QueryParserBase.escape((String)queryString);
        if (predicate != null) {
            String f = this.textIndex.getDocDef().getField(predicate);
            queryString = f + ":" + queryString;
        }
        List<TextHit> results = this.textIndex.query(predicate, queryString, graphURI, lang, limit);
        return results.iterator();
    }

    public void begin(ReadWrite readWrite) {
        this.readWriteMode.set(readWrite);
        super.begin(readWrite);
        super.getMonitor().start();
    }

    public void commit() {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.commit_W();
        } else {
            this.commit_R();
        }
    }

    private void commit_R() {
        super.getMonitor().finish();
        super.commit();
        this.readWriteMode.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit_W() {
        Object object = this.txnExitLock;
        synchronized (object) {
            super.getMonitor().finish();
            try {
                this.textIndex.prepareCommit();
            }
            catch (Throwable t) {
                log.error("Exception in prepareCommit: " + t.getMessage(), t);
                this.abort();
                throw new TextIndexException(t);
            }
            try {
                super.commit();
                this.textIndex.commit();
            }
            catch (Throwable t) {
                log.error("Exception in commit: " + t.getMessage(), t);
                this.abort();
                throw new TextIndexException(t);
            }
            this.readWriteMode.set(null);
        }
    }

    public void abort() {
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.abort_W();
        } else {
            this.abort_R();
        }
    }

    private void abort_R() {
        super.getMonitor().finish();
        try {
            super.abort();
        }
        catch (Throwable t) {
            log.warn("Exception in abort: " + t.getMessage(), t);
        }
        this.readWriteMode.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort_W() {
        Object object = this.txnExitLock;
        synchronized (object) {
            super.getMonitor().finish();
            try {
                super.abort();
            }
            catch (Throwable t) {
                log.warn("Exception in abort: " + t.getMessage(), t);
            }
            try {
                this.textIndex.rollback();
            }
            catch (Throwable t) {
                log.warn("Exception in abort: " + t.getMessage(), t);
            }
            this.readWriteMode.set(null);
        }
    }

    public boolean isInTransaction() {
        return this.readWriteMode.get() != null;
    }

    public void end() {
        if (!this.isInTransaction()) {
            super.end();
            return;
        }
        if (this.readWriteMode.get() == ReadWrite.WRITE) {
            this.abort();
        }
        super.end();
        super.getMonitor().finish();
        this.readWriteMode.set(null);
    }

    public boolean supportsTransactions() {
        return super.supportsTransactions();
    }

    public boolean supportsTransactionAbort() {
        return super.supportsTransactionAbort();
    }

    public void close() {
        super.close();
        if (this.closeIndexOnClose) {
            this.textIndex.close();
        }
    }
}

