/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.ext.com.google.common.collect.LinkedListMultimap;
import org.apache.jena.ext.com.google.common.collect.ListMultimap;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.NamedGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
extends PropertyFunctionBase {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex textIndex = null;
    private boolean warningIssued = false;
    private static final Symbol cacheSymbol = Symbol.create((String)"TextQueryPF.cache");
    private static final int CACHE_SIZE = 10;

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        int size;
        super.build(argSubject, predicate, argObject, execCxt);
        DatasetGraph dsg = execCxt.getDataset();
        this.textIndex = TextQueryPF.chooseTextIndex(execCxt, dsg);
        if (argSubject.isList() && (size = argSubject.getArgListSize()) != 2 && size != 3) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, not 2 or 3: " + argSubject);
        }
        if (argObject.isList()) {
            List list = argObject.getArgList();
            if (list.size() == 0) {
                throw new QueryBuildException("Zero-length argument list");
            }
            if (list.size() > 4) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
        }
    }

    private static TextIndex chooseTextIndex(ExecutionContext execCxt, DatasetGraph dsg) {
        Object obj = execCxt.getContext().get(TextQuery.textIndex);
        if (obj != null) {
            try {
                return (TextIndex)obj;
            }
            catch (ClassCastException ex) {
                Log.warn(TextQueryPF.class, (String)("Context setting '" + TextQuery.textIndex + "'is not a TextIndex"));
            }
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        Log.warn(TextQueryPF.class, (String)"Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    private String extractArg(String prefix, List<Node> objArgs) {
        String value = null;
        int pos = 0;
        for (Node node : objArgs) {
            String arg;
            if (node.isLiteral() && (arg = node.getLiteral().toString()).startsWith(prefix + ":")) {
                value = arg.split(":")[1];
                break;
            }
            ++pos;
        }
        if (value != null) {
            objArgs.remove(pos);
        }
        return value;
    }

    public QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        QueryIterator qIter;
        if (this.textIndex == null) {
            if (!this.warningIssued) {
                Log.warn(((Object)((Object)this)).getClass(), (String)"No text index - no text search performed");
                this.warningIssued = true;
            }
            return IterLib.result((Binding)binding, (ExecutionContext)execCxt);
        }
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        Node s = null;
        Node score = null;
        Node literal = null;
        if (argSubject.isList()) {
            s = argSubject.getArg(0);
            score = argSubject.getArg(1);
            if (!score.isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + argSubject);
            }
            if (argSubject.getArgListSize() > 2 && !(literal = argSubject.getArg(2)).isVariable()) {
                throw new QueryExecException("Hit literal is not a variable: " + argSubject);
            }
        } else {
            s = argSubject.getArg();
        }
        if (s.isLiteral()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        StrMatch match = this.objectToStruct(argObject, true);
        if (match == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        QueryIterator queryIterator = qIter = Var.isVar((Node)s) ? this.variableSubject(binding, s, score, literal, match, execCxt) : this.concreteSubject(binding, s, score, literal, match, execCxt);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, (long)match.getLimit(), execCxt);
        }
        return qIter;
    }

    private QueryIterator resultsToQueryIterator(Binding binding, Node s, Node score, Node literal, Collection<TextHit> results, ExecutionContext execCxt) {
        Var sVar = Var.isVar((Node)s) ? Var.alloc((Node)s) : null;
        Var scoreVar = score == null ? null : Var.alloc((Node)score);
        Var literalVar = literal == null ? null : Var.alloc((Node)literal);
        Function<TextHit, Binding> converter = hit -> {
            if (score == null && literal == null) {
                return sVar != null ? BindingFactory.binding((Binding)binding, (Var)sVar, (Node)hit.getNode()) : BindingFactory.binding((Binding)binding);
            }
            BindingMap bmap = BindingFactory.create((Binding)binding);
            if (sVar != null) {
                bmap.add(sVar, hit.getNode());
            }
            if (scoreVar != null) {
                bmap.add(scoreVar, NodeFactoryExtra.floatToNode((float)hit.getScore()));
            }
            if (literalVar != null) {
                bmap.add(literalVar, hit.getLiteral());
            }
            return bmap;
        };
        Iterator bIter = Iter.map(results.iterator(), converter);
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bIter, execCxt);
        return qIter;
    }

    private QueryIterator variableSubject(Binding binding, Node s, Node score, Node literal, StrMatch match, ExecutionContext execCxt) {
        ListMultimap<String, TextHit> results = this.query(match.getProperty(), match.getQueryString(), match.getLang(), match.getLimit(), execCxt);
        Collection r = results.values();
        return this.resultsToQueryIterator(binding, s, score, literal, r, execCxt);
    }

    private QueryIterator concreteSubject(Binding binding, Node s, Node score, Node literal, StrMatch match, ExecutionContext execCxt) {
        ListMultimap<String, TextHit> x = this.query(match.getProperty(), match.getQueryString(), match.getLang(), -1, execCxt);
        if (x == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        List r = x.get((Object)TextQueryFuncs.subjectToString(s));
        return this.resultsToQueryIterator(binding, s, score, literal, r, execCxt);
    }

    private ListMultimap<String, TextHit> query(Node property, String queryString, String lang, int limit, ExecutionContext execCxt) {
        String graphURI = this.chooseGraphURI(execCxt);
        if (graphURI == null) {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query: " + queryString));
            if (log.isDebugEnabled()) {
                log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
            }
        } else {
            Explain.explain((Context)execCxt.getContext(), (String)("Text query <" + graphURI + ">: " + queryString));
            if (log.isDebugEnabled()) {
                log.debug("Text query: {} <{}> ({})", new Object[]{queryString, graphURI, limit});
            }
        }
        String cacheKey = limit + " " + property + " " + queryString + " " + lang + " " + graphURI;
        Cache queryCache = (Cache)execCxt.getContext().get(cacheSymbol);
        if (queryCache == null) {
            queryCache = CacheFactory.createCache((int)10);
            execCxt.getContext().put(cacheSymbol, (Object)queryCache);
        }
        ListMultimap results = (ListMultimap)queryCache.getOrFill((Object)cacheKey, () -> this.performQuery(property, queryString, graphURI, lang, limit));
        return results;
    }

    private String chooseGraphURI(ExecutionContext execCxt) {
        NamedGraph namedGraph;
        String graphURI = null;
        Graph activeGraph = execCxt.getActiveGraph();
        if (this.textIndex.getDocDef().getGraphField() != null && activeGraph instanceof NamedGraph && !Quad.isUnionGraph((Node)(namedGraph = (NamedGraph)activeGraph).getGraphName())) {
            graphURI = namedGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(namedGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
        }
        return graphURI;
    }

    private ListMultimap<String, TextHit> performQuery(Node property, String queryString, String graphURI, String lang, int limit) {
        List<TextHit> resultList = this.textIndex.query(property, queryString, graphURI, lang, limit);
        LinkedListMultimap results = LinkedListMultimap.create();
        for (TextHit result : resultList) {
            results.put((Object)TextQueryFuncs.subjectToString(result.getNode()), (Object)result);
        }
        return results;
    }

    private StrMatch objectToStruct(PropFuncArg argObject, boolean executionTime) {
        String lang;
        EntityDefinition docDef = this.textIndex.getDocDef();
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                if (executionTime) {
                    log.warn("Object to text query is not a literal");
                }
                return null;
            }
            RDFDatatype dt = o.getLiteralDatatype();
            if (dt != null && dt != XSDDatatype.XSDstring) {
                log.warn("Object to text query is not a string");
                return null;
            }
            String qs = o.getLiteralLexicalForm();
            return new StrMatch(null, qs, null, -1, 0.0f);
        }
        List list = argObject.getArgList();
        if (list.size() == 0 || list.size() > 4) {
            throw new TextIndexException("Change in object list size");
        }
        Node predicate = null;
        String field = null;
        int idx = 0;
        Node x = (Node)list.get(0);
        if (x.isURI()) {
            predicate = x;
            if (++idx >= list.size()) {
                throw new TextIndexException("Property specificed but no query string : " + list);
            }
            x = (Node)list.get(idx);
            field = docDef.getField(predicate);
            if (field == null) {
                log.warn("Predicate not indexed: " + predicate);
                return null;
            }
        }
        if (!x.isLiteral()) {
            if (executionTime) {
                log.warn("Text query string is not a literal " + list);
            }
            return null;
        }
        if (x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            log.warn("Text query is not a string " + list);
            return null;
        }
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            ++idx;
            if (!x.isLiteral()) {
                if (executionTime) {
                    log.warn("Text query limit is not an integer " + x);
                }
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            int n = limit = v < 0 ? -1 : v;
        }
        if ((lang = this.extractArg("lang", list)) != null && this.textIndex.getDocDef().getLangField() == null) {
            log.warn("lang argument is ignored if langField not set in the index configuration");
        }
        return new StrMatch(predicate, queryString, lang, limit, score);
    }

    class StrMatch {
        private final Node property;
        private final String queryString;
        private final String lang;
        private final int limit;
        private final float scoreLimit;

        public StrMatch(Node property, String queryString, String lang, int limit, float scoreLimit) {
            this.property = property;
            this.queryString = queryString;
            this.lang = lang;
            this.limit = limit;
            this.scoreLimit = scoreLimit;
        }

        public Node getProperty() {
            return this.property;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public String getLang() {
            return this.lang;
        }

        public int getLimit() {
            return this.limit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }
    }
}

