/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import org.apache.jena.query.text.analyzer.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;

public class MultilingualAnalyzer
extends DelegatingAnalyzerWrapper {
    private Analyzer defaultAnalyzer;

    public MultilingualAnalyzer(Analyzer defaultAnalyzer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        int idx = fieldName.lastIndexOf("_");
        if (idx == -1) {
            return this.defaultAnalyzer;
        }
        String lang = fieldName.substring(idx + 1);
        Analyzer analyzer = Util.getLocalizedAnalyzer(lang);
        return analyzer != null ? analyzer : this.defaultAnalyzer;
    }

    public String toString() {
        return "MultilingualAnalyzer(default=" + this.defaultAnalyzer + ")";
    }
}

