/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import java.util.List;
import org.apache.jena.query.text.TextIndexException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class ConfigurableAnalyzer
extends Analyzer {
    private final String tokenizer;
    private final List<String> filters;

    private Tokenizer getTokenizer(String tokenizerName) {
        switch (tokenizerName) {
            case "KeywordTokenizer": {
                return new KeywordTokenizer();
            }
            case "LetterTokenizer": {
                return new LetterTokenizer();
            }
            case "StandardTokenizer": {
                return new StandardTokenizer();
            }
            case "WhitespaceTokenizer": {
                return new WhitespaceTokenizer();
            }
        }
        throw new TextIndexException("Unknown tokenizer : " + tokenizerName);
    }

    private TokenFilter getTokenFilter(String filterName, TokenStream source) {
        switch (filterName) {
            case "ASCIIFoldingFilter": {
                return new ASCIIFoldingFilter(source);
            }
            case "LowerCaseFilter": {
                return new LowerCaseFilter(source);
            }
            case "StandardFilter": {
                return new StandardFilter(source);
            }
        }
        throw new TextIndexException("Unknown filter : " + filterName);
    }

    public ConfigurableAnalyzer(String tokenizer, List<String> filters) {
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer source;
        Tokenizer stream = source = this.getTokenizer(this.tokenizer);
        for (String filter : this.filters) {
            stream = this.getTokenFilter(filter, (TokenStream)stream);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)stream);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenStream stream = in;
        for (String filter : this.filters) {
            stream = this.getTokenFilter(filter, stream);
        }
        return stream;
    }
}

