/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.analyzer.ConfigurableAnalyzer;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;

public class ConfigurableAnalyzerAssembler
extends AssemblerBase {
    public Analyzer open(Assembler a, Resource root, Mode mode) {
        if (root.hasProperty(TextVocab.pTokenizer)) {
            ArrayList<String> filters;
            Resource tokenizerResource = root.getPropertyResourceValue(TextVocab.pTokenizer);
            String tokenizer = tokenizerResource.getLocalName();
            if (root.hasProperty(TextVocab.pFilters)) {
                Resource filtersResource = root.getPropertyResourceValue(TextVocab.pFilters);
                filters = this.toFilterList(filtersResource);
            } else {
                filters = new ArrayList();
            }
            return new ConfigurableAnalyzer(tokenizer, filters);
        }
        throw new TextIndexException("text:tokenizer setting is required by ConfigurableAnalyzer");
    }

    private List<String> toFilterList(Resource list) {
        ArrayList<String> result = new ArrayList<String>();
        Resource current = list;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement stmt = current.getProperty(RDF.first);
            if (stmt == null) {
                throw new TextIndexException("filter list not well formed");
            }
            RDFNode node = stmt.getObject();
            if (!node.isResource()) {
                throw new TextIndexException("filter is not a resource : " + node);
            }
            result.add(node.asResource().getLocalName());
            stmt = current.getProperty(RDF.rest);
            if (stmt == null) {
                throw new TextIndexException("filter list not terminated by rdf:nil");
            }
            node = stmt.getObject();
            if (!node.isResource()) {
                throw new TextIndexException("filter list node is not a resource : " + node);
            }
            current = node.asResource();
        }
        return result;
    }
}

