/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.jena.rdf.model.Resource;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;

public class Util {
    private static Hashtable<String, Class<?>> analyzersClasses;
    private static Hashtable<String, Analyzer> cache;
    private static Hashtable<String, Analyzer> definedAnalyzers;

    public static Analyzer getLocalizedAnalyzer(String lang) {
        if (lang == null) {
            return null;
        }
        if (cache.containsKey(lang)) {
            return cache.get(lang);
        }
        try {
            Class<?> className = analyzersClasses.get(lang);
            if (className == null) {
                return null;
            }
            Constructor<?> constructor = className.getConstructor(new Class[0]);
            Analyzer analyzer = (Analyzer)constructor.newInstance(new Object[0]);
            cache.put(lang, analyzer);
            return analyzer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addAnalyzer(String lang, Analyzer analyzer) {
        cache.put(lang, analyzer);
    }

    public static Analyzer getDefinedAnalyzer(Resource key) {
        return definedAnalyzers.get(key.getURI());
    }

    public static void defineAnalyzer(Resource key, Analyzer analyzer) {
        definedAnalyzers.put(key.getURI(), analyzer);
    }

    private static void initAnalyzerDefs() {
        analyzersClasses = new Hashtable();
        analyzersClasses.put("ar", ArabicAnalyzer.class);
        analyzersClasses.put("bg", BulgarianAnalyzer.class);
        analyzersClasses.put("ca", CatalanAnalyzer.class);
        analyzersClasses.put("cs", CzechAnalyzer.class);
        analyzersClasses.put("da", DanishAnalyzer.class);
        analyzersClasses.put("de", GermanAnalyzer.class);
        analyzersClasses.put("el", GreekAnalyzer.class);
        analyzersClasses.put("en", EnglishAnalyzer.class);
        analyzersClasses.put("es", SpanishAnalyzer.class);
        analyzersClasses.put("eu", BasqueAnalyzer.class);
        analyzersClasses.put("fa", PersianAnalyzer.class);
        analyzersClasses.put("fi", FinnishAnalyzer.class);
        analyzersClasses.put("fr", FrenchAnalyzer.class);
        analyzersClasses.put("ga", IrishAnalyzer.class);
        analyzersClasses.put("gl", GalicianAnalyzer.class);
        analyzersClasses.put("hi", HindiAnalyzer.class);
        analyzersClasses.put("hu", HungarianAnalyzer.class);
        analyzersClasses.put("hy", ArmenianAnalyzer.class);
        analyzersClasses.put("id", IndonesianAnalyzer.class);
        analyzersClasses.put("it", ItalianAnalyzer.class);
        analyzersClasses.put("ja", CJKAnalyzer.class);
        analyzersClasses.put("ko", CJKAnalyzer.class);
        analyzersClasses.put("lv", LatvianAnalyzer.class);
        analyzersClasses.put("nl", DutchAnalyzer.class);
        analyzersClasses.put("no", NorwegianAnalyzer.class);
        analyzersClasses.put("pt", PortugueseAnalyzer.class);
        analyzersClasses.put("ro", RomanianAnalyzer.class);
        analyzersClasses.put("ru", RussianAnalyzer.class);
        analyzersClasses.put("sv", SwedishAnalyzer.class);
        analyzersClasses.put("th", ThaiAnalyzer.class);
        analyzersClasses.put("tr", TurkishAnalyzer.class);
        analyzersClasses.put("zh", CJKAnalyzer.class);
    }

    static {
        cache = new Hashtable();
        definedAnalyzers = new Hashtable();
        Util.initAnalyzerDefs();
    }
}

