/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.changes;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.text.changes.TextDatasetChanges;
import org.apache.jena.query.text.changes.TextQuadAction;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphWrapper;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;

public class DatasetGraphTextMonitor
extends DatasetGraphWrapper {
    private boolean CheckFirst = true;
    private boolean RecordNoAction = true;
    private final TextDatasetChanges monitor;
    private static int SLICE = 1000;

    public DatasetGraphTextMonitor(DatasetGraph dsg, TextDatasetChanges monitor) {
        super(dsg);
        this.monitor = monitor;
    }

    public DatasetGraphTextMonitor(DatasetGraph dsg, TextDatasetChanges monitor, boolean recordOnlyIfRealChange) {
        super(dsg);
        this.CheckFirst = recordOnlyIfRealChange;
        this.monitor = monitor;
    }

    public TextDatasetChanges getMonitor() {
        return this.monitor;
    }

    public DatasetGraph monitored() {
        return this.getWrapped();
    }

    public void add(Quad quad) {
        if (this.CheckFirst && this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(TextQuadAction.NO_ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.add$(quad);
    }

    public void add(Node g, Node s, Node p, Node o) {
        if (this.CheckFirst && this.contains(g, s, p, o)) {
            if (this.RecordNoAction) {
                this.record(TextQuadAction.NO_ADD, g, s, p, o);
            }
            return;
        }
        this.add$(g, s, p, o);
    }

    private void add$(Node g, Node s, Node p, Node o) {
        super.add(g, s, p, o);
        this.record(TextQuadAction.ADD, g, s, p, o);
    }

    private void add$(Quad quad) {
        super.add(quad);
        this.record(TextQuadAction.ADD, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public void delete(Quad quad) {
        if (this.CheckFirst && !this.contains(quad)) {
            if (this.RecordNoAction) {
                this.record(TextQuadAction.NO_DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
            }
            return;
        }
        this.delete$(quad);
    }

    public void delete(Node g, Node s, Node p, Node o) {
        if (this.CheckFirst && !this.contains(g, s, p, o)) {
            if (this.RecordNoAction) {
                this.record(TextQuadAction.NO_DELETE, g, s, p, o);
            }
            return;
        }
        this.delete$(g, s, p, o);
    }

    private void delete$(Quad quad) {
        super.delete(quad);
        this.record(TextQuadAction.DELETE, quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    private void delete$(Node g, Node s, Node p, Node o) {
        super.delete(g, s, p, o);
        this.record(TextQuadAction.DELETE, g, s, p, o);
    }

    public void deleteAny(Node g, Node s, Node p, Node o) {
        List some;
        do {
            Iterator iter = this.find(g, s, p, o);
            some = Iter.take((Iterator)iter, (int)SLICE);
            for (Quad q : some) {
                this.delete$(q);
            }
        } while (some.size() >= SLICE);
    }

    public void addGraph(Node gn, Graph g) {
        ExtendedIterator iter = g.find(Node.ANY, Node.ANY, Node.ANY);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            this.add(gn, t.getSubject(), t.getPredicate(), t.getObject());
        }
    }

    public void removeGraph(Node gn) {
        this.deleteAny(gn, Node.ANY, Node.ANY, Node.ANY);
    }

    private void record(TextQuadAction action, Node g, Node s, Node p, Node o) {
        this.monitor.change(action, g, s, p, o);
    }

    public void sync() {
        SystemARQ.syncObject((Object)this.monitor);
        super.sync();
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }
}

