/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.cmd;

import arq.cmdline.CmdARQ;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.core.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class textindexer
extends CmdARQ {
    private static Logger log = LoggerFactory.getLogger(textindexer.class);
    public static final ArgDecl assemblerDescDecl = new ArgDecl(true, new String[]{"desc", "dataset"});
    protected DatasetGraphText dataset = null;
    protected TextIndex textIndex = null;
    protected EntityDefinition entityDefinition;
    protected ProgressMonitor progressMonitor;

    public static void main(String ... argv) {
        new textindexer(argv).mainRun();
    }

    public static void testMain(String ... argv) {
        new textindexer(argv).mainMethod();
    }

    protected textindexer(String[] argv) {
        super(argv);
        super.add(assemblerDescDecl, "--desc=", "Assembler description file");
        this.progressMonitor = new ProgressMonitor("properties indexed");
    }

    protected void processModulesAndArgs() {
        String file;
        super.processModulesAndArgs();
        if (!super.contains(assemblerDescDecl) && this.getNumPositional() == 0) {
            throw new CmdException("No assembler description given");
        }
        if (super.contains(assemblerDescDecl)) {
            if (this.getValues(assemblerDescDecl).size() != 1) {
                throw new CmdException("Multiple assembler descriptions given via --desc");
            }
            if (this.getPositional().size() != 0) {
                throw new CmdException("Additional assembler descriptions given");
            }
            file = this.getValue(assemblerDescDecl);
        } else {
            if (this.getNumPositional() != 1) {
                throw new CmdException("Multiple assembler descriptions given as positional arguments");
            }
            file = this.getPositionalArg(0);
        }
        if (file == null) {
            throw new CmdException("No dataset specified");
        }
        Dataset ds = TextDatasetFactory.create(file);
        if (ds == null) {
            throw new CmdException("No dataset description found");
        }
        this.dataset = (DatasetGraphText)ds.asDatasetGraph();
        this.textIndex = this.dataset.getTextIndex();
        if (this.textIndex == null) {
            throw new CmdException("Dataset has no text index");
        }
        this.entityDefinition = this.textIndex.getDocDef();
    }

    protected String getSummary() {
        return this.getCommandName() + " --desc=assemblerFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec() {
        try {
            if (this.dataset.supportsTransactions()) {
                this.dataset.begin(ReadWrite.READ);
            }
            Set<Node> properties = this.getIndexedProperties();
            for (Node property : properties) {
                Iterator quadIter = this.dataset.find(Node.ANY, Node.ANY, property, Node.ANY);
                while (quadIter.hasNext()) {
                    Entity entity;
                    Quad quad = (Quad)quadIter.next();
                    if (Quad.isDefaultGraph((Node)quad.getGraph())) {
                        quad = Quad.create((Node)Quad.defaultGraphNodeGenerated, (Node)quad.getSubject(), (Node)quad.getPredicate(), (Node)quad.getObject());
                    }
                    if ((entity = TextQueryFuncs.entityFromQuad(this.entityDefinition, quad)) == null) continue;
                    this.textIndex.addEntity(entity);
                    this.progressMonitor.progressByOne();
                }
            }
            this.textIndex.commit();
            this.textIndex.close();
            if (this.dataset.supportsTransactions()) {
                this.dataset.commit();
            }
            this.dataset.close();
            this.progressMonitor.close();
        }
        finally {
            if (this.dataset.supportsTransactions()) {
                this.dataset.end();
            }
        }
    }

    private Set<Node> getIndexedProperties() {
        HashSet<Node> result = new HashSet<Node>();
        for (String f : this.entityDefinition.fields()) {
            for (Node p : this.entityDefinition.getPredicates(f)) {
                result.add(p);
            }
        }
        return result;
    }

    private static class ProgressMonitor {
        String progressMessage;
        long startTime;
        long progressCount;
        long intervalStartTime;
        long progressAtStartOfInterval;
        long reportingInterval = 10000L;

        ProgressMonitor(String progressMessage) {
            this.progressMessage = progressMessage;
            this.start();
        }

        void start() {
            this.startTime = System.currentTimeMillis();
            this.progressCount = 0L;
            this.startInterval();
        }

        private void startInterval() {
            this.intervalStartTime = System.currentTimeMillis();
            this.progressAtStartOfInterval = this.progressCount;
        }

        void progressByOne() {
            ++this.progressCount;
            long now = System.currentTimeMillis();
            if (this.reportDue(now)) {
                this.report(now);
                this.startInterval();
            }
        }

        boolean reportDue(long now) {
            return now - this.intervalStartTime >= this.reportingInterval;
        }

        private void report(long now) {
            long progressThisInterval = this.progressCount - this.progressAtStartOfInterval;
            long intervalDuration = now - this.intervalStartTime;
            long overallDuration = now - this.startTime;
            String message = this.progressCount + " (" + progressThisInterval / (intervalDuration / 1000L) + " per second) " + this.progressMessage + " (" + this.progressCount / Math.max(overallDuration / 1000L, 1L) + " per second overall)";
            log.info(message);
        }

        void close() {
            long overallDuration = System.currentTimeMillis() - this.startTime;
            String message = this.progressCount + " (" + this.progressCount / Math.max(overallDuration / 1000L, 1L) + " per second) " + this.progressMessage;
            log.info(message);
        }
    }
}

