/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.io.IOException;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexParseException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.query.text.analyzer.IndexingMultilingualAnalyzer;
import org.apache.jena.query.text.analyzer.MultilingualAnalyzer;
import org.apache.jena.query.text.analyzer.QueryMultilingualAnalyzer;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexLucene
implements TextIndex {
    private static Logger log = LoggerFactory.getLogger(TextIndexLucene.class);
    private static int MAX_N = 10000;
    private static final String DATATYPE_PREFIX = "^^";
    private static final String RIGHT_ARROW = "\u21a6";
    private static final String LEFT_ARROW = "\u21a4";
    private static final String DIVIDES = "\u2223";
    private static final String Z_MORE_SEPS = "([\\p{Z}\u0f0b\u0000f0c\u0000f0d\u000180e]*?)";
    public static final FieldType ftIRI = new FieldType();
    public static final FieldType ftString;
    private final EntityDefinition docDef;
    private final Directory directory;
    private final Analyzer indexAnalyzer;
    private Analyzer defaultAnalyzer;
    private Map<String, Analyzer> analyzerPerField;
    private final Analyzer queryAnalyzer;
    private final String queryParserType;
    private final FieldType ftText;
    private final FieldType ftTextNotStored;
    private final FieldType ftTextStoredNoIndex;
    private final boolean isMultilingual;
    private final int maxBasicQueries;
    private final boolean ignoreIndexErrors;
    private Map<String, Analyzer> multilingualQueryAnalyzers = new HashMap<String, Analyzer>();
    private volatile IndexWriter indexWriter;

    public TextIndexLucene(Directory directory, TextIndexConfig config) {
        this.directory = directory;
        this.docDef = config.getEntDef();
        this.maxBasicQueries = config.getMaxBasicQueries();
        this.isMultilingual = config.isMultilingualSupport();
        if (this.isMultilingual && config.getEntDef().getLangField() == null) {
            this.docDef.setLangField("lang");
        }
        this.ignoreIndexErrors = config.ignoreIndexErrors;
        this.analyzerPerField = new HashMap<String, Analyzer>();
        this.analyzerPerField.put(this.docDef.getEntityField(), (Analyzer)new KeywordAnalyzer());
        if (this.docDef.getGraphField() != null) {
            this.analyzerPerField.put(this.docDef.getGraphField(), (Analyzer)new KeywordAnalyzer());
        }
        if (this.docDef.getLangField() != null) {
            this.analyzerPerField.put(this.docDef.getLangField(), (Analyzer)new KeywordAnalyzer());
        }
        for (String field : this.docDef.fields()) {
            Analyzer _analyzer = this.docDef.getAnalyzer(field);
            if (_analyzer == null) continue;
            this.analyzerPerField.put(field, _analyzer);
        }
        Analyzer indexDefault = this.defaultAnalyzer = null != config.getAnalyzer() ? config.getAnalyzer() : new StandardAnalyzer();
        Object queryDefault = this.defaultAnalyzer;
        if (this.isMultilingual) {
            queryDefault = new MultilingualAnalyzer(this.defaultAnalyzer);
            indexDefault = Util.usingIndexAnalyzers() ? new IndexingMultilingualAnalyzer(this.defaultAnalyzer) : queryDefault;
        }
        this.indexAnalyzer = new PerFieldAnalyzerWrapper(indexDefault, this.analyzerPerField);
        this.queryAnalyzer = null != config.getQueryAnalyzer() ? config.getQueryAnalyzer() : new PerFieldAnalyzerWrapper(queryDefault, this.analyzerPerField);
        this.queryParserType = config.getQueryParser();
        log.debug("TextIndexLucene defaultAnalyzer: {}, indexAnalyzer: {}, queryAnalyzer: {}, queryParserType: {}", new Object[]{this.defaultAnalyzer, this.indexAnalyzer, this.queryAnalyzer, this.queryParserType});
        this.ftText = config.isValueStored() ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED;
        this.ftTextNotStored = TextField.TYPE_NOT_STORED;
        this.ftTextStoredNoIndex = new FieldType();
        this.ftTextStoredNoIndex.setIndexOptions(IndexOptions.NONE);
        this.ftTextStoredNoIndex.setStored(true);
        this.ftTextStoredNoIndex.freeze();
        if (config.isValueStored() && this.docDef.getLangField() == null) {
            log.warn("Values stored but langField not set. Returned values will not have language tag or datatype.");
        }
        this.openIndexWriter();
    }

    private void openIndexWriter() {
        IndexWriterConfig wConfig = new IndexWriterConfig(this.indexAnalyzer);
        try {
            this.indexWriter = new IndexWriter(this.directory, wConfig);
            this.indexWriter.commit();
        }
        catch (IndexFormatTooOldException e) {
            throw new TextIndexException("jena-text/Lucene cannot use indexes created before Jena 3.3.0. Please rebuild your text index using jena.textindexer from Jena 3.3.0 or above.", e);
        }
        catch (IOException e) {
            throw new TextIndexException("openIndexWriter", e);
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public void prepareCommit() {
        try {
            this.indexWriter.prepareCommit();
        }
        catch (IOException e) {
            throw new TextIndexException("prepareCommit", e);
        }
    }

    @Override
    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new TextIndexException("commit", e);
        }
    }

    @Override
    public void rollback() {
        IndexWriter idx = this.indexWriter;
        this.indexWriter = null;
        try {
            idx.rollback();
        }
        catch (IOException e) {
            throw new TextIndexException("rollback", e);
        }
        this.openIndexWriter();
    }

    public void close() {
        try {
            this.indexWriter.close();
        }
        catch (IOException ex) {
            throw new TextIndexException("close", ex);
        }
    }

    @Override
    public void updateEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            if (log.isTraceEnabled() && entity != null) {
                log.trace("Update entity: " + entity.toStringDetail());
            } else {
                log.debug("Update entity: " + entity);
            }
        }
        try {
            this.updateDocument(entity);
        }
        catch (IOException e) {
            throw new TextIndexException("updateEntity", e);
        }
    }

    protected void updateDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        Term term = new Term(this.docDef.getEntityField(), entity.getId());
        try {
            this.indexWriter.updateDocument(term, (Iterable)doc);
        }
        catch (Exception ex) {
            log.error("Error updating {} with term: {} message: {}", new Object[]{doc, term, ex.getMessage()});
            if (this.ignoreIndexErrors) {
                return;
            }
            throw ex;
        }
        log.trace("updated: {}", (Object)doc);
    }

    @Override
    public void addEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            if (log.isTraceEnabled() && entity != null) {
                log.trace("Add entity: " + entity.toStringDetail());
            } else {
                log.debug("Add entity: " + entity);
            }
        }
        try {
            this.addDocument(entity);
        }
        catch (IOException e) {
            throw new TextIndexException("addEntity", e);
        }
    }

    protected void addDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        try {
            this.indexWriter.addDocument((Iterable)doc);
        }
        catch (Exception ex) {
            log.error("Error adding {} message: {}", (Object)doc, (Object)ex.getMessage());
            if (this.ignoreIndexErrors) {
                return;
            }
            throw ex;
        }
        log.trace("added: {}", (Object)doc);
    }

    @Override
    public void deleteEntity(Entity entity) {
        if (this.docDef.getUidField() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            if (log.isTraceEnabled() && entity != null) {
                log.trace("Delete entity: " + entity.toStringDetail());
            } else {
                log.debug("Delete entity: " + entity);
            }
        }
        try {
            Map<String, Object> map = entity.getMap();
            String property = map.keySet().iterator().next();
            String value = (String)map.get(property);
            String hash = entity.getChecksum(property, value);
            Term uid = new Term(this.docDef.getUidField(), hash);
            this.indexWriter.deleteDocuments(new Term[]{uid});
        }
        catch (Exception e) {
            throw new TextIndexException("deleteEntity", e);
        }
    }

    protected Document doc(Entity entity) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), (CharSequence)entity.getId(), (IndexableFieldType)ftIRI);
        doc.add((IndexableField)entField);
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            Field gField = new Field(graphField, (CharSequence)entity.getGraph(), (IndexableFieldType)ftIRI);
            doc.add((IndexableField)gField);
        }
        String langField = this.docDef.getLangField();
        String uidField = this.docDef.getUidField();
        for (Map.Entry<String, Object> e : entity.getMap().entrySet()) {
            String field = e.getKey();
            String value = (String)e.getValue();
            FieldType ft = this.docDef.getNoIndex(field) ? this.ftTextStoredNoIndex : this.ftText;
            doc.add((IndexableField)new Field(field, (CharSequence)value, (IndexableFieldType)ft));
            if (langField != null) {
                String lang = entity.getLanguage();
                RDFDatatype datatype = entity.getDatatype();
                if (lang != null && !"".equals(lang)) {
                    doc.add((IndexableField)new Field(langField, (CharSequence)lang, (IndexableFieldType)StringField.TYPE_STORED));
                    if (this.isMultilingual) {
                        doc.add((IndexableField)new Field(field + "_" + lang, (CharSequence)value, (IndexableFieldType)this.ftTextNotStored));
                        List<String> auxIndexes = Util.getAuxIndexes(lang);
                        if (auxIndexes != null) {
                            for (String auxTag : auxIndexes) {
                                doc.add((IndexableField)new Field(field + "_" + auxTag, (CharSequence)value, (IndexableFieldType)this.ftTextNotStored));
                            }
                        }
                    }
                } else if (datatype != null && !datatype.equals(XSDDatatype.XSDstring)) {
                    doc.add((IndexableField)new Field(langField, (CharSequence)(DATATYPE_PREFIX + datatype.getURI()), (IndexableFieldType)StringField.TYPE_STORED));
                }
            }
            if (uidField == null) continue;
            String hash = entity.getChecksum(field, value);
            doc.add((IndexableField)new Field(uidField, (CharSequence)hash, (IndexableFieldType)StringField.TYPE_STORED));
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        try {
            DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);
            List<Map<String, Node>> x = this.get$((IndexReader)indexReader, uri);
            if (x.size() == 0) {
                return null;
            }
            return x.get(0);
        }
        catch (Exception ex) {
            throw new TextIndexException("get", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Query parseQuery(String queryString, Analyzer analyzer) throws ParseException {
        Query query = null;
        ComplexPhraseQueryParser qp = null;
        switch (this.queryParserType) {
            case "QueryParser": {
                break;
            }
            case "SurroundQueryParser": {
                try {
                    query = QueryParser.parse((String)queryString).makeLuceneQueryField(this.docDef.getPrimaryField(), new BasicQueryFactory(this.maxBasicQueries));
                }
                catch (org.apache.lucene.queryparser.surround.parser.ParseException e) {
                    throw new ParseException(e.getMessage());
                }
                return query;
            }
            case "ComplexPhraseQueryParser": {
                qp = new ComplexPhraseQueryParser(this.docDef.getPrimaryField(), analyzer);
                break;
            }
            case "AnalyzingQueryParser": {
                log.warn("Deprecated query parser type 'AnalyzingQueryParser'. Defaulting to standard QueryParser");
                break;
            }
            default: {
                log.warn("Unknown query parser type '" + this.queryParserType + "'. Defaulting to standard QueryParser");
            }
        }
        if (qp == null) {
            qp = new org.apache.lucene.queryparser.classic.QueryParser(this.docDef.getPrimaryField(), analyzer);
        }
        qp.setAllowLeadingWildcard(true);
        Object object = this;
        synchronized (object) {
            query = qp.parse(queryString);
            return query;
        }
    }

    private List<Map<String, Node>> get$(IndexReader indexReader, String uri) throws ParseException, IOException {
        String escaped = QueryParserBase.escape((String)uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        Query query = this.parseQuery(qs, this.queryAnalyzer);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)1).scoreDocs;
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        StoredFields sFields = indexSearcher.storedFields();
        for (ScoreDoc sd : sDocs) {
            Document doc = sFields.document(sd.doc);
            String[] x = doc.getValues(this.docDef.getEntityField());
            if (x.length != 1) {
                // empty if block
            }
            String uriStr = x[0];
            HashMap<String, Node> record = new HashMap<String, Node>();
            Node entity = NodeFactory.createURI((String)uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                String[] values;
                for (String v : values = doc.getValues(f)) {
                    Node n = this.entryToNode(v);
                    record.put(f, n);
                }
                records.add(record);
            }
        }
        return records;
    }

    @Override
    public List<TextHit> query(Node property, String qs, String graphURI, String lang) {
        return this.query(property, qs, graphURI, lang, MAX_N);
    }

    @Override
    public List<TextHit> query(Node property, String qs, String graphURI, String lang, int limit) {
        return this.query(property, qs, graphURI, lang, limit, null);
    }

    @Override
    public List<TextHit> query(Node propNode, String qs, String graphURI, String lang, int limit, String highlight) {
        ArrayList<Resource> props = new ArrayList<Resource>();
        if (propNode != null) {
            props.add((Resource)ResourceFactory.createProperty((String)propNode.getURI()));
        }
        return this.query((String)null, props, qs, graphURI, lang, limit, highlight);
    }

    @Override
    public List<TextHit> query(String subjectUri, Node propNode, String qs, String graphURI, String lang, int limit, String highlight) {
        ArrayList<Resource> props = new ArrayList<Resource>();
        if (propNode != null) {
            props.add((Resource)ResourceFactory.createProperty((String)propNode.getURI()));
        }
        return this.query(subjectUri, props, qs, graphURI, lang, limit, highlight);
    }

    @Override
    public List<TextHit> query(List<Resource> props, String qs, String graphURI, String lang, int limit, String highlight) {
        return this.query((String)null, props, qs, graphURI, lang, limit, highlight);
    }

    @Override
    public List<TextHit> query(Node subj, List<Resource> props, String qs, String graphURI, String lang, int limit, String highlight) {
        String subjectUri = subj == null || Var.isVar((Node)subj) || !subj.isURI() ? null : subj.getURI();
        return this.query(subjectUri, props, qs, graphURI, lang, limit, highlight);
    }

    @Override
    public List<TextHit> query(String subjectUri, List<Resource> props, String qs, String graphURI, String lang, int limit, String highlight) {
        List<TextHit> list;
        block9: {
            DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);
            try {
                list = this.query$((IndexReader)indexReader, props, qs, this.addUriPredicate(subjectUri), graphURI, lang, limit, highlight);
                if (indexReader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (indexReader != null) {
                        try {
                            indexReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ParseException ex) {
                    throw new TextIndexParseException(qs, ex.getMessage());
                }
                catch (Exception ex) {
                    throw new TextIndexException("query", ex);
                }
            }
            indexReader.close();
        }
        return list;
    }

    private UnaryOperator<Query> addUriPredicate(String subjectUri) {
        if (subjectUri != null) {
            return textQuery -> {
                String uriField = this.docDef.getEntityField();
                return new BooleanQuery.Builder().add(textQuery, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term(uriField, subjectUri)), BooleanClause.Occur.FILTER).build();
            };
        }
        return UnaryOperator.identity();
    }

    private String getDocField(Document doc, List<String> fields) {
        for (String field : fields) {
            if (doc.get(field) == null) continue;
            return field;
        }
        return null;
    }

    private List<TextHit> simpleResults(ScoreDoc[] sDocs, IndexSearcher indexSearcher, Query query, List<String> fields) throws IOException {
        ArrayList<TextHit> results = new ArrayList<TextHit>();
        StoredFields sFields = indexSearcher.storedFields();
        for (ScoreDoc sd : sDocs) {
            Node prop;
            Document doc = sFields.document(sd.doc);
            log.trace("simpleResults[{}]: fields: {} doc: {}", new Object[]{sd.doc, fields, doc});
            String entity = doc.get(this.docDef.getEntityField());
            Node literal = null;
            String field = this.getDocField(doc, fields);
            String lexical = doc.get(field);
            Collection<Node> props = this.docDef.getPredicates(field);
            Node node = prop = props.isEmpty() ? null : props.iterator().next();
            if (lexical != null) {
                String doclang = doc.get(this.docDef.getLangField());
                if (doclang != null) {
                    if (doclang.startsWith(DATATYPE_PREFIX)) {
                        String datatype = doclang.substring(DATATYPE_PREFIX.length());
                        TypeMapper tmap = TypeMapper.getInstance();
                        literal = NodeFactory.createLiteral((String)lexical, (RDFDatatype)tmap.getSafeTypeByName(datatype));
                    } else {
                        literal = NodeFactory.createLiteral((String)lexical, (String)doclang);
                    }
                } else {
                    literal = NodeFactory.createLiteral((String)lexical);
                }
            }
            String graf = this.docDef.getGraphField() != null ? doc.get(this.docDef.getGraphField()) : null;
            Node graph = graf != null ? TextQueryFuncs.stringToNode(graf) : null;
            Node subject = TextQueryFuncs.stringToNode(entity);
            TextHit hit = new TextHit(subject, sd.score, literal, graph, prop);
            results.add(hit);
        }
        return results;
    }

    private String frags2string(TextFragment[] frags, HighlightOpts opts) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (TextFragment f : frags) {
            String fragStr = f.toString();
            log.trace("found fragment {}", (Object)f);
            sb.append(sep);
            sb.append(opts.joinHi ? fragStr.replaceAll(opts.patternExpr, "$1") : fragStr);
            sep = opts.fragSep;
        }
        return sb.toString();
    }

    private List<TextHit> highlightResults(ScoreDoc[] sDocs, IndexSearcher indexSearcher, Query query, List<String> fields, String highlight, String queryLang) throws IOException, InvalidTokenOffsetsException {
        ArrayList<TextHit> results = new ArrayList<TextHit>();
        HighlightOpts opts = new HighlightOpts(highlight);
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(opts.start, opts.end);
        Highlighter highlighter = new Highlighter((Formatter)formatter, (Scorer)new QueryScorer(query));
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(opts.fragSize));
        StoredFields sFields = indexSearcher.storedFields();
        for (ScoreDoc sd : sDocs) {
            Document doc = sFields.document(sd.doc);
            String entity = doc.get(this.docDef.getEntityField());
            Node literal = null;
            String field = this.getDocField(doc, fields);
            String lexical = doc.get(field);
            Collection<Node> props = this.docDef.getPredicates(field);
            Node prop = props.isEmpty() ? null : props.iterator().next();
            String docLang = doc.get(this.docDef.getLangField());
            String effectiveField = queryLang != null ? field + "_" + Util.getEffectiveLang(docLang, queryLang) : field;
            log.trace("highlightResults[{}]: {}, field: {}, lexical: {}, docLang: {}, effectiveField: {}", new Object[]{sd.doc, doc, field, lexical, docLang, effectiveField});
            if (lexical != null) {
                TokenStream tokenStream = this.indexAnalyzer.tokenStream(effectiveField, lexical);
                log.trace("tokenStream: {}", (Object)tokenStream.toString());
                TextFragment[] frags = highlighter.getBestTextFragments(tokenStream, lexical, opts.joinFrags, opts.maxFrags);
                String rez = this.frags2string(frags, opts);
                log.trace("result: {}, #frags: {}", (Object)rez, (Object)frags.length);
                literal = NodeFactory.createLiteral((String)rez, (String)docLang);
            }
            String graf = this.docDef.getGraphField() != null ? doc.get(this.docDef.getGraphField()) : null;
            Node graph = graf != null ? TextQueryFuncs.stringToNode(graf) : null;
            Node subject = TextQueryFuncs.stringToNode(entity);
            TextHit hit = new TextHit(subject, sd.score, literal, graph, prop);
            results.add(hit);
        }
        return results;
    }

    private Analyzer getQueryAnalyzer(boolean usingSearchFor, String lang) {
        if (usingSearchFor) {
            Analyzer qa = this.multilingualQueryAnalyzers.get(lang);
            if (qa == null) {
                qa = new PerFieldAnalyzerWrapper((Analyzer)new QueryMultilingualAnalyzer(this.defaultAnalyzer, lang), this.analyzerPerField);
                this.multilingualQueryAnalyzers.put(lang, qa);
            }
            return qa;
        }
        return this.queryAnalyzer;
    }

    private String composeQField(String qs, String textField, String lang, boolean usingSearchFor, List<String> searchForTags) {
        Object textClause = "";
        if (usingSearchFor) {
            for (String tag : searchForTags) {
                String tf = (String)textField + "_" + tag;
                textClause = (String)textClause + tf + ":" + qs + " ";
            }
        } else {
            if (this.isMultilingual && StringUtils.isNotEmpty((CharSequence)lang) && !lang.equals("none")) {
                textField = (String)textField + "_" + lang;
            }
            textClause = (String)textField + ":" + qs + " ";
        }
        return textClause;
    }

    private List<TextHit> query$(IndexReader indexReader, List<Resource> props, String qs, UnaryOperator<Query> textQueryExtender, String graphURI, String lang, int limit, String highlight) throws ParseException, IOException, InvalidTokenOffsetsException {
        ArrayList<String> textFields = new ArrayList<String>();
        Object qString = "";
        String langField = this.getDocDef().getLangField();
        List<String> searchForTags = Util.getSearchForTags(lang);
        boolean usingSearchFor = Util.usingSearchFor(lang);
        if (props.isEmpty()) {
            qString = qs + " ";
            log.trace("query$ processed EMPTY LIST of properties: {}; Lucene queryString: {}; textFields: {}", new Object[]{props, qString, textFields});
        } else {
            for (Resource prop : props) {
                String textField = this.docDef.getField(prop.asNode());
                textFields.add(textField);
            }
        }
        log.trace("query$ PROCESSING LIST of properties: {}; Lucene queryString: {}; textFields: {} ", new Object[]{props, qString, textFields});
        for (String textField : textFields) {
            qString = (String)qString + this.composeQField(qs, textField, lang, usingSearchFor, searchForTags);
        }
        if (textFields.isEmpty() && lang != null) {
            qString = (String)qString + this.composeQField(qs, this.docDef.getPrimaryField(), lang, usingSearchFor, searchForTags);
        }
        log.trace("query$ PROCESSED LIST of properties: {} with resulting qString: {} ", props, qString);
        if (!usingSearchFor && langField != null && StringUtils.isNotBlank((CharSequence)lang)) {
            qString = "(" + (String)qString + ") AND " + (!lang.equals("none") ? langField + ":" + lang : "-" + langField + ":*");
            log.trace("query$ ADDING LANG qString: {} ", qString);
        }
        if (graphURI != null) {
            String escaped = QueryParserBase.escape((String)graphURI);
            qString = "(" + (String)qString + ") AND " + this.getDocDef().getGraphField() + ":" + escaped;
        }
        Analyzer qa = this.getQueryAnalyzer(usingSearchFor, lang);
        Query textQuery = this.parseQuery((String)qString, qa);
        Query query = (Query)textQueryExtender.apply(textQuery);
        if (limit <= 0) {
            limit = MAX_N;
        }
        log.debug("query$ with LIST: {}; INPUT qString: {}; with queryParserType: {}; parseQuery with {} YIELDS: {}; parsed query: {}; limit: {}", new Object[]{props, qString, this.queryParserType, qa, textQuery, query, limit});
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)limit).scoreDocs;
        if (textFields.isEmpty()) {
            textFields.add(this.docDef.getPrimaryField());
        }
        if (highlight != null) {
            return this.highlightResults(sDocs, indexSearcher, query, textFields, highlight, lang);
        }
        return this.simpleResults(sDocs, indexSearcher, query, textFields);
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode((String)v, null, null);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexOptions(IndexOptions.DOCS);
        ftIRI.freeze();
        ftString = StringField.TYPE_NOT_STORED;
    }

    class HighlightOpts {
        int maxFrags = 3;
        int fragSize = 128;
        String start = "\u21a6";
        String end = "\u21a4";
        String fragSep = "\u2223";
        String patternExpr = null;
        boolean joinHi = true;
        boolean joinFrags = true;

        public HighlightOpts(String optStr) {
            String[] opts;
            for (String opt : opts = optStr.trim().split("\\|")) {
                String v;
                if ((opt = opt.trim()).startsWith("m:")) {
                    try {
                        this.maxFrags = Integer.parseInt(opt.substring(2));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (opt.startsWith("z:")) {
                    try {
                        this.fragSize = Integer.parseInt(opt.substring(2));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (opt.startsWith("s:")) {
                    this.start = opt.substring(2);
                    continue;
                }
                if (opt.startsWith("e:")) {
                    this.end = opt.substring(2);
                    continue;
                }
                if (opt.startsWith("f:")) {
                    this.fragSep = opt.substring(2);
                    continue;
                }
                if (opt.startsWith("jh:")) {
                    v = opt.substring(3);
                    if (!"n".equals(v)) continue;
                    this.joinHi = false;
                    continue;
                }
                if (!opt.startsWith("jf:") || !"n".equals(v = opt.substring(3))) continue;
                this.joinFrags = false;
            }
            this.patternExpr = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001", TextIndexLucene.Z_MORE_SEPS}, (String)this.end, this.start);
        }
    }
}

