/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.analyzer.ConfigurableAnalyzer;
import org.apache.jena.query.text.assembler.GenericFilterAssembler;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;

public class DefineFiltersAssembler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean open(Assembler a, Resource list) {
        Resource current = list;
        while (current != null && !current.equals((Object)RDF.nil)) {
            Statement restStmt;
            Statement firstStmt = current.getProperty(RDF.first);
            if (firstStmt == null) {
                throw new TextIndexException("parameter list not well formed: " + current);
            }
            RDFNode first = firstStmt.getObject();
            if (!first.isResource()) {
                throw new TextIndexException("parameter specification must be an anon resource : " + first);
            }
            Resource adding = (Resource)first;
            if (adding.hasProperty(TextVocab.pFilter)) {
                Statement filterStmt = adding.getProperty(TextVocab.pFilter);
                RDFNode filterNode = filterStmt.getObject();
                if (!filterNode.isResource()) {
                    throw new TextIndexException("addFilters text:filter must be a filter spec resource: " + filterNode);
                }
                GenericFilterAssembler.FilterSpec filterSpec = (GenericFilterAssembler.FilterSpec)a.open((Resource)filterNode);
                if (adding.hasProperty(TextVocab.pDefFilter)) {
                    Statement defStmt = adding.getProperty(TextVocab.pDefFilter);
                    Resource id = defStmt.getResource();
                    if (id.getURI() == null) throw new TextIndexException("text:defineFilters text:defineAnalyzer property must be a non-blank resource: " + adding);
                    ConfigurableAnalyzer.defineFilter(id.getURI(), filterSpec);
                } else {
                    Log.warn((Object)"DefineFiltersAssembler", (String)"Filter specified but no text:defineFilter so filter is not accessible!");
                }
            }
            if ((restStmt = current.getProperty(RDF.rest)) == null) {
                throw new TextIndexException("parameter list not terminated by rdf:nil");
            }
            RDFNode rest = restStmt.getObject();
            if (!rest.isResource()) {
                throw new TextIndexException("parameter list node is not a resource : " + rest);
            }
            current = (Resource)rest;
        }
        return true;
    }
}

