/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.lucene.analysis.Analyzer;

public class EntityDefinitionAssembler
extends AssemblerBase
implements Assembler {
    public EntityDefinition open(Assembler a, Resource root, Mode mode) {
        Collection c;
        String prologue = "PREFIX : <http://jena.apache.org/text#>   PREFIX list: <http://jena.apache.org/ARQ/list#> ";
        Model model = root.getModel();
        String qs1 = StrUtils.strjoinNL((String[])new String[]{prologue, "SELECT * {", "  ?eMap  :entityField  ?entityField ;", "         :map ?map ;", "         :defaultField ?dftField .", "  OPTIONAL {", "    ?eMap :graphField ?graphField", "  }", "  OPTIONAL {", "    ?eMap :langField ?langField", "  }", "  OPTIONAL {", "    ?eMap :uidField ?uidField", "  }", "}"});
        ParameterizedSparqlString pss = new ParameterizedSparqlString(qs1);
        pss.setIri("eMap", root.getURI());
        Query query1 = QueryFactory.create((String)pss.toString());
        QueryExecution qexec1 = QueryExecutionFactory.create((Query)query1, (Model)model);
        ResultSet rs1 = qexec1.execSelect();
        List results = ResultSetFormatter.toList((ResultSet)rs1);
        if (results.size() == 0) {
            Log.warn((Object)((Object)this), (String)("Failed to find a valid EntityMap for : " + root));
            throw new TextIndexException("Failed to find a valid EntityMap for : " + root);
        }
        if (results.size() != 1) {
            Log.warn((Object)((Object)this), (String)("Multiple matches for EntityMap for : " + root));
            throw new TextIndexException("Multiple matches for EntityMap for : " + root);
        }
        QuerySolution qsol1 = (QuerySolution)results.get(0);
        String entityField = qsol1.getLiteral("entityField").getLexicalForm();
        String graphField = qsol1.contains("graphField") ? qsol1.getLiteral("graphField").getLexicalForm() : null;
        String langField = qsol1.contains("langField") ? qsol1.getLiteral("langField").getLexicalForm() : null;
        String defaultField = qsol1.contains("dftField") ? qsol1.getLiteral("dftField").getLexicalForm() : null;
        String uniqueIdField = qsol1.contains("uidField") ? qsol1.getLiteral("uidField").getLexicalForm() : null;
        ListValuedMap mapDefs = MultiMapUtils.newListValuedHashMap();
        HashMap<String, Analyzer> analyzerDefs = new HashMap<String, Analyzer>();
        HashMap<String, Boolean> noIndexDefs = new HashMap<String, Boolean>();
        Statement listStmt = root.getProperty(TextVocab.pMap);
        while (listStmt != null) {
            Statement analyzerStatement;
            RDFNode n = listStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text list node is not a resource : " + n);
            }
            Resource listResource = n.asResource();
            if (listResource.equals((Object)RDF.nil)) break;
            Statement listEntryStmt = listResource.getProperty(RDF.first);
            if (listEntryStmt == null) {
                throw new TextIndexException("Text map list is not well formed.  No rdf:first property");
            }
            n = listEntryStmt.getObject();
            if (!n.isResource()) {
                throw new TextIndexException("Text map list entry is not a resource : " + n);
            }
            Resource listEntry = n.asResource();
            Statement fieldStatement = listEntry.getProperty(TextVocab.pField);
            if (fieldStatement == null) {
                throw new TextIndexException("Text map entry has no field property");
            }
            n = fieldStatement.getObject();
            if (!n.isLiteral()) {
                throw new TextIndexException("Text map entry field property has no literal value : " + n);
            }
            String field = n.asLiteral().getLexicalForm();
            Statement predicateStatement = listEntry.getProperty(TextVocab.pPredicate);
            if (predicateStatement == null) {
                throw new TextIndexException("Text map entry has no predicate property");
            }
            n = predicateStatement.getObject();
            if (!n.isURIResource()) {
                throw new TextIndexException("Text map entry predicate property has non resource value : " + n);
            }
            mapDefs.put((Object)field, (Object)n.asNode());
            Statement noIndexStatement = listEntry.getProperty(TextVocab.pNoIndex);
            if (noIndexStatement != null) {
                n = noIndexStatement.getObject();
                if (!n.isLiteral()) {
                    throw new TextIndexException("Text map entry noIndex property must be a boolean : " + n);
                }
                boolean noInx = n.asLiteral().getBoolean();
                noIndexDefs.put(field, noInx);
            }
            if ((analyzerStatement = listEntry.getProperty(TextVocab.pAnalyzer)) != null) {
                n = analyzerStatement.getObject();
                if (!n.isResource()) {
                    throw new TextIndexException("Text map entry analyzer property is not a resource : " + n);
                }
                Resource analyzerResource = n.asResource();
                Analyzer analyzer = (Analyzer)a.open(analyzerResource);
                analyzerDefs.put(field, analyzer);
            }
            listStmt = listResource.getProperty(RDF.rest);
        }
        if (defaultField != null && (c = mapDefs.get((Object)defaultField)).isEmpty()) {
            throw new TextIndexException("No definition of primary field '" + defaultField + "'");
        }
        EntityDefinition docDef = new EntityDefinition(entityField, defaultField);
        docDef.setGraphField(graphField);
        docDef.setLangField(langField);
        docDef.setUidField(uniqueIdField);
        for (String f : mapDefs.keys()) {
            for (Node p : mapDefs.get((Object)f)) {
                docDef.set(f, p);
            }
        }
        for (String f : noIndexDefs.keySet()) {
            docDef.setNoIndex(f, (Boolean)noIndexDefs.get(f));
        }
        for (String f : analyzerDefs.keySet()) {
            docDef.setAnalyzer(f, (Analyzer)analyzerDefs.get(f));
        }
        return docDef;
    }
}

