/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.jena.query.text.analyzer.Util;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMultilingualAnalyzer
extends DelegatingAnalyzerWrapper {
    private static Logger log = LoggerFactory.getLogger(QueryMultilingualAnalyzer.class);
    private Analyzer defaultAnalyzer;
    private String langTag;

    public QueryMultilingualAnalyzer(Analyzer defaultAnalyzer) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.langTag = null;
    }

    public QueryMultilingualAnalyzer(Analyzer defaultAnalyzer, String tag) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = defaultAnalyzer;
        this.langTag = tag;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        int idx = fieldName.lastIndexOf("_");
        if (idx == -1) {
            return this.defaultAnalyzer;
        }
        String lang = (String)ObjectUtils.defaultIfNull((Object)this.langTag, (Object)fieldName.substring(idx + 1));
        Analyzer analyzer = Util.getLocalizedAnalyzer(lang);
        analyzer = (Analyzer)ObjectUtils.defaultIfNull((Object)analyzer, (Object)this.defaultAnalyzer);
        log.trace("getWrappedAnalyzer langTag: {}, fieldName: {}, analyzer: {}", new Object[]{this.langTag, fieldName, analyzer});
        return analyzer;
    }

    public String toString() {
        return "QueryMultilingualAnalyzer(default=" + this.defaultAnalyzer + ")";
    }
}

