/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.sampler.HTTPHCAbstractImpl;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HttpClientDefaultParameters;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.LoopbackHttpClientSocketFactory;
import org.apache.jmeter.protocol.http.util.SlowHttpClientSocketFactory;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class HTTPHC3Impl
extends HTTPHCAbstractImpl {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int RETRY_COUNT = JMeterUtils.getPropDefault((String)"httpclient3.retrycount", (int)1);
    private static final String HTTP_AUTHENTICATION_PREEMPTIVE = "http.authentication.preemptive";
    private static final boolean canSetPreEmptive;
    private static final ThreadLocal<Map<HostConfiguration, HttpClient>> httpClients;
    volatile HttpClient savedClient;

    protected HTTPHC3Impl(HTTPSamplerBase base) {
        super(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HTTPSampleResult sample(URL url, String method, boolean areFollowingRedirect, int frameDepth) {
        HTTPSampleResult hTTPSampleResult;
        PostMethod httpMethod;
        block35: {
            HTTPSampleResult hTTPSampleResult2;
            block34: {
                String urlStr = url.toString();
                log.debug("Start : sample " + urlStr);
                log.debug("method " + method);
                httpMethod = null;
                HTTPSampleResult res = new HTTPSampleResult();
                res.setMonitor(this.isMonitor());
                res.setSampleLabel(urlStr);
                res.setHTTPMethod(method);
                res.setURL(url);
                res.sampleStart();
                try {
                    try {
                        HttpClient client;
                        if (method.equals("POST")) {
                            httpMethod = new PostMethod(urlStr);
                        } else if (method.equals("PUT")) {
                            httpMethod = new PutMethod(urlStr);
                        } else if (method.equals("HEAD")) {
                            httpMethod = new HeadMethod(urlStr);
                        } else if (method.equals("TRACE")) {
                            httpMethod = new TraceMethod(urlStr);
                        } else if (method.equals("OPTIONS")) {
                            httpMethod = new OptionsMethod(urlStr);
                        } else if (method.equals("DELETE")) {
                            httpMethod = new DeleteMethod(urlStr);
                        } else {
                            if (!method.equals("GET")) throw new IllegalArgumentException("Unexpected method: " + method);
                            httpMethod = new GetMethod(urlStr);
                        }
                        CacheManager cacheManager = this.getCacheManager();
                        if (cacheManager != null && "GET".equalsIgnoreCase(method) && cacheManager.inCache(url)) {
                            res.sampleEnd();
                            res.setResponseNoContent();
                            res.setSuccessful(true);
                            hTTPSampleResult2 = res;
                            Object var17_15 = null;
                            this.savedClient = null;
                            if (httpMethod == null) return hTTPSampleResult2;
                            break block34;
                        }
                        this.setDefaultRequestHeaders((HttpMethod)httpMethod);
                        this.savedClient = client = this.setupConnection(url, (HttpMethodBase)httpMethod, res);
                        if (method.equals("POST")) {
                            String postBody = this.sendPostData(httpMethod);
                            res.setQueryString(postBody);
                        } else if (method.equals("PUT")) {
                            String putBody = this.sendPutData((PutMethod)httpMethod);
                            res.setQueryString(putBody);
                        }
                        int statusCode = client.executeMethod((HttpMethod)httpMethod);
                        res.setRequestHeaders(this.getConnectionHeaders((HttpMethod)httpMethod));
                        InputStream instream = httpMethod.getResponseBodyAsStream();
                        if (instream != null) {
                            instream = new CountingInputStream(instream);
                            try {
                                Header responseHeader = httpMethod.getResponseHeader("content-encoding");
                                if (responseHeader != null && "gzip".equals(responseHeader.getValue())) {
                                    GZIPInputStream tmpInput = new GZIPInputStream(instream);
                                    res.setResponseData(this.readResponse((SampleResult)res, tmpInput, (int)httpMethod.getResponseContentLength()));
                                } else {
                                    res.setResponseData(this.readResponse((SampleResult)res, instream, (int)httpMethod.getResponseContentLength()));
                                }
                                Object var15_25 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_26 = null;
                                JOrphanUtils.closeQuietly((Closeable)instream);
                                throw throwable;
                            }
                            JOrphanUtils.closeQuietly((Closeable)instream);
                        }
                        res.sampleEnd();
                        res.setSampleLabel(httpMethod.getURI().toString());
                        res.setResponseCode(Integer.toString(statusCode));
                        res.setSuccessful(this.isSuccessCode(statusCode));
                        res.setResponseMessage(httpMethod.getStatusText());
                        String ct = null;
                        Header h = httpMethod.getResponseHeader("Content-Type");
                        if (h != null) {
                            ct = h.getValue();
                            res.setContentType(ct);
                            res.setEncodingAndType(ct);
                        }
                        res.setResponseHeaders(this.getResponseHeaders((HttpMethod)httpMethod));
                        if (res.isRedirect()) {
                            Header headerLocation = httpMethod.getResponseHeader("Location");
                            if (headerLocation == null) {
                                throw new IllegalArgumentException("Missing location header");
                            }
                            res.setRedirectLocation(headerLocation.getValue());
                        }
                        if (instream != null) {
                            res.setBodySize(((CountingInputStream)instream).getCount());
                        }
                        res.setHeadersSize(HTTPHC3Impl.calculateHeadersSize((HttpMethodBase)httpMethod));
                        if (log.isDebugEnabled()) {
                            log.debug("Response headersSize=" + res.getHeadersSize() + " bodySize=" + res.getBodySize() + " Total=" + (res.getHeadersSize() + res.getBodySize()));
                        }
                        if (this.getAutoRedirects()) {
                            res.setURL(new URL(httpMethod.getURI().toString()));
                        }
                        this.saveConnectionCookies((HttpMethod)httpMethod, res.getURL(), this.getCookieManager());
                        if (cacheManager != null) {
                            cacheManager.saveDetails((HttpMethod)httpMethod, (SampleResult)res);
                        }
                        res = this.resultProcessing(areFollowingRedirect, frameDepth, res);
                        log.debug("End : sample");
                        hTTPSampleResult = res;
                        break block35;
                    }
                    catch (IllegalArgumentException e) {
                        res.sampleEnd();
                        this.errorResult(e, res);
                        HTTPSampleResult hTTPSampleResult3 = res;
                        Object var17_17 = null;
                        this.savedClient = null;
                        if (httpMethod == null) return hTTPSampleResult3;
                        httpMethod.releaseConnection();
                        return hTTPSampleResult3;
                    }
                    catch (IOException e) {
                        res.sampleEnd();
                        this.errorResult(e, res);
                        HTTPSampleResult hTTPSampleResult4 = res;
                        Object var17_18 = null;
                        this.savedClient = null;
                        if (httpMethod == null) return hTTPSampleResult4;
                        httpMethod.releaseConnection();
                        return hTTPSampleResult4;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    this.savedClient = null;
                    if (httpMethod == null) throw throwable;
                    httpMethod.releaseConnection();
                    throw throwable;
                }
            }
            httpMethod.releaseConnection();
            return hTTPSampleResult2;
        }
        Object var17_16 = null;
        this.savedClient = null;
        if (httpMethod == null) return hTTPSampleResult;
        httpMethod.releaseConnection();
        return hTTPSampleResult;
    }

    private static int calculateHeadersSize(HttpMethodBase httpMethod) {
        int headerSize = httpMethod.getStatusLine().toString().length() + 2;
        Header[] rh = httpMethod.getResponseHeaders();
        for (int i = 0; i < rh.length; ++i) {
            headerSize += rh[i].toString().length();
        }
        return headerSize += 2;
    }

    protected HttpClient setupConnection(URL u, HttpMethodBase httpMethod, HTTPSampleResult res) throws IOException {
        int cto;
        String urlStr = u.toString();
        URI uri = new URI(urlStr, false);
        String schema = uri.getScheme();
        if (schema == null || schema.length() == 0) {
            schema = "http";
        }
        if ("https".equalsIgnoreCase(schema)) {
            SSLManager.getInstance();
        }
        Protocol protocol = Protocol.getProtocol((String)schema);
        String host = uri.getHost();
        int port = uri.getPort();
        HostConfiguration hc = new HostConfiguration();
        hc.setHost(host, port, protocol);
        if (localAddress != null) {
            hc.setLocalAddress(localAddress);
        } else {
            String ipSource = this.getIpSource();
            if (ipSource.length() > 0) {
                InetAddress inetAddr = InetAddress.getByName(ipSource);
                hc.setLocalAddress(inetAddr);
            }
        }
        String proxyHost = this.getProxyHost();
        int proxyPort = this.getProxyPortInt();
        boolean useStaticProxy = HTTPHC3Impl.isStaticProxy(host);
        boolean useDynamicProxy = this.isDynamicProxy(proxyHost, proxyPort);
        if (useDynamicProxy) {
            hc.setProxy(proxyHost, proxyPort);
            useStaticProxy = false;
        } else if (useStaticProxy) {
            if (log.isDebugEnabled()) {
                log.debug("Setting proxy: " + PROXY_HOST + ":" + PROXY_PORT);
            }
            hc.setProxy(PROXY_HOST, PROXY_PORT);
        }
        Map<HostConfiguration, HttpClient> map = httpClients.get();
        HttpClient httpClient = map.get(hc);
        if (httpClient == null) {
            httpClient = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager());
            httpClient.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(RETRY_COUNT, false));
            if (log.isDebugEnabled()) {
                log.debug("Created new HttpClient: @" + System.identityHashCode(httpClient));
            }
            httpClient.setHostConfiguration(hc);
            map.put(hc, httpClient);
        } else if (log.isDebugEnabled()) {
            log.debug("Reusing the HttpClient: @" + System.identityHashCode(httpClient));
        }
        if (useDynamicProxy) {
            String user = this.getProxyUser();
            if (user.length() > 0) {
                httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort, null, AuthScope.ANY_SCHEME), (Credentials)new NTCredentials(user, this.getProxyPass(), localHost, PROXY_DOMAIN));
            } else {
                httpClient.getState().clearProxyCredentials();
            }
        } else if (useStaticProxy) {
            if (PROXY_USER.length() > 0) {
                httpClient.getState().setProxyCredentials(new AuthScope(PROXY_HOST, PROXY_PORT, null, AuthScope.ANY_SCHEME), (Credentials)new NTCredentials(PROXY_USER, PROXY_PASS, localHost, PROXY_DOMAIN));
            }
        } else {
            httpClient.getState().clearProxyCredentials();
        }
        int rto = this.getResponseTimeout();
        if (rto > 0) {
            httpMethod.getParams().setSoTimeout(rto);
        }
        if ((cto = this.getConnectTimeout()) > 0) {
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(cto);
        }
        httpMethod.setFollowRedirects(this.getAutoRedirects());
        if (this.getUseKeepAlive()) {
            httpMethod.setRequestHeader("Connection", "keep-alive");
        } else {
            httpMethod.setRequestHeader("Connection", "close");
        }
        this.setConnectionHeaders((HttpMethod)httpMethod, u, this.getHeaderManager(), this.getCacheManager());
        String cookies = this.setConnectionCookie((HttpMethod)httpMethod, u, this.getCookieManager());
        this.setConnectionAuthorization(httpClient, u, this.getAuthManager());
        if (res != null) {
            res.setCookies(cookies);
        }
        return httpClient;
    }

    protected void setDefaultRequestHeaders(HttpMethod httpMethod) {
    }

    protected String getResponseHeaders(HttpMethod method) {
        StringBuilder headerBuf = new StringBuilder();
        Header[] rh = method.getResponseHeaders();
        headerBuf.append(method.getStatusLine());
        headerBuf.append("\n");
        for (int i = 0; i < rh.length; ++i) {
            String key = rh[i].getName();
            headerBuf.append(key);
            headerBuf.append(": ");
            headerBuf.append(rh[i].getValue());
            headerBuf.append("\n");
        }
        return headerBuf.toString();
    }

    private String setConnectionCookie(HttpMethod method, URL u, CookieManager cookieManager) {
        String cookieHeader = null;
        if (cookieManager != null && (cookieHeader = cookieManager.getCookieHeaderForURL(u)) != null) {
            method.setRequestHeader("Cookie", cookieHeader);
        }
        return cookieHeader;
    }

    private void setConnectionHeaders(HttpMethod method, URL u, HeaderManager headerManager, CacheManager cacheManager) {
        CollectionProperty headers;
        if (headerManager != null && (headers = headerManager.getHeaders()) != null) {
            PropertyIterator i = headers.iterator();
            while (i.hasNext()) {
                org.apache.jmeter.protocol.http.control.Header header = (org.apache.jmeter.protocol.http.control.Header)i.next().getObjectValue();
                String n = header.getName();
                if ("Content-Length".equalsIgnoreCase(n)) continue;
                String v = header.getValue();
                if ("Host".equalsIgnoreCase(n)) {
                    v = v.replaceFirst(":\\d+$", "");
                    method.getParams().setVirtualHost(v);
                    continue;
                }
                method.addRequestHeader(n, v);
            }
        }
        if (cacheManager != null) {
            cacheManager.setHeaders(u, method);
        }
    }

    protected String getConnectionHeaders(HttpMethod method) {
        StringBuilder hdrs = new StringBuilder(100);
        Header[] requestHeaders = method.getRequestHeaders();
        for (int i = 0; i < requestHeaders.length; ++i) {
            if ("Cookie".equalsIgnoreCase(requestHeaders[i].getName())) continue;
            hdrs.append(requestHeaders[i].getName());
            hdrs.append(": ");
            hdrs.append(requestHeaders[i].getValue());
            hdrs.append("\n");
        }
        return hdrs.toString();
    }

    private void setConnectionAuthorization(HttpClient client, URL u, AuthManager authManager) {
        HttpState state = client.getState();
        if (authManager != null) {
            HttpClientParams params = client.getParams();
            Authorization auth = authManager.getAuthForURL(u);
            if (auth != null) {
                String username = auth.getUser();
                String realm = auth.getRealm();
                String domain = auth.getDomain();
                if (log.isDebugEnabled()) {
                    log.debug(username + " >  D=" + username + " D=" + domain + " R=" + realm);
                }
                state.setCredentials(new AuthScope(u.getHost(), u.getPort(), realm.length() == 0 ? null : realm, AuthScope.ANY_SCHEME), (Credentials)new NTCredentials(username, auth.getPass(), localHost, domain));
                if (canSetPreEmptive) {
                    log.debug("Setting Pre-emptive authentication");
                    params.setAuthenticationPreemptive(true);
                }
            } else {
                state.clearCredentials();
                if (canSetPreEmptive) {
                    params.setAuthenticationPreemptive(false);
                }
            }
        } else {
            state.clearCredentials();
        }
    }

    private String sendPostData(PostMethod post) throws IOException {
        StringBuilder postedBody = new StringBuilder(1000);
        HTTPFileArg[] files = this.getHTTPFiles();
        if (this.getUseMultipartForPost()) {
            String contentEncoding = this.getContentEncoding();
            if (HTTPHC3Impl.isNullOrEmptyTrimmed(contentEncoding)) {
                contentEncoding = null;
            }
            boolean browserCompatible = this.getDoBrowserCompatibleMultipart();
            ArrayList<Object> partlist = new ArrayList<Object>();
            PropertyIterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                String parameterName;
                HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                if (arg.isSkippable(parameterName = arg.getName())) continue;
                StringPart part = new StringPart(arg.getName(), arg.getValue(), contentEncoding);
                if (browserCompatible) {
                    part.setTransferEncoding(null);
                    part.setContentType(null);
                }
                partlist.add(part);
            }
            for (int i = 0; i < files.length; ++i) {
                HTTPFileArg file = files[i];
                File inputFile = new File(file.getPath());
                ViewableFilePart filePart = new ViewableFilePart(file.getParamName(), inputFile, file.getMimeType(), null);
                filePart.setCharSet(null);
                partlist.add((Object)filePart);
            }
            int partNo = partlist.size();
            Part[] parts = partlist.toArray(new Part[partNo]);
            MultipartRequestEntity multiPart = new MultipartRequestEntity(parts, post.getParams());
            post.setRequestEntity((RequestEntity)multiPart);
            String multiPartContentType = multiPart.getContentType();
            post.setRequestHeader("Content-Type", multiPartContentType);
            if (multiPart.isRepeatable()) {
                for (int i = 0; i < partNo; ++i) {
                    if (!(parts[i] instanceof ViewableFilePart)) continue;
                    ((ViewableFilePart)parts[i]).setHideFileData(true);
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                multiPart.writeRequest((OutputStream)bos);
                bos.flush();
                postedBody.append(new String(bos.toByteArray(), contentEncoding == null ? "US-ASCII" : contentEncoding));
                bos.close();
                for (int i = 0; i < partNo; ++i) {
                    if (!(parts[i] instanceof ViewableFilePart)) continue;
                    ((ViewableFilePart)parts[i]).setHideFileData(false);
                }
            } else {
                postedBody.append("<Multipart was not repeatable, cannot view what was sent>");
            }
        } else {
            boolean hasContentTypeHeader;
            Header contentTypeHeader = post.getRequestHeader("Content-Type");
            boolean bl = hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.getValue() != null && contentTypeHeader.getValue().length() > 0;
            if (!this.hasArguments() && this.getSendFileAsPostBody()) {
                HTTPFileArg file = files[0];
                if (!hasContentTypeHeader) {
                    if (file.getMimeType() != null && file.getMimeType().length() > 0) {
                        post.setRequestHeader("Content-Type", file.getMimeType());
                    } else {
                        post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                }
                FileRequestEntity fileRequestEntity = new FileRequestEntity(new File(file.getPath()), null);
                post.setRequestEntity((RequestEntity)fileRequestEntity);
                postedBody.append("<actual file content, not shown here>");
            } else {
                String contentEncoding = this.getContentEncoding();
                boolean haveContentEncoding = false;
                if (HTTPHC3Impl.isNullOrEmptyTrimmed(contentEncoding)) {
                    contentEncoding = null;
                } else {
                    post.getParams().setContentCharset(contentEncoding);
                    haveContentEncoding = true;
                }
                if (this.getSendParameterValuesAsPostBody()) {
                    if (!hasContentTypeHeader) {
                        HTTPFileArg file;
                        HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                        if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                            post.setRequestHeader("Content-Type", file.getMimeType());
                        } else {
                            post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    StringBuilder postBody = new StringBuilder();
                    PropertyIterator args = this.getArguments().iterator();
                    while (args.hasNext()) {
                        HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                        String value = haveContentEncoding ? arg.getEncodedValue(contentEncoding) : arg.getEncodedValue();
                        postBody.append(value);
                    }
                    StringRequestEntity requestEntity = new StringRequestEntity(postBody.toString(), post.getRequestHeader("Content-Type").getValue(), contentEncoding);
                    post.setRequestEntity((RequestEntity)requestEntity);
                } else {
                    if (!hasContentTypeHeader) {
                        post.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    PropertyIterator args = this.getArguments().iterator();
                    while (args.hasNext()) {
                        String parameterName;
                        HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                        if (arg.isSkippable(parameterName = arg.getName())) continue;
                        String parameterValue = arg.getValue();
                        if (!arg.isAlwaysEncoded()) {
                            String urlContentEncoding = contentEncoding;
                            if (urlContentEncoding == null || urlContentEncoding.length() == 0) {
                                urlContentEncoding = "UTF-8";
                            }
                            parameterName = URLDecoder.decode(parameterName, urlContentEncoding);
                            parameterValue = URLDecoder.decode(parameterValue, urlContentEncoding);
                        }
                        post.addParameter(parameterName, parameterValue);
                    }
                }
                if (post.getRequestEntity().isRepeatable()) {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    post.getRequestEntity().writeRequest((OutputStream)bos);
                    bos.flush();
                    postedBody.append(new String(bos.toByteArray(), post.getRequestCharSet()));
                    bos.close();
                } else {
                    postedBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
                }
            }
        }
        post.setRequestHeader("Content-Length", Long.toString(post.getRequestEntity().getContentLength()));
        return postedBody.toString();
    }

    private String sendPutData(PutMethod put) throws IOException {
        StringBuilder putBody = new StringBuilder(1000);
        boolean hasPutBody = false;
        Header contentTypeHeader = put.getRequestHeader("Content-Type");
        boolean hasContentTypeHeader = contentTypeHeader != null && contentTypeHeader.getValue() != null && contentTypeHeader.getValue().length() > 0;
        HTTPFileArg[] files = this.getHTTPFiles();
        if (!this.hasArguments() && this.getSendFileAsPostBody()) {
            hasPutBody = true;
            FileRequestEntity fileRequestEntity = new FileRequestEntity(new File(files[0].getPath()), null);
            put.setRequestEntity((RequestEntity)fileRequestEntity);
            putBody.append("<actual file content, not shown here>");
        } else if (this.getSendParameterValuesAsPostBody()) {
            hasPutBody = true;
            String contentEncoding = this.getContentEncoding();
            boolean haveContentEncoding = false;
            if (HTTPHC3Impl.isNullOrEmptyTrimmed(contentEncoding)) {
                contentEncoding = null;
            } else {
                put.getParams().setContentCharset(contentEncoding);
                haveContentEncoding = true;
            }
            StringBuilder putBodyContent = new StringBuilder();
            PropertyIterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
                String value = null;
                value = haveContentEncoding ? arg.getEncodedValue(contentEncoding) : arg.getEncodedValue();
                putBodyContent.append(value);
            }
            String contentTypeValue = null;
            if (hasContentTypeHeader) {
                contentTypeValue = put.getRequestHeader("Content-Type").getValue();
            }
            StringRequestEntity requestEntity = new StringRequestEntity(putBodyContent.toString(), contentTypeValue, put.getRequestCharSet());
            put.setRequestEntity((RequestEntity)requestEntity);
        }
        if (hasPutBody) {
            if (put.getRequestEntity().isRepeatable()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                put.getRequestEntity().writeRequest((OutputStream)bos);
                bos.flush();
                putBody.append(new String(bos.toByteArray(), put.getRequestCharSet()));
                bos.close();
            } else {
                putBody.append("<RequestEntity was not repeatable, cannot view what was sent>");
            }
            if (!hasContentTypeHeader) {
                HTTPFileArg file;
                HTTPFileArg hTTPFileArg = file = files.length > 0 ? files[0] : null;
                if (file != null && file.getMimeType() != null && file.getMimeType().length() > 0) {
                    put.setRequestHeader("Content-Type", file.getMimeType());
                }
            }
            put.setRequestHeader("Content-Length", Long.toString(put.getRequestEntity().getContentLength()));
            return putBody.toString();
        }
        return null;
    }

    protected void saveConnectionCookies(HttpMethod method, URL u, CookieManager cookieManager) {
        if (cookieManager != null) {
            Header[] hdr = method.getResponseHeaders("set-cookie");
            for (int i = 0; i < hdr.length; ++i) {
                cookieManager.addCookieFromHeader(hdr[i].getValue(), u);
            }
        }
    }

    public void threadFinished() {
        log.debug("Thread Finished");
        this.closeThreadLocalConnections();
    }

    private void closeThreadLocalConnections() {
        Map<HostConfiguration, HttpClient> map = httpClients.get();
        if (map != null) {
            for (HttpClient cl : map.values()) {
                cl.getHttpConnectionManager().closeIdleConnections(-1000L);
            }
            map.clear();
        }
    }

    public boolean interrupt() {
        HttpClient client = this.savedClient;
        if (client != null) {
            this.savedClient = null;
            HttpConnectionManager httpConnectionManager = client.getHttpConnectionManager();
            if (httpConnectionManager instanceof SimpleHttpConnectionManager) {
                ((SimpleHttpConnectionManager)httpConnectionManager).shutdown();
            }
        }
        return client != null;
    }

    protected void notifySSLContextWasReset() {
        log.debug("freeThreadConnections called");
        this.closeThreadLocalConnections();
    }

    static {
        httpClients = new ThreadLocal<Map<HostConfiguration, HttpClient>>(){

            @Override
            protected Map<HostConfiguration, HttpClient> initialValue() {
                return new HashMap<HostConfiguration, HttpClient>();
            }
        };
        log.info("HTTP request retry count = " + RETRY_COUNT);
        if (CPS_HTTP > 0) {
            log.info("Setting up HTTP SlowProtocol, cps=" + CPS_HTTP);
            Protocol.registerProtocol((String)"http", (Protocol)new Protocol("http", (ProtocolSocketFactory)new SlowHttpClientSocketFactory(CPS_HTTP), 80));
        }
        HttpParams params = DefaultHttpParams.getDefaultParams();
        String file = JMeterUtils.getProperty((String)"httpclient.parameters.file");
        if (file != null) {
            HttpClientDefaultParameters.load(file, params);
        }
        canSetPreEmptive = params.getParameter(HTTP_AUTHENTICATION_PREEMPTIVE) == null;
        try {
            params.setParameter("http.protocol.version", (Object)HttpVersion.parse((String)("HTTP/" + HTTP_VERSION)));
        }
        catch (ProtocolException e) {
            log.warn("Problem setting protocol version " + e.getLocalizedMessage());
        }
        if (SO_TIMEOUT >= 0) {
            params.setIntParameter("http.socket.timeout", SO_TIMEOUT);
        }
        params.setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
        if (USE_LOOPBACK) {
            LoopbackHttpClientSocketFactory.setup();
        }
    }

    private static class ViewableFilePart
    extends FilePart {
        private boolean hideFileData = false;

        public ViewableFilePart(String name, File file, String contentType, String charset) throws FileNotFoundException {
            super(name, file, contentType, charset);
        }

        public void setHideFileData(boolean hideFileData) {
            this.hideFileData = hideFileData;
        }

        protected void sendData(OutputStream out) throws IOException {
            if (this.hideFileData) {
                out.write("<actual file content, not shown here>".getBytes());
            } else {
                super.sendData(out);
            }
        }
    }
}

