/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control;

import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.protocol.http.control.HttpMirrorThread;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class HttpMirrorServer
extends Thread
implements Stoppable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final int ACCEPT_TIMEOUT = 1000;
    private static final long KEEP_ALIVE_TIME = 10L;
    private final int daemonPort;
    private volatile boolean running;
    private volatile Exception except;
    private int maxThreadPoolSize;
    private int maxQueueSize;

    public HttpMirrorServer(int port) {
        this(port, 0, 25);
    }

    public HttpMirrorServer(int port, int maxThreadPoolSize, int maxQueueSize) {
        super("HttpMirrorServer");
        this.daemonPort = port;
        this.maxThreadPoolSize = maxThreadPoolSize;
        this.maxQueueSize = maxQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            ServerSocket mainSocket;
            block12: {
                this.except = null;
                this.running = true;
                mainSocket = null;
                ThreadPoolExecutor threadPoolExecutor = null;
                if (this.maxThreadPoolSize > 0) {
                    ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(this.maxQueueSize);
                    threadPoolExecutor = new ThreadPoolExecutor(this.maxThreadPoolSize / 2, this.maxThreadPoolSize, 10L, TimeUnit.SECONDS, queue);
                    threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
                }
                try {
                    log.info("Creating HttpMirror ... on port " + this.daemonPort);
                    mainSocket = new ServerSocket(this.daemonPort);
                    mainSocket.setSoTimeout(1000);
                    log.info("HttpMirror up and running!");
                    while (this.running) {
                        try {
                            Socket clientSocket = mainSocket.accept();
                            if (this.running) {
                                if (threadPoolExecutor != null) {
                                    threadPoolExecutor.execute(new HttpMirrorThread(clientSocket));
                                    continue;
                                }
                                Thread thd = new Thread(new HttpMirrorThread(clientSocket));
                                log.debug("Starting new Mirror thread");
                                thd.start();
                                continue;
                            }
                            log.warn("Server not running");
                            JOrphanUtils.closeQuietly((Socket)clientSocket);
                        }
                        catch (InterruptedIOException e) {}
                    }
                    log.info("HttpMirror Server stopped");
                    if (threadPoolExecutor == null) break block12;
                    threadPoolExecutor.shutdownNow();
                }
                catch (Exception e) {
                    this.except = e;
                    log.warn("HttpMirror Server stopped", (Throwable)e);
                    break block13;
                }
                finally {
                    if (threadPoolExecutor != null) {
                        threadPoolExecutor.shutdownNow();
                    }
                    JOrphanUtils.closeQuietly(mainSocket);
                }
            }
            JOrphanUtils.closeQuietly((ServerSocket)mainSocket);
        }
    }

    public void stopServer() {
        this.running = false;
    }

    public Exception getException() {
        return this.except;
    }

    public static void main(String[] args) {
        int port = 8081;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        LoggingManager.setPriority((String)"INFO");
        LoggingManager.setLoggingLevels((Properties)System.getProperties());
        HttpMirrorServer serv = new HttpMirrorServer(port);
        serv.start();
    }
}

