/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.StaticHost;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DNSCachePanel
extends AbstractConfigGui
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DNSCachePanel.class);
    private static final long serialVersionUID = 2120L;
    public static final String OPTIONS = JMeterUtils.getResString((String)"option");
    private static final String ADD_COMMAND = JMeterUtils.getResString((String)"add");
    private static final String ADD_HOST_COMMAND = JMeterUtils.getResString((String)"add_host");
    private static final String DELETE_COMMAND = JMeterUtils.getResString((String)"delete");
    private static final String DELETE_HOST_COMMAND = JMeterUtils.getResString((String)"delete_host");
    private static final String SYS_RES_COMMAND = JMeterUtils.getResString((String)"use_system_dns_resolver");
    private static final String CUST_RES_COMMAND = JMeterUtils.getResString((String)"use_custom_dns_resolver");
    private JTable dnsHostsTable;
    private JPanel dnsHostsPanel;
    private JPanel dnsHostsButPanel;
    private JTable dnsServersTable;
    private JPanel dnsServersPanel;
    private JPanel dnsServButPanel;
    private PowerTableModel dnsServersTableModel;
    private PowerTableModel dnsHostsTableModel;
    private JRadioButton sysResButton;
    private JRadioButton custResButton;
    private JButton deleteButton;
    private JButton addButton;
    private JButton addHostButton;
    private JButton deleteHostButton;
    private ButtonGroup providerDNSradioGroup = new ButtonGroup();
    private static final String[] COLUMN_RESOURCE_NAMES = new String[]{JMeterUtils.getResString((String)"dns_hostname_or_ip")};
    private static final Class<?>[] columnClasses = new Class[]{String.class};
    private static final String[] HOSTS_COLUMN_RESOURCE_NAMES = new String[]{JMeterUtils.getResString((String)"dns_host"), JMeterUtils.getResString((String)"dns_hostname_or_ip")};
    private static final Class<?>[] HOSTS_COLUMN_CLASSES = new Class[]{String.class, String.class};
    private JCheckBox clearEachIteration;

    public DNSCachePanel() {
        this.init();
    }

    public String getLabelResource() {
        return "dns_cache_manager_title";
    }

    public void modifyTestElement(TestElement dnsRes) {
        GuiUtils.stopTableEditing((JTable)this.dnsServersTable);
        dnsRes.clear();
        this.configureTestElement(dnsRes);
        if (dnsRes instanceof DNSCacheManager) {
            int i;
            DNSCacheManager dnsCacheManager = (DNSCacheManager)dnsRes;
            for (i = 0; i < this.dnsServersTableModel.getRowCount(); ++i) {
                String server = (String)this.dnsServersTableModel.getRowData(i)[0];
                dnsCacheManager.addServer(server);
            }
            for (i = 0; i < this.dnsHostsTableModel.getRowCount(); ++i) {
                String host = (String)this.dnsHostsTableModel.getRowData(i)[0];
                String addresses = (String)this.dnsHostsTableModel.getRowData(i)[1];
                dnsCacheManager.addHost(host, addresses);
            }
            dnsCacheManager.setClearEachIteration(this.clearEachIteration.isSelected());
            if (this.providerDNSradioGroup.isSelected(this.custResButton.getModel())) {
                dnsCacheManager.setCustomResolver(true);
            } else {
                dnsCacheManager.setCustomResolver(false);
            }
        }
    }

    public void clearGui() {
        super.clearGui();
        this.clearEachIteration.setSelected(false);
        this.providerDNSradioGroup.setSelected(this.sysResButton.getModel(), true);
        this.dnsServersTableModel.clearData();
        this.deleteButton.setEnabled(false);
        this.dnsHostsTableModel.clearData();
        this.deleteHostButton.setEnabled(false);
    }

    private void populateTable(DNSCacheManager resolver) {
        this.dnsServersTableModel.clearData();
        for (JMeterProperty jMeterProperty : resolver.getServers()) {
            this.addServerToTable((String)jMeterProperty.getObjectValue());
        }
    }

    private void populateHostsTable(DNSCacheManager resolver) {
        this.dnsHostsTableModel.clearData();
        for (JMeterProperty hostEntry : resolver.getHosts()) {
            this.addHostToTable((StaticHost)hostEntry.getObjectValue());
        }
    }

    public TestElement createTestElement() {
        DNSCacheManager dnsCacheManager = new DNSCacheManager();
        this.modifyTestElement((TestElement)dnsCacheManager);
        return dnsCacheManager;
    }

    public void configure(TestElement el) {
        super.configure(el);
        DNSCacheManager dnsCacheManager = (DNSCacheManager)el;
        this.populateTable(dnsCacheManager);
        this.populateHostsTable(dnsCacheManager);
        this.clearEachIteration.setSelected(dnsCacheManager.isClearEachIteration());
        if (dnsCacheManager.isCustomResolver()) {
            this.providerDNSradioGroup.setSelected(this.custResButton.getModel(), true);
            this.deleteButton.setEnabled(this.dnsServersTable.getColumnCount() > 0);
            this.deleteHostButton.setEnabled(this.dnsHostsTable.getColumnCount() > 0);
            this.addButton.setEnabled(true);
            this.addHostButton.setEnabled(true);
        } else {
            this.providerDNSradioGroup.setSelected(this.sysResButton.getModel(), true);
        }
    }

    private void init() {
        this.dnsServersTableModel = new PowerTableModel(COLUMN_RESOURCE_NAMES, (Class[])columnClasses);
        this.dnsHostsTableModel = new PowerTableModel(HOSTS_COLUMN_RESOURCE_NAMES, (Class[])HOSTS_COLUMN_CLASSES);
        this.clearEachIteration = new JCheckBox(JMeterUtils.getResString((String)"clear_cache_each_iteration"), true);
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        JPanel northPanel = new JPanel();
        northPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        northPanel.add(this.makeTitlePanel());
        JPanel optionsPane = new JPanel();
        optionsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), OPTIONS));
        optionsPane.setLayout((LayoutManager)new VerticalLayout(5, 3));
        optionsPane.add((Component)this.clearEachIteration, "West");
        optionsPane.add((Component)this.createChooseResPanel(), "South");
        northPanel.add(optionsPane);
        this.add(northPanel, "North");
        JPanel tables = new JPanel();
        tables.setLayout((LayoutManager)new VerticalLayout(2, 3));
        this.dnsServersPanel = this.createDnsServersTablePanel();
        this.dnsHostsPanel = this.createDnsHostsTablePanel();
        tables.add(this.dnsServersPanel);
        tables.add(this.dnsHostsPanel);
        this.add(tables, "Center");
    }

    public JPanel createDnsServersTablePanel() {
        this.dnsServersTable = new JTable((TableModel)this.dnsServersTableModel);
        JMeterUtils.applyHiDPI((JTable)this.dnsServersTable);
        this.dnsServersTable.setSelectionMode(0);
        this.dnsServersTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"dns_servers")));
        JScrollPane dnsServScrollPane = (JScrollPane)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.dnsServersTable));
        panel.add((Component)dnsServScrollPane, "Center");
        this.dnsServButPanel = this.createButtonPanel();
        panel.add((Component)this.dnsServButPanel, "South");
        return panel;
    }

    public JPanel createDnsHostsTablePanel() {
        this.dnsHostsTable = new JTable((TableModel)this.dnsHostsTableModel);
        JMeterUtils.applyHiDPI((JTable)this.dnsHostsTable);
        this.dnsHostsTable.setSelectionMode(0);
        this.dnsHostsTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"dns_hosts")));
        JScrollPane dnsHostsScrollPane = (JScrollPane)GuiUtils.emptyBorder((JComponent)new JScrollPane(this.dnsHostsTable));
        panel.add((Component)dnsHostsScrollPane, "Center");
        this.dnsHostsButPanel = this.createHostsButtonPanel();
        panel.add((Component)this.dnsHostsButPanel, "South");
        return panel;
    }

    private JPanel createChooseResPanel() {
        JPanel chooseResPanel = new JPanel(new BorderLayout(0, 5));
        this.sysResButton = new JRadioButton();
        this.sysResButton.setSelected(true);
        this.sysResButton.setText(SYS_RES_COMMAND);
        this.sysResButton.setToolTipText(SYS_RES_COMMAND);
        this.sysResButton.setEnabled(true);
        this.sysResButton.addActionListener(this);
        this.custResButton = new JRadioButton();
        this.custResButton.setSelected(false);
        this.custResButton.setText(CUST_RES_COMMAND);
        this.custResButton.setToolTipText(CUST_RES_COMMAND);
        this.custResButton.setEnabled(true);
        this.custResButton.addActionListener(this);
        this.providerDNSradioGroup.add(this.sysResButton);
        this.providerDNSradioGroup.add(this.custResButton);
        chooseResPanel.add((Component)this.sysResButton, "West");
        chooseResPanel.add((Component)this.custResButton, "Center");
        return chooseResPanel;
    }

    private JPanel createButtonPanel() {
        boolean tableEmpty = this.dnsServersTableModel.getRowCount() == 0;
        this.addButton = this.createButton("add", 'A', ADD_COMMAND, this.custResButton.isSelected());
        this.deleteButton = this.createButton("delete", 'D', DELETE_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)this.addButton, "West");
        buttonPanel.add((Component)this.deleteButton, "After");
        return buttonPanel;
    }

    private JPanel createHostsButtonPanel() {
        boolean tableEmpty = this.dnsHostsTableModel.getRowCount() == 0;
        this.addHostButton = this.createButton("add_host", 'H', ADD_HOST_COMMAND, this.custResButton.isSelected());
        this.deleteHostButton = this.createButton("delete_host", 'X', DELETE_HOST_COMMAND, !tableEmpty);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)this.addHostButton, "West");
        buttonPanel.add((Component)this.deleteHostButton, "After");
        return buttonPanel;
    }

    private JButton createButton(String resName, char mnemonic, String command, boolean enabled) {
        JButton button = new JButton(JMeterUtils.getResString((String)resName));
        button.setMnemonic(mnemonic);
        button.setActionCommand(command);
        button.setEnabled(enabled);
        button.addActionListener(this);
        return button;
    }

    private void addServerToTable(String dnsServer) {
        this.dnsServersTableModel.addRow(new Object[]{dnsServer});
    }

    private void addHostToTable(StaticHost hostEntry) {
        LOGGER.debug("Adding entry {}", (Object)hostEntry);
        this.dnsHostsTableModel.addRow(new Object[]{hostEntry.getName(), hostEntry.getAddress()});
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        this.enableTable(this.custResButton.isSelected(), this.sysResButton.isSelected(), this.dnsServersTable, this.dnsServersTableModel, this.addButton, this.deleteButton);
        this.enableTable(this.custResButton.isSelected(), this.sysResButton.isSelected(), this.dnsHostsTable, this.dnsHostsTableModel, this.addHostButton, this.deleteHostButton);
        if (action.equals(DELETE_COMMAND)) {
            this.deleteTableRow(this.dnsServersTable, this.dnsServersTableModel, this.deleteButton);
        } else if (action.equals(ADD_COMMAND)) {
            this.addTableRow(this.dnsServersTable, this.dnsServersTableModel, this.deleteButton);
        } else if (DELETE_HOST_COMMAND.equals(action)) {
            this.deleteTableRow(this.dnsHostsTable, this.dnsHostsTableModel, this.deleteHostButton);
        } else if (ADD_HOST_COMMAND.equals(action)) {
            this.addTableRow(this.dnsHostsTable, this.dnsHostsTableModel, this.deleteHostButton);
        }
    }

    private void enableTable(boolean custEnabled, boolean sysEnabled, JTable table, PowerTableModel model, JButton addButton, JButton deleteButton) {
        table.setEnabled(custEnabled);
        Color greyColor = new Color(240, 240, 240);
        Color blueColor = new Color(184, 207, 229);
        table.setBackground(sysEnabled ? greyColor : Color.WHITE);
        table.setSelectionBackground(sysEnabled ? greyColor : blueColor);
        addButton.setEnabled(custEnabled);
        deleteButton.setEnabled(custEnabled);
        if (custEnabled && model.getRowCount() > 0) {
            deleteButton.setEnabled(true);
            addButton.setEnabled(true);
        }
    }

    private void addTableRow(JTable table, PowerTableModel model, JButton button) {
        GuiUtils.stopTableEditing((JTable)table);
        model.addNewRow();
        model.fireTableDataChanged();
        if (!button.isEnabled()) {
            button.setEnabled(true);
        }
        int rowToSelect = model.getRowCount() - 1;
        table.setRowSelectionInterval(rowToSelect, rowToSelect);
    }

    private void deleteTableRow(JTable table, PowerTableModel model, JButton button) {
        if (model.getRowCount() > 0) {
            GuiUtils.cancelEditing((JTable)table);
            int rowSelected = table.getSelectedRow();
            if (rowSelected != -1) {
                model.removeRow(rowSelected);
                model.fireTableDataChanged();
                if (model.getRowCount() == 0) {
                    button.setEnabled(false);
                } else {
                    int rowToSelect = Math.min(rowSelected, model.getRowCount() - 1);
                    table.setRowSelectionInterval(rowToSelect, rowToSelect);
                }
            }
        }
    }
}

