/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.config.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.java.config.JavaConfig;
import org.apache.jmeter.protocol.java.sampler.JavaSampler;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JFactory;
import org.apache.jorphan.gui.JLabeledChoice;
import org.apache.jorphan.reflect.ClassFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestElementMetadata(labelResource="java_request_defaults")
public class JavaConfigGui
extends AbstractConfigGui
implements ChangeListener {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(JavaConfigGui.class);
    private JLabeledChoice classNameLabeledChoice;
    private boolean displayName = true;
    private ArgumentsPanel argsPanel;
    private final JLabel warningLabel;

    public JavaConfigGui() {
        this(true);
    }

    public JavaConfigGui(boolean displayNameField) {
        this.displayName = displayNameField;
        ImageIcon image = JMeterUtils.getImage((String)"warning.png");
        this.warningLabel = new JLabel(JMeterUtils.getResString((String)"java_request_warning"), image, 2);
        this.init();
    }

    public String getLabelResource() {
        return "java_request_defaults";
    }

    private final void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        JPanel classnameRequestPanel = new JPanel(new BorderLayout(0, 5));
        classnameRequestPanel.add((Component)this.createClassnamePanel(), "North");
        classnameRequestPanel.add((Component)this.createParameterPanel(), "Center");
        this.add(classnameRequestPanel, "Center");
    }

    private JPanel createClassnamePanel() {
        List possibleClasses = new ArrayList();
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{JavaSamplerClient.class});
            possibleClasses.remove(JavaSampler.class.getName() + "$ErrorSamplerClient");
        }
        catch (Exception e) {
            log.debug("Exception getting interfaces.", (Throwable)e);
        }
        this.classNameLabeledChoice = new JLabeledChoice(JMeterUtils.getResString((String)"protocol_java_classname"), possibleClasses.toArray(ArrayUtils.EMPTY_STRING_ARRAY), true, false);
        this.classNameLabeledChoice.addChangeListener((ChangeListener)this);
        JFactory.error((JLabel)this.warningLabel);
        this.warningLabel.setVisible(false);
        VerticalPanel panel = new VerticalPanel();
        panel.add((Component)this.classNameLabeledChoice);
        panel.add((Component)this.warningLabel);
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.classNameLabeledChoice) {
            this.configureClassName();
        }
    }

    private void configureClassName() {
        String className = this.classNameLabeledChoice.getText().trim();
        try {
            JavaSamplerClient client = (JavaSamplerClient)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Arguments currArgs = new Arguments();
            this.argsPanel.modifyTestElement((TestElement)currArgs);
            Map currArgsMap = currArgs.getArgumentsAsMap();
            Arguments newArgs = new Arguments();
            Arguments testParams = null;
            try {
                testParams = client.getDefaultParameters();
            }
            catch (AbstractMethodError e) {
                log.warn("JavaSamplerClient doesn't implement getDefaultParameters.  Default parameters won't be shown.  Please update your client class: " + className);
            }
            if (testParams != null) {
                for (JMeterProperty jMeterProperty : testParams.getArguments()) {
                    String newVal;
                    Argument arg = (Argument)jMeterProperty.getObjectValue();
                    String name = arg.getName();
                    String value = arg.getValue();
                    if (currArgsMap.containsKey(name) && (newVal = (String)currArgsMap.get(name)) != null && newVal.length() > 0) {
                        value = newVal;
                    }
                    newArgs.addArgument(name, value);
                }
            }
            this.argsPanel.configure((TestElement)newArgs);
            this.warningLabel.setVisible(false);
        }
        catch (Exception e) {
            log.error("Error getting argument list for " + className, (Throwable)e);
            this.warningLabel.setVisible(true);
        }
    }

    private JPanel createParameterPanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"paramtable"));
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments").getObjectValue()));
        String className = config.getPropertyAsString("classname");
        if (!JavaConfigGui.checkContainsClassName(this.classNameLabeledChoice, className)) {
            this.classNameLabeledChoice.addValue(className);
        }
        this.warningLabel.setVisible(!this.classOk(className));
        this.classNameLabeledChoice.setText(className);
        this.configureClassName();
    }

    private boolean classOk(String className) {
        try {
            JavaSamplerClient client = (JavaSamplerClient)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return client != null;
        }
        catch (Exception ex) {
            log.error("Error creating class:'" + className + "' in JavaSampler " + this.getName() + ", check for a missing jar in your jmeter 'search_paths' and 'plugin_dependency_paths' properties", (Throwable)ex);
            return false;
        }
    }

    private static boolean checkContainsClassName(JLabeledChoice classnameChoice, String className) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(classnameChoice.getItems()));
        return set.contains(className);
    }

    public TestElement createTestElement() {
        JavaConfig config = new JavaConfig();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        this.configureTestElement(config);
        ((JavaConfig)config).setArguments((Arguments)this.argsPanel.createTestElement());
        ((JavaConfig)config).setClassname(this.classNameLabeledChoice.getText().trim());
    }

    public void clearGui() {
        super.clearGui();
        this.displayName = true;
        this.warningLabel.setVisible(false);
        this.argsPanel.clearGui();
        this.classNameLabeledChoice.setSelectedIndex(0);
    }
}

