/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.JLabeledRadioI18N;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.jms.sampler.PublisherSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledPasswordField;
import org.apache.jorphan.gui.JLabeledTextArea;
import org.apache.jorphan.gui.JLabeledTextField;

public class JMSPublisherGui
extends AbstractSamplerGui
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private static final String ALL_FILES = "*.*";
    public static final String USE_FILE_RSC = "jms_use_file";
    public static final String USE_RANDOM_RSC = "jms_use_random_file";
    private static final String USE_TEXT_RSC = "jms_use_text";
    public static final String TEXT_MSG_RSC = "jms_text_message";
    public static final String MAP_MSG_RSC = "jms_map_message";
    public static final String OBJECT_MSG_RSC = "jms_object_message";
    private static final String[] CONFIG_ITEMS = new String[]{"jms_use_file", "jms_use_random_file", "jms_use_text"};
    private static final String[] MSGTYPES_ITEMS = new String[]{"jms_text_message", "jms_map_message", "jms_object_message"};
    private final JCheckBox useProperties = new JCheckBox(JMeterUtils.getResString((String)"jms_use_properties_file"), false);
    private final JLabeledRadioI18N configChoice = new JLabeledRadioI18N("jms_config", CONFIG_ITEMS, "jms_use_text");
    private final JLabeledTextField jndiICF = new JLabeledTextField(JMeterUtils.getResString((String)"jms_initial_context_factory"));
    private final JLabeledTextField urlField = new JLabeledTextField(JMeterUtils.getResString((String)"jms_provider_url"));
    private final JLabeledTextField jndiConnFac = new JLabeledTextField(JMeterUtils.getResString((String)"jms_connection_factory"));
    private final JLabeledTextField jmsDestination = new JLabeledTextField(JMeterUtils.getResString((String)"jms_topic"));
    private final JCheckBox useAuth = new JCheckBox(JMeterUtils.getResString((String)"jms_use_auth"), false);
    private final JLabeledTextField jmsUser = new JLabeledTextField(JMeterUtils.getResString((String)"jms_user"));
    private final JLabeledTextField jmsPwd = new JLabeledPasswordField(JMeterUtils.getResString((String)"jms_pwd"));
    private final JLabeledTextField iterations = new JLabeledTextField(JMeterUtils.getResString((String)"jms_itertions"));
    private final FilePanel messageFile = new FilePanel(JMeterUtils.getResString((String)"jms_file"), "*.*");
    private final FilePanel randomFile = new FilePanel(JMeterUtils.getResString((String)"jms_random_file"), "*.*");
    private final JLabeledTextArea textMessage = new JLabeledTextArea(JMeterUtils.getResString((String)"jms_text_message"));
    private final JLabeledRadioI18N msgChoice = new JLabeledRadioI18N("jms_message_type", MSGTYPES_ITEMS, "jms_text_message");
    private static final String DEST_SETUP_STATIC = "jms_dest_setup_static";
    private static final String DEST_SETUP_DYNAMIC = "jms_dest_setup_dynamic";
    private static final String[] DEST_SETUP_ITEMS = new String[]{"jms_dest_setup_static", "jms_dest_setup_dynamic"};
    private final JLabeledRadioI18N destSetup = new JLabeledRadioI18N("jms_dest_setup", DEST_SETUP_ITEMS, "jms_dest_setup_static");

    public JMSPublisherGui() {
        this.init();
    }

    public String getLabelResource() {
        return "jms_publisher";
    }

    public TestElement createTestElement() {
        PublisherSampler sampler = new PublisherSampler();
        this.configureTestElement((TestElement)sampler);
        sampler.setUseJNDIProperties(String.valueOf(this.useProperties.isSelected()));
        sampler.setJNDIIntialContextFactory(this.jndiICF.getText());
        sampler.setProviderUrl(this.urlField.getText());
        sampler.setConnectionFactory(this.jndiConnFac.getText());
        sampler.setDestination(this.jmsDestination.getText());
        sampler.setUsername(this.jmsUser.getText());
        sampler.setPassword(this.jmsPwd.getText());
        sampler.setTextMessage(this.textMessage.getText());
        sampler.setInputFile(this.messageFile.getFilename());
        sampler.setRandomPath(this.randomFile.getFilename());
        sampler.setConfigChoice(this.configChoice.getText());
        sampler.setMessageChoice(this.msgChoice.getText());
        sampler.setIterations(this.iterations.getText());
        sampler.setUseAuth(this.useAuth.isSelected());
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        PublisherSampler sampler = (PublisherSampler)s;
        this.configureTestElement((TestElement)sampler);
        sampler.setUseJNDIProperties(String.valueOf(this.useProperties.isSelected()));
        sampler.setJNDIIntialContextFactory(this.jndiICF.getText());
        sampler.setProviderUrl(this.urlField.getText());
        sampler.setConnectionFactory(this.jndiConnFac.getText());
        sampler.setDestination(this.jmsDestination.getText());
        sampler.setUsername(this.jmsUser.getText());
        sampler.setPassword(this.jmsPwd.getText());
        sampler.setTextMessage(this.textMessage.getText());
        sampler.setInputFile(this.messageFile.getFilename());
        sampler.setRandomPath(this.randomFile.getFilename());
        sampler.setConfigChoice(this.configChoice.getText());
        sampler.setMessageChoice(this.msgChoice.getText());
        sampler.setIterations(this.iterations.getText());
        sampler.setUseAuth(this.useAuth.isSelected());
        sampler.setDestinationStatic(this.destSetup.getText().equals(DEST_SETUP_STATIC));
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        this.add((Component)mainPanel, "Center");
        mainPanel.add(this.useProperties);
        mainPanel.add((Component)this.jndiICF);
        mainPanel.add((Component)this.urlField);
        mainPanel.add((Component)this.jndiConnFac);
        mainPanel.add(this.createDestinationPane());
        mainPanel.add(this.useAuth);
        mainPanel.add((Component)this.jmsUser);
        mainPanel.add((Component)this.jmsPwd);
        mainPanel.add((Component)this.iterations);
        this.configChoice.setLayout((LayoutManager)new BoxLayout((Container)this.configChoice, 0));
        mainPanel.add((Component)this.configChoice);
        this.msgChoice.setLayout((LayoutManager)new BoxLayout((Container)this.msgChoice, 0));
        mainPanel.add((Component)this.msgChoice);
        mainPanel.add((Component)this.messageFile);
        mainPanel.add((Component)this.randomFile);
        mainPanel.add((Component)this.textMessage);
        Dimension pref = new Dimension(400, 150);
        this.textMessage.setPreferredSize(pref);
        this.useProperties.addChangeListener(this);
        this.useAuth.addChangeListener(this);
        this.configChoice.addChangeListener((ChangeListener)this);
        this.msgChoice.addChangeListener((ChangeListener)this);
    }

    public void clearGui() {
        super.clearGui();
        this.useProperties.setSelected(false);
        this.jndiICF.setText("");
        this.urlField.setText("");
        this.jndiConnFac.setText("");
        this.jmsDestination.setText("");
        this.jmsUser.setText("");
        this.jmsPwd.setText("");
        this.textMessage.setText("");
        this.messageFile.setFilename("");
        this.randomFile.setFilename("");
        this.msgChoice.setText("");
        this.configChoice.setText(USE_TEXT_RSC);
        this.updateConfig(USE_TEXT_RSC);
        this.iterations.setText("1");
        this.useAuth.setSelected(false);
        this.jmsUser.setEnabled(false);
        this.jmsPwd.setEnabled(false);
        this.destSetup.setText(DEST_SETUP_STATIC);
    }

    public void configure(TestElement el) {
        super.configure(el);
        PublisherSampler sampler = (PublisherSampler)el;
        this.useProperties.setSelected(sampler.getUseJNDIPropertiesAsBoolean());
        this.jndiICF.setText(sampler.getJNDIInitialContextFactory());
        this.urlField.setText(sampler.getProviderUrl());
        this.jndiConnFac.setText(sampler.getConnectionFactory());
        this.jmsDestination.setText(sampler.getDestination());
        this.jmsUser.setText(sampler.getUsername());
        this.jmsPwd.setText(sampler.getPassword());
        this.textMessage.setText(sampler.getTextMessage());
        this.messageFile.setFilename(sampler.getInputFile());
        this.randomFile.setFilename(sampler.getRandomPath());
        this.configChoice.setText(sampler.getConfigChoice());
        this.msgChoice.setText(sampler.getMessageChoice());
        this.updateConfig(sampler.getConfigChoice());
        this.iterations.setText(sampler.getIterations());
        this.useAuth.setSelected(sampler.isUseAuth());
        this.jmsUser.setEnabled(this.useAuth.isSelected());
        this.jmsPwd.setEnabled(this.useAuth.isSelected());
        this.destSetup.setText(sampler.isDestinationStatic() ? DEST_SETUP_STATIC : DEST_SETUP_DYNAMIC);
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.configChoice) {
            this.updateConfig(this.configChoice.getText());
        } else if (event.getSource() == this.msgChoice) {
            this.updateMessageType(this.msgChoice.getText());
        } else if (event.getSource() == this.useProperties) {
            this.jndiICF.setEnabled(!this.useProperties.isSelected());
            this.urlField.setEnabled(!this.useProperties.isSelected());
        } else if (event.getSource() == this.useAuth) {
            this.jmsUser.setEnabled(this.useAuth.isSelected());
            this.jmsPwd.setEnabled(this.useAuth.isSelected());
        }
    }

    private void updateConfig(String command) {
        if (command.equals(USE_TEXT_RSC)) {
            this.textMessage.setEnabled(true);
            this.messageFile.enableFile(false);
            this.randomFile.enableFile(false);
        } else if (command.equals(USE_RANDOM_RSC)) {
            this.textMessage.setEnabled(false);
            this.messageFile.enableFile(false);
            this.randomFile.enableFile(true);
        } else {
            this.textMessage.setEnabled(false);
            this.messageFile.enableFile(true);
            this.randomFile.enableFile(false);
        }
    }

    private void updateMessageType(String msgType) {
        if (msgType.equals(OBJECT_MSG_RSC) && this.configChoice.getText().equals(USE_TEXT_RSC)) {
            JOptionPane.showConfirmDialog((Component)((Object)this), JMeterUtils.getResString((String)"jms_error_msg"), "Warning", 2, 0);
        }
    }

    private JPanel createDestinationPane() {
        JPanel pane = new JPanel(new BorderLayout(3, 0));
        pane.add((Component)this.jmsDestination, "Center");
        this.destSetup.setLayout((LayoutManager)new BoxLayout((Container)this.destSetup, 0));
        pane.add((Component)this.destSetup, "East");
        return pane;
    }
}

