/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jorphan.gui.JLabeledField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLabeledChoice
extends JPanel
implements JLabeledField {
    private static final long serialVersionUID = 240L;
    private final JLabel mLabel = new JLabel();
    private final JComboBox choiceList;
    private final ArrayList<ChangeListener> mChangeListeners = new ArrayList(3);
    private JButton delete;
    private JButton add;

    public JLabeledChoice() {
        this.choiceList = new JComboBox();
        this.init();
    }

    public JLabeledChoice(String pLabel, boolean editable) {
        this.choiceList = new JComboBox();
        this.mLabel.setText(pLabel);
        this.choiceList.setEditable(editable);
        this.init();
    }

    public JLabeledChoice(String pLabel, String[] items) {
        this(pLabel, items, false);
    }

    public JLabeledChoice(String pLabel, String[] items, boolean editable) {
        this.mLabel.setText(pLabel);
        this.choiceList = new JComboBox<String>(items);
        this.choiceList.setEditable(editable);
        this.init();
    }

    @Override
    public List<JComponent> getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.choiceList);
        return comps;
    }

    public void setEditable(boolean editable) {
        this.choiceList.setEditable(editable);
    }

    public void addValue(String item) {
        this.choiceList.addItem(item);
    }

    public void setValues(String[] items) {
        this.choiceList.removeAllItems();
        for (int i = 0; i < items.length; ++i) {
            this.choiceList.addItem(items[i]);
        }
    }

    private void init() {
        this.choiceList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.choiceList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JLabeledChoice.this.notifyChangeListeners();
                }
            }
        });
        this.add(this.mLabel);
        this.add(this.choiceList);
        if (this.choiceList.isEditable()) {
            this.add = new JButton("Add");
            this.add.setMargin(new Insets(1, 1, 1, 1));
            this.add.addActionListener(new AddListener());
            this.add(this.add);
            this.delete = new JButton("Del");
            this.delete.setMargin(new Insets(1, 1, 1, 1));
            this.delete.addActionListener(new DeleteListener());
            this.add(this.delete);
        }
    }

    @Override
    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    @Override
    public void setText(String pText) {
        this.choiceList.setSelectedItem(pText);
    }

    public void setSelectedIndex(int index) {
        this.choiceList.setSelectedIndex(index);
    }

    @Override
    public String getText() {
        Object item = this.choiceList.getSelectedItem();
        if (item == null) {
            return "";
        }
        return (String)item;
    }

    public int getSelectedIndex() {
        return this.choiceList.getSelectedIndex();
    }

    public Object[] getSelectedItems() {
        return this.choiceList.getSelectedObjects();
    }

    public String[] getItems() {
        String[] items = new String[this.choiceList.getItemCount()];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (String)this.choiceList.getItemAt(i);
        }
        return items;
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    @Override
    public void setToolTipText(String text) {
        this.choiceList.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        if (this.choiceList == null) {
            return null;
        }
        return this.choiceList.getToolTipText();
    }

    @Override
    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int index = 0; index < this.mChangeListeners.size(); ++index) {
            this.mChangeListeners.get(index).stateChanged(ce);
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (JLabeledChoice.this.choiceList.getItemCount() > 1) {
                JLabeledChoice.this.choiceList.removeItemAt(JLabeledChoice.this.choiceList.getSelectedIndex());
                JLabeledChoice.this.notifyChangeListeners();
            }
        }
    }

    private class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object item = JLabeledChoice.this.choiceList.getSelectedItem();
            int index = JLabeledChoice.this.choiceList.getSelectedIndex();
            if (!item.equals(JLabeledChoice.this.choiceList.getItemAt(index))) {
                JLabeledChoice.this.choiceList.addItem(item);
            }
            JLabeledChoice.this.choiceList.setSelectedItem(item);
            JLabeledChoice.this.notifyChangeListeners();
        }
    }
}

