/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.jorphan.util.JOrphanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFile
extends File {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggerFactory.getLogger(TextFile.class);
    private String encoding = null;

    public TextFile(File filename, String encoding) {
        super(filename.toString());
        this.setEncoding(encoding);
    }

    public TextFile(File filename) {
        super(filename.toString());
    }

    public TextFile(String filename) {
        super(filename);
    }

    public TextFile(String filename, String encoding) {
        super(filename);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String body) {
        block5: {
            OutputStreamWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(this);
                writer = this.encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, this.encoding);
                writer.write(body);
                ((Writer)writer).flush();
                JOrphanUtils.closeQuietly(writer);
            }
            catch (IOException ioe) {
                log.error("", (Throwable)ioe);
                break block5;
            }
            finally {
                JOrphanUtils.closeQuietly(writer);
                JOrphanUtils.closeQuietly(outputStream);
            }
            JOrphanUtils.closeQuietly(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        StringBuilder sb;
        block6: {
            String lineEnd = System.getProperty("line.separator");
            sb = new StringBuilder();
            InputStreamReader reader = null;
            BufferedReader br = null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this);
                reader = this.encoding == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, this.encoding);
                br = new BufferedReader(reader);
                String line = "NOTNULL";
                while (line != null) {
                    line = br.readLine();
                    if (line == null) continue;
                    sb.append(line + lineEnd);
                }
                JOrphanUtils.closeQuietly(br);
            }
            catch (IOException ioe) {
                log.error("", (Throwable)ioe);
                break block6;
            }
            finally {
                JOrphanUtils.closeQuietly(br);
                JOrphanUtils.closeQuietly(reader);
                JOrphanUtils.closeQuietly(fileInputStream);
            }
            JOrphanUtils.closeQuietly(reader);
            JOrphanUtils.closeQuietly(fileInputStream);
        }
        return sb.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TextFile)) {
            return false;
        }
        TextFile other = (TextFile)obj;
        if (this.encoding == null) {
            return other.encoding == null;
        }
        return this.encoding.equals(other.encoding);
    }
}

