/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import javax.json.JsonStructure;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.johnzon.jaxrs.IgnorableTypes;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

@Provider
@Consumes(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JohnzonMessageBodyReader<T>
extends IgnorableTypes
implements MessageBodyReader<T> {
    private final Mapper mapper;

    public JohnzonMessageBodyReader() {
        this(new MapperBuilder().setDoCloseOnStreams(false).build(), null);
    }

    public JohnzonMessageBodyReader(Mapper mapper, Collection<String> ignoredTypes) {
        super(ignoredTypes);
        this.mapper = mapper;
    }

    public boolean isReadable(Class<?> rawType, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.isIgnored(rawType) && InputStream.class != genericType && Reader.class != genericType && Response.class != genericType && String.class != genericType && !JsonStructure.class.isAssignableFrom(rawType);
    }

    public T readFrom(Class<T> rawType, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (rawType.isArray()) {
            return (T)this.mapper.readArray(entityStream, rawType.getComponentType());
        }
        if (Collection.class.isAssignableFrom(rawType) && ParameterizedType.class.isInstance(genericType)) {
            return (T)this.mapper.readCollection(entityStream, (ParameterizedType)ParameterizedType.class.cast(genericType));
        }
        return (T)this.mapper.readObject(entityStream, genericType);
    }
}

