/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonBuilderFactory;
import javax.json.JsonValue;
import javax.json.bind.JsonbException;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNillable;
import javax.json.bind.annotation.JsonbNumberFormat;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbPropertyOrder;
import javax.json.bind.annotation.JsonbTransient;
import javax.json.bind.annotation.JsonbTypeAdapter;
import javax.json.bind.annotation.JsonbTypeDeserializer;
import javax.json.bind.annotation.JsonbTypeSerializer;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;
import javax.json.bind.serializer.DeserializationContext;
import javax.json.bind.serializer.JsonbDeserializer;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.Types;
import org.apache.johnzon.jsonb.JsonValueParserAdapter;
import org.apache.johnzon.jsonb.converter.JohnzonJsonbAdapter;
import org.apache.johnzon.jsonb.converter.JsonbDateConverter;
import org.apache.johnzon.jsonb.converter.JsonbLocalDateConverter;
import org.apache.johnzon.jsonb.converter.JsonbLocalDateTimeConverter;
import org.apache.johnzon.jsonb.converter.JsonbNumberConverter;
import org.apache.johnzon.jsonb.converter.JsonbValueConverter;
import org.apache.johnzon.jsonb.converter.JsonbZonedDateTimeConverter;
import org.apache.johnzon.jsonb.order.PerHierarchyAndLexicographicalOrderFieldComparator;
import org.apache.johnzon.jsonb.reflect.GenericArrayTypeImpl;
import org.apache.johnzon.jsonb.serializer.JohnzonDeserializationContext;
import org.apache.johnzon.jsonb.serializer.JohnzonSerializationContext;
import org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.MapperConverter;
import org.apache.johnzon.mapper.MappingGenerator;
import org.apache.johnzon.mapper.MappingParser;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.apache.johnzon.mapper.access.Meta;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.converter.ReversedAdapter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;

public class JsonbAccessMode
implements AccessMode,
Closeable {
    private final PropertyNamingStrategy naming;
    private final String order;
    private final PropertyVisibilityStrategy visibility;
    private final AccessMode delegate;
    private final boolean caseSensitive;
    private final Map<AdapterKey, Adapter<?, ?>> defaultConverters;
    private final JohnzonAdapterFactory factory;
    private final Collection<JohnzonAdapterFactory.Instance<?>> toRelease = new ArrayList();
    private final JsonProvider jsonProvider;
    private final Supplier<JsonParserFactory> parserFactory;
    private final Supplier<JsonBuilderFactory> builderFactory;
    private final ConcurrentMap<Class<?>, ParsingCacheEntry> parsingCache = new ConcurrentHashMap();
    private final BaseAccessMode partialDelegate = new BaseAccessMode(false, false){

        protected Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }

        protected Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }
    };
    private boolean failOnMissingCreatorValues;
    private final Types types = new Types();
    private final boolean globalIsNillable;
    private final boolean supportsPrivateAccess;

    public JsonbAccessMode(PropertyNamingStrategy propertyNamingStrategy, String orderValue, PropertyVisibilityStrategy visibilityStrategy, boolean caseSensitive, Map<AdapterKey, Adapter<?, ?>> defaultConverters, JohnzonAdapterFactory factory, JsonProvider jsonProvider, Supplier<JsonBuilderFactory> builderFactory, Supplier<JsonParserFactory> parserFactory, AccessMode delegate, boolean failOnMissingCreatorValues, boolean globalIsNillable, boolean supportsPrivateAccess) {
        this.globalIsNillable = globalIsNillable;
        this.naming = propertyNamingStrategy;
        this.order = orderValue;
        this.visibility = visibilityStrategy;
        this.caseSensitive = caseSensitive;
        this.delegate = delegate;
        this.defaultConverters = defaultConverters;
        this.factory = factory;
        this.builderFactory = builderFactory;
        this.jsonProvider = jsonProvider;
        this.parserFactory = parserFactory;
        this.failOnMissingCreatorValues = failOnMissingCreatorValues;
        this.supportsPrivateAccess = supportsPrivateAccess;
    }

    public Comparator<String> fieldComparator(Class<?> clazz) {
        Comparator orderComparator = this.orderComparator(clazz);
        return this.caseSensitive ? orderComparator : (o1, o2) -> o1.equalsIgnoreCase((String)o2) ? 0 : orderComparator.compare(o1, o2);
    }

    public AccessMode.Factory findFactory(Class<?> clazz, Function<AnnotatedElement, String> ... parameterNameExtractors) {
        ObjectConverter.Codec[] objectConverters;
        Adapter[] itemConverters;
        Adapter[] converters;
        String[] params;
        Type[] types;
        Consumer<Object[]> factoryValidator;
        Constructor<?> constructor = null;
        Method factory = null;
        boolean invalidConstructorForDeserialization = false;
        for (Constructor<?> c : this.supportsPrivateAccess ? clazz.getDeclaredConstructors() : clazz.getConstructors()) {
            if (!c.isAnnotationPresent(JsonbCreator.class)) continue;
            if (constructor != null) {
                throw new JsonbException("Only one constructor or method can have @JsonbCreator");
            }
            if (!c.isAccessible()) {
                c.setAccessible(true);
            }
            constructor = c;
        }
        for (Method m : this.findPotentialFactoryMethods(clazz).collect(Collectors.toList())) {
            int modifiers = m.getModifiers();
            if (!this.supportsPrivateAccess && !Modifier.isPublic(modifiers) || !m.isAnnotationPresent(JsonbCreator.class)) continue;
            if (constructor != null || factory != null) {
                throw new JsonbException("Only one constructor or method can have @JsonbCreator");
            }
            if (!m.isAccessible()) {
                m.setAccessible(true);
            }
            factory = m;
        }
        if (constructor == null && factory == null) {
            invalidConstructorForDeserialization = Stream.of(clazz.getDeclaredConstructors()).anyMatch(it -> it.getParameterCount() == 0 && !Modifier.isPublic(it.getModifiers()) && !Modifier.isProtected(it.getModifiers()));
        }
        Constructor<?> finalConstructor = constructor;
        Method finalFactory = factory;
        Consumer<Object[]> consumer = factoryValidator = this.failOnMissingCreatorValues ? args -> {
            if (args == null || Stream.of(args).anyMatch(Objects::isNull)) {
                throw new JsonbException("Missing @JsonbCreator argument");
            }
        } : args -> {};
        if (finalConstructor != null || finalFactory != null) {
            types = finalConstructor != null ? finalConstructor.getGenericParameterTypes() : finalFactory.getGenericParameterTypes();
            params = new String[types.length];
            converters = new Adapter[types.length];
            itemConverters = new Adapter[types.length];
            objectConverters = new ObjectConverter.Codec[types.length];
            int i = 0;
            for (Parameter parameter : (finalConstructor == null ? finalFactory : finalConstructor).getParameters()) {
                JsonbProperty property = JsonbAccessMode.getAnnotation(parameter, JsonbProperty.class);
                params[i] = property != null ? property.value() : parameter.getName();
                JsonbTypeAdapter adapter = JsonbAccessMode.getAnnotation(parameter, JsonbTypeAdapter.class);
                JsonbDateFormat dateFormat = JsonbAccessMode.getAnnotation(parameter, JsonbDateFormat.class);
                JsonbNumberFormat numberFormat = JsonbAccessMode.getAnnotation(parameter, JsonbNumberFormat.class);
                JohnzonConverter johnzonConverter = JsonbAccessMode.getAnnotation(parameter, JohnzonConverter.class);
                if (adapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null) {
                    converters[i] = this.defaultConverters.get(parameter.getType());
                    itemConverters[i] = null;
                } else {
                    this.validateAnnotations(parameter, adapter, dateFormat, numberFormat, johnzonConverter);
                    try {
                        if (adapter != null) {
                            Adapter<?, ?> converter = this.toConverter(this.types, parameter.getType(), adapter, dateFormat, numberFormat);
                            if (Converters.matches((Type)parameter.getParameterizedType(), converter)) {
                                converters[i] = converter;
                                itemConverters[i] = null;
                            } else {
                                converters[i] = null;
                                itemConverters[i] = converter;
                            }
                        } else if (johnzonConverter != null) {
                            objectConverters[i] = (ObjectConverter.Codec)johnzonConverter.value().newInstance();
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                ++i;
            }
        } else {
            types = null;
            params = null;
            converters = null;
            itemConverters = null;
            objectConverters = null;
        }
        if (constructor == null && factory == null && !invalidConstructorForDeserialization) {
            Stream<Function<AnnotatedElement, String>> jsonbFn = Stream.of(this::getJsonbProperty);
            return this.delegate.findFactory(clazz, (Function[])(parameterNameExtractors == null ? jsonbFn : Stream.concat(jsonbFn, Stream.of(parameterNameExtractors))).toArray(Function[]::new));
        }
        if (constructor != null || invalidConstructorForDeserialization) {
            return this.constructorFactory(finalConstructor, invalidConstructorForDeserialization ? objects -> {
                throw new JsonbException("No available constructor");
            } : factoryValidator, types, params, converters, itemConverters, objectConverters);
        }
        return this.methodFactory(clazz, finalFactory, factoryValidator, types, params, converters, itemConverters, objectConverters);
    }

    private String getJsonbProperty(AnnotatedElement a) {
        JsonbProperty p = (JsonbProperty)Meta.getAnnotation((AnnotatedElement)a, JsonbProperty.class);
        return p != null ? p.value() : null;
    }

    private Stream<Method> findPotentialFactoryMethods(Class<?> clazz) {
        return !this.supportsPrivateAccess ? Stream.of(clazz.getMethods()) : Stream.concat(Stream.of(clazz.getDeclaredMethods()), clazz.getSuperclass() == null || clazz.getSuperclass() == Object.class || clazz.getSuperclass() == clazz ? Stream.empty() : this.findPotentialFactoryMethods(clazz));
    }

    private AccessMode.Factory methodFactory(final Class<?> clazz, final Method finalFactory, final Consumer<Object[]> factoryValidator, final Type[] types, final String[] params, final Adapter<?, ?>[] converters, final Adapter<?, ?>[] itemConverters, final ObjectConverter.Codec<?>[] objectConverters) {
        final Object instance = Modifier.isStatic(finalFactory.getModifiers()) ? null : this.tryToCreateInstance(finalFactory.getDeclaringClass());
        return new AccessMode.Factory(){

            public Object create(Object[] params2) {
                factoryValidator.accept(params2);
                try {
                    Object invoke = finalFactory.invoke(instance, params2);
                    if (!clazz.isInstance(invoke)) {
                        throw new IllegalArgumentException(invoke + " is not a " + clazz.getName());
                    }
                    return invoke;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            public Type[] getParameterTypes() {
                return types;
            }

            public String[] getParameterNames() {
                return params;
            }

            public Adapter<?, ?>[] getParameterConverter() {
                return converters;
            }

            public Adapter<?, ?>[] getParameterItemConverter() {
                return itemConverters;
            }

            public ObjectConverter.Codec<?>[] getObjectConverter() {
                return objectConverters;
            }
        };
    }

    private Object tryToCreateInstance(Class<?> declaringClass) {
        try {
            Constructor<?> declaredConstructor = declaringClass.getDeclaredConstructor(new Class[0]);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private AccessMode.Factory constructorFactory(final Constructor<?> finalConstructor, final Consumer<Object[]> factoryValidator, final Type[] types, final String[] params, final Adapter<?, ?>[] converters, final Adapter<?, ?>[] itemConverters, final ObjectConverter.Codec<?>[] objectConverters) {
        return new AccessMode.Factory(){

            public Object create(Object[] params2) {
                factoryValidator.accept(params2);
                try {
                    return finalConstructor.newInstance(params2);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException(e.getCause());
                }
            }

            public Type[] getParameterTypes() {
                return types;
            }

            public String[] getParameterNames() {
                return params;
            }

            public Adapter<?, ?>[] getParameterConverter() {
                return converters;
            }

            public Adapter<?, ?>[] getParameterItemConverter() {
                return itemConverters;
            }

            public ObjectConverter.Codec<?>[] getObjectConverter() {
                return objectConverters;
            }
        };
    }

    private void validateAnnotations(Object parameter, JsonbTypeAdapter adapter, JsonbDateFormat dateFormat, JsonbNumberFormat numberFormat, JohnzonConverter johnzonConverter) {
        int notNull = adapter != null ? 1 : 0;
        notNull += dateFormat != null ? 1 : 0;
        notNull += numberFormat != null ? 1 : 0;
        if ((notNull += johnzonConverter != null ? 1 : 0) > 1) {
            throw new IllegalArgumentException("Conflicting @JsonbXXX/@JohnzonConverter on " + parameter);
        }
    }

    private Adapter<?, ?> toConverter(Types types, Type type, JsonbTypeAdapter adapter, JsonbDateFormat dateFormat, JsonbNumberFormat numberFormat) {
        Object converter;
        if (adapter != null) {
            Class value = adapter.value();
            ParameterizedType pt = types.findParameterizedType(value, JsonbAdapter.class);
            JohnzonAdapterFactory.Instance instance = this.newInstance(value);
            this.toRelease.add(instance);
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            converter = new JohnzonJsonbAdapter((JsonbAdapter)instance.getValue(), actualTypeArguments[0], actualTypeArguments[1]);
        } else {
            converter = dateFormat != null ? (Date.class == type ? new ConverterAdapter((Converter)new JsonbDateConverter(dateFormat)) : (LocalDateTime.class == type ? new ConverterAdapter((Converter)new JsonbLocalDateTimeConverter(dateFormat)) : (LocalDate.class == type ? new ConverterAdapter((Converter)new JsonbLocalDateConverter(dateFormat)) : (ZonedDateTime.class == type ? new ConverterAdapter((Converter)new JsonbZonedDateTimeConverter(dateFormat)) : null)))) : (numberFormat != null ? new ConverterAdapter((Converter)new JsonbNumberConverter(numberFormat)) : new ConverterAdapter((Converter)new JsonbValueConverter()));
        }
        return converter;
    }

    private JohnzonAdapterFactory.Instance newInstance(Class<?> value) {
        return this.factory.create(value);
    }

    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        Map readers = this.delegate.findReaders(clazz);
        Comparator<String> keyComparator = this.fieldComparator(clazz);
        HashMap<String, AccessMode.Reader> result = keyComparator == null ? new HashMap() : new TreeMap(keyComparator);
        for (Map.Entry entry : readers.entrySet()) {
            JsonbNillable nillable;
            boolean isNillable;
            Function<Object, Object> reader;
            Object type;
            FieldAndMethodAccessMode.CompositeDecoratedType decoratedType;
            AccessMode.DecoratedType type2;
            AccessMode.Reader initialReader = (AccessMode.Reader)entry.getValue();
            if (this.isTransient((AccessMode.DecoratedType)initialReader, this.visibility)) {
                this.validateAnnotationsOnTransientField((AccessMode.DecoratedType)initialReader);
                continue;
            }
            if (initialReader.getAnnotation(JohnzonAny.class) != null) continue;
            AccessMode.Reader finalReader = FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(initialReader) ? (MethodAccessMode.MethodReader.class.isInstance(type2 = (decoratedType = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(initialReader)).getType2()) ? (AccessMode.Reader)AccessMode.Reader.class.cast(type2) : initialReader) : initialReader;
            Type readerType = finalReader.getType();
            if (this.isOptional(readerType)) {
                type = ((ParameterizedType)ParameterizedType.class.cast(readerType)).getActualTypeArguments()[0];
                reader = i -> Optional.ofNullable(finalReader.read(i)).map(o -> ((Optional)Optional.class.cast(o)).orElse(null)).orElse(null);
            } else if (OptionalInt.class == readerType) {
                type = Integer.class;
                reader = i -> {
                    OptionalInt optionalInt = (OptionalInt)OptionalInt.class.cast(finalReader.read(i));
                    return optionalInt == null || !optionalInt.isPresent() ? null : Integer.valueOf(optionalInt.getAsInt());
                };
            } else if (OptionalLong.class == readerType) {
                type = Long.class;
                reader = i -> {
                    OptionalLong optionalLong = (OptionalLong)OptionalLong.class.cast(finalReader.read(i));
                    return optionalLong == null || !optionalLong.isPresent() ? null : Long.valueOf(optionalLong.getAsLong());
                };
            } else if (OptionalDouble.class == readerType) {
                type = Double.class;
                reader = i -> {
                    OptionalDouble optionalDouble = (OptionalDouble)OptionalDouble.class.cast(finalReader.read(i));
                    return optionalDouble == null || !optionalDouble.isPresent() ? null : Double.valueOf(optionalDouble.getAsDouble());
                };
            } else if (this.isOptionalArray((AccessMode.DecoratedType)finalReader)) {
                Type optionalUnwrappedType = this.findOptionalType(((GenericArrayType)GenericArrayType.class.cast(readerType)).getGenericComponentType());
                type = new GenericArrayTypeImpl(optionalUnwrappedType);
                reader = i -> {
                    Object[] optionals = (Object[])Object[].class.cast(finalReader.read(i));
                    return optionals == null ? null : Stream.of(optionals).map(Optional.class::cast).map(o -> o.orElse(null)).toArray();
                };
            } else {
                type = readerType;
                reader = arg_0 -> ((AccessMode.Reader)finalReader).read(arg_0);
            }
            final WriterConverters writerConverters = new WriterConverters((AccessMode.DecoratedType)initialReader, this.types);
            JsonbProperty property = (JsonbProperty)initialReader.getAnnotation(JsonbProperty.class);
            String key = property == null || property.value().isEmpty() ? this.naming.translateName((String)entry.getKey()) : property.value();
            if (result.put(key, new AccessMode.Reader((Type)type, finalReader, isNillable = this.isNillable(property, nillable = (JsonbNillable)initialReader.getClassOrPackageAnnotation(JsonbNillable.class))){
                final /* synthetic */ Type val$type;
                final /* synthetic */ AccessMode.Reader val$finalReader;
                final /* synthetic */ boolean val$isNillable;
                {
                    this.val$type = type;
                    this.val$finalReader = reader2;
                    this.val$isNillable = bl;
                }

                public Object read(Object instance) {
                    return reader.apply(instance);
                }

                public ObjectConverter.Writer<?> findObjectConverterWriter() {
                    return writerConverters.writer;
                }

                public Type getType() {
                    return this.val$type;
                }

                public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                    return (T)this.val$finalReader.getAnnotation(clazz);
                }

                public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
                    return (T)this.val$finalReader.getClassOrPackageAnnotation(clazz);
                }

                public Adapter<?, ?> findConverter() {
                    return writerConverters.converter;
                }

                public boolean isNillable(boolean global) {
                    return this.val$isNillable;
                }
            }) == null) continue;
            throw new JsonbException("Ambiguous field " + key);
        }
        return result;
    }

    private void validateAnnotationsOnTransientField(AccessMode.DecoratedType type) {
        if (type.getAnnotation(JsonbProperty.class) != null || type.getAnnotation(JsonbDateFormat.class) != null || type.getAnnotation(JsonbNumberFormat.class) != null || type.getAnnotation(JsonbTypeAdapter.class) != null || type.getAnnotation(JsonbTypeSerializer.class) != null || type.getAnnotation(JsonbTypeDeserializer.class) != null) {
            throw new JsonbException("Invalid configuration for " + type + " property");
        }
    }

    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        Map writers = this.delegate.findWriters(clazz);
        Comparator<String> keyComparator = this.fieldComparator(clazz);
        HashMap<String, AccessMode.Writer> result = keyComparator == null ? new HashMap() : new TreeMap(keyComparator);
        for (Map.Entry entry : writers.entrySet()) {
            JsonbNillable nillable;
            boolean isNillable;
            BiConsumer<Object, Object> writer;
            Object type;
            FieldAndMethodAccessMode.CompositeDecoratedType decoratedType;
            AccessMode.DecoratedType type2;
            AccessMode.Writer initialWriter = (AccessMode.Writer)entry.getValue();
            if (this.isTransient((AccessMode.DecoratedType)initialWriter, this.visibility)) {
                this.validateAnnotationsOnTransientField((AccessMode.DecoratedType)initialWriter);
                continue;
            }
            AccessMode.Writer finalWriter = FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(initialWriter) ? (MethodAccessMode.MethodWriter.class.isInstance(type2 = (decoratedType = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(initialWriter)).getType2()) ? (AccessMode.Writer)AccessMode.Writer.class.cast(type2) : initialWriter) : initialWriter;
            Type writerType = initialWriter.getType();
            if (this.isOptional(writerType)) {
                type = this.findOptionalType(writerType);
                writer = (i, val) -> finalWriter.write(i, Optional.ofNullable(val));
            } else if (OptionalInt.class == writerType) {
                type = Integer.class;
                writer = (i, value) -> finalWriter.write(i, (Object)(value == null ? OptionalInt.empty() : OptionalInt.of(((Number)Number.class.cast(value)).intValue())));
            } else if (OptionalLong.class == writerType) {
                type = Long.class;
                writer = (i, value) -> finalWriter.write(i, (Object)(value == null ? OptionalLong.empty() : OptionalLong.of(((Number)Number.class.cast(value)).longValue())));
            } else if (OptionalDouble.class == writerType) {
                type = Double.class;
                writer = (i, value) -> finalWriter.write(i, (Object)(value == null ? OptionalDouble.empty() : OptionalDouble.of(((Number)Number.class.cast(value)).doubleValue())));
            } else if (this.isOptionalArray((AccessMode.DecoratedType)initialWriter)) {
                Type optionalUnwrappedType = this.findOptionalType(((GenericArrayType)GenericArrayType.class.cast(writerType)).getGenericComponentType());
                type = new GenericArrayTypeImpl(optionalUnwrappedType);
                writer = (i, value) -> {
                    if (value != null) {
                        finalWriter.write(i, Stream.of((Object[])Object[].class.cast(value)).map(Optional::ofNullable).toArray(Optional[]::new));
                    }
                };
            } else {
                type = writerType;
                writer = (arg_0, arg_1) -> ((AccessMode.Writer)finalWriter).write(arg_0, arg_1);
            }
            final ReaderConverters converters = new ReaderConverters((AccessMode.DecoratedType)initialWriter);
            JsonbProperty property = (JsonbProperty)initialWriter.getAnnotation(JsonbProperty.class);
            String key = property == null || property.value().isEmpty() ? this.naming.translateName((String)entry.getKey()) : property.value();
            if (result.put(key, new AccessMode.Writer((Type)type, initialWriter, isNillable = this.isNillable(property, nillable = (JsonbNillable)initialWriter.getClassOrPackageAnnotation(JsonbNillable.class))){
                final /* synthetic */ Type val$type;
                final /* synthetic */ AccessMode.Writer val$initialWriter;
                final /* synthetic */ boolean val$isNillable;
                {
                    this.val$type = type;
                    this.val$initialWriter = writer2;
                    this.val$isNillable = bl;
                }

                public void write(Object instance, Object val) {
                    writer.accept(instance, val);
                }

                public ObjectConverter.Reader<?> findObjectConverterReader() {
                    return converters.reader;
                }

                public Type getType() {
                    return this.val$type;
                }

                public <T extends Annotation> T getAnnotation(Class<T> clazz) {
                    return (T)this.val$initialWriter.getAnnotation(clazz);
                }

                public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
                    return (T)this.val$initialWriter.getClassOrPackageAnnotation(clazz);
                }

                public Adapter<?, ?> findConverter() {
                    return converters.converter;
                }

                public boolean isNillable(boolean global) {
                    return this.val$isNillable;
                }
            }) == null) continue;
            throw new JsonbException("Ambiguous field " + key);
        }
        return result;
    }

    public ObjectConverter.Reader<?> findReader(Class<?> clazz) {
        return this.getClassEntry(clazz).readers.reader;
    }

    public ObjectConverter.Writer<?> findWriter(Class<?> clazz) {
        return this.getClassEntry(clazz).writers.writer;
    }

    public Adapter<?, ?> findAdapter(Class<?> clazz) {
        Adapter converter = this.getClassEntry(clazz).readers.converter;
        if (converter != null && this.isReversedAdapter(clazz, converter.getClass(), converter)) {
            return new ReversedAdapter(converter);
        }
        return converter;
    }

    public Method findAnyGetter(Class<?> clazz) {
        return this.partialDelegate.findAnyGetter(clazz);
    }

    public Method findAnySetter(Class<?> clazz) {
        return this.partialDelegate.findAnySetter(clazz);
    }

    public void afterParsed(Class<?> clazz) {
        this.parsingCache.remove(clazz);
        this.partialDelegate.afterParsed(clazz);
    }

    private boolean isReversedAdapter(Class<?> payloadType, Class<?> aClass, Adapter<?, ?> instance) {
        if (TypeAwareAdapter.class.isInstance(instance)) {
            return payloadType.isAssignableFrom((Class)Class.class.cast(((TypeAwareAdapter)TypeAwareAdapter.class.cast(instance)).getTo())) && !payloadType.isAssignableFrom((Class)Class.class.cast(((TypeAwareAdapter)TypeAwareAdapter.class.cast(instance)).getFrom()));
        }
        Type[] genericInterfaces = aClass.getGenericInterfaces();
        return Stream.of(genericInterfaces).filter(ParameterizedType.class::isInstance).filter(i -> Adapter.class.isAssignableFrom((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(i)).getRawType()))).findFirst().map(pt -> {
            Type argument = ((ParameterizedType)ParameterizedType.class.cast(pt)).getActualTypeArguments()[0];
            return Class.class.isInstance(argument) && payloadType.isAssignableFrom((Class)Class.class.cast(argument));
        }).orElseGet(() -> {
            Class superclass = aClass.getSuperclass();
            return superclass != Object.class && this.isReversedAdapter(payloadType, superclass, instance);
        });
    }

    private boolean isNillable(JsonbProperty property, JsonbNillable nillable) {
        if (property != null) {
            return property.nillable();
        }
        if (nillable != null) {
            return nillable.value();
        }
        return this.globalIsNillable;
    }

    private ParsingCacheEntry getClassEntry(Class<?> clazz) {
        ParsingCacheEntry cache = (ParsingCacheEntry)this.parsingCache.get(clazz);
        if (cache == null) {
            cache = new ParsingCacheEntry(new ClassDecoratedType(clazz), this.types);
            this.parsingCache.putIfAbsent(clazz, cache);
        }
        return cache;
    }

    private Type findOptionalType(Type writerType) {
        return ((ParameterizedType)ParameterizedType.class.cast(writerType)).getActualTypeArguments()[0];
    }

    private boolean isOptional(Type type) {
        return ParameterizedType.class.isInstance(type) && Optional.class == ((ParameterizedType)ParameterizedType.class.cast(type)).getRawType();
    }

    private boolean isOptionalArray(AccessMode.DecoratedType value) {
        return GenericArrayType.class.isInstance(value.getType()) && this.isOptional(((GenericArrayType)GenericArrayType.class.cast(value.getType())).getGenericComponentType());
    }

    private boolean isTransient(AccessMode.DecoratedType dt, PropertyVisibilityStrategy visibility) {
        if (!FieldAndMethodAccessMode.CompositeDecoratedType.class.isInstance(dt)) {
            return this.isTransient(dt) || this.shouldSkip(visibility, dt);
        }
        FieldAndMethodAccessMode.CompositeDecoratedType cdt = (FieldAndMethodAccessMode.CompositeDecoratedType)FieldAndMethodAccessMode.CompositeDecoratedType.class.cast(dt);
        return this.isTransient(cdt.getType1()) || this.isTransient(cdt.getType2()) || this.shouldSkip(visibility, cdt.getType1()) && this.shouldSkip(visibility, cdt.getType2());
    }

    private boolean shouldSkip(PropertyVisibilityStrategy visibility, AccessMode.DecoratedType t) {
        return this.isNotVisible(visibility, t);
    }

    private boolean isTransient(AccessMode.DecoratedType t) {
        if (t.getAnnotation(JsonbTransient.class) != null) {
            return true;
        }
        if (FieldAccessMode.FieldDecoratedType.class.isInstance(t)) {
            Field field = ((FieldAccessMode.FieldDecoratedType)FieldAccessMode.FieldDecoratedType.class.cast(t)).getField();
            return Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers());
        }
        return false;
    }

    private boolean isNotVisible(PropertyVisibilityStrategy visibility, AccessMode.DecoratedType t) {
        return !(!FieldAccessMode.FieldDecoratedType.class.isInstance(t) ? MethodAccessMode.MethodDecoratedType.class.isInstance(t) && visibility.isVisible(((MethodAccessMode.MethodDecoratedType)MethodAccessMode.MethodDecoratedType.class.cast(t)).getMethod()) : visibility.isVisible(((FieldAccessMode.FieldDecoratedType)FieldAccessMode.FieldDecoratedType.class.cast(t)).getField()));
    }

    private Comparator<String> orderComparator(Class<?> clazz) {
        PerHierarchyAndLexicographicalOrderFieldComparator keyComparator;
        JsonbPropertyOrder orderAnnotation = (JsonbPropertyOrder)Meta.getAnnotation(clazz, JsonbPropertyOrder.class);
        if (orderAnnotation != null) {
            ArrayList<String> indexed = new ArrayList<String>(Arrays.asList(orderAnnotation.value()));
            if (this.naming != null) {
                for (int i = 0; i < indexed.size(); ++i) {
                    indexed.set(i, this.naming.translateName((String)indexed.get(i)));
                }
            }
            keyComparator = (o1, o2) -> {
                if (o1 != null && o1.equals(o2)) {
                    return 0;
                }
                int i1 = indexed.indexOf(o1);
                int i2 = indexed.indexOf(o2);
                if (i1 < 0) {
                    if (i2 < 0 && this.order != null) {
                        switch (this.order) {
                            case "ANY": 
                            case "LEXICOGRAPHICAL": {
                                return o1.compareTo((String)o2);
                            }
                            case "REVERSE": {
                                return o2.compareTo((String)o1);
                            }
                        }
                        return 1;
                    }
                    return 1;
                }
                if (i2 < 0) {
                    return -1;
                }
                return i1 - i2;
            };
        } else if (this.order != null) {
            switch (this.order) {
                case "ANY": {
                    keyComparator = new PerHierarchyAndLexicographicalOrderFieldComparator(clazz);
                    break;
                }
                case "LEXICOGRAPHICAL": {
                    keyComparator = String::compareTo;
                    break;
                }
                case "REVERSE": {
                    keyComparator = Comparator.reverseOrder();
                    break;
                }
                default: {
                    keyComparator = null;
                    break;
                }
            }
        } else {
            keyComparator = null;
        }
        return keyComparator;
    }

    @Override
    public void close() throws IOException {
        this.toRelease.forEach(JohnzonAdapterFactory.Instance::release);
        if (Closeable.class.isInstance(this.delegate)) {
            ((Closeable)Closeable.class.cast(this.delegate)).close();
        }
        this.toRelease.clear();
    }

    private static <T extends Annotation> T getAnnotation(Parameter param, Class<T> api) {
        T annotation = param.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return (T)Meta.findMeta((Annotation[])param.getAnnotations(), api);
    }

    private boolean isDateType(Type type) {
        if (!Class.class.isInstance(type)) {
            return false;
        }
        Class clazz = (Class)Class.class.cast(type);
        return type.getTypeName().startsWith("java.time.") || Date.class == type || Calendar.class.isAssignableFrom(clazz);
    }

    private boolean isNumberType(Type type) {
        if (!Class.class.isInstance(type)) {
            return false;
        }
        Class clazz = (Class)Class.class.cast(type);
        return Number.class.isAssignableFrom(clazz) || clazz.isPrimitive();
    }

    private boolean hasRawType(Type type) {
        return Class.class.isInstance(type) || ParameterizedType.class.isInstance(type) && Class.class.isInstance(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
    }

    private Class<?> getRawType(Type type) {
        if (Class.class.isInstance(type)) {
            return (Class)Class.class.cast(type);
        }
        return (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(type)).getRawType());
    }

    private class ParsingCacheEntry {
        private final ReaderConverters readers;
        private final WriterConverters writers;

        ParsingCacheEntry(AccessMode.DecoratedType type, Types types) {
            this.readers = new ReaderConverters(type);
            this.writers = new WriterConverters(type, types);
        }
    }

    private static class ClassDecoratedType
    implements AccessMode.DecoratedType {
        private final Class<?> annotations;

        ClassDecoratedType(Class<?> clazz) {
            this.annotations = clazz;
        }

        public Type getType() {
            return this.annotations;
        }

        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return (T)Meta.getAnnotation(this.annotations, clazz);
        }

        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return (T)Meta.getAnnotation((Package)clazz.getPackage(), clazz);
        }

        public Adapter<?, ?> findConverter() {
            return null;
        }

        public boolean isNillable(boolean global) {
            return global;
        }
    }

    private class WriterConverters {
        private Adapter<?, ?> converter;
        private ObjectConverter.Writer writer;

        WriterConverters(AccessMode.DecoratedType reader, Types types) {
            boolean numberType = JsonbAccessMode.this.isNumberType(reader.getType());
            boolean dateType = JsonbAccessMode.this.isDateType(reader.getType());
            boolean hasRawType = JsonbAccessMode.this.hasRawType(reader.getType());
            JsonbTypeSerializer serializer = (JsonbTypeSerializer)reader.getAnnotation(JsonbTypeSerializer.class);
            JsonbTypeAdapter adapter = (JsonbTypeAdapter)reader.getAnnotation(JsonbTypeAdapter.class);
            JsonbTypeAdapter typeAdapter = hasRawType ? JsonbAccessMode.this.getRawType(reader.getType()).getDeclaredAnnotation(JsonbTypeAdapter.class) : null;
            JsonbDateFormat dateFormat = dateType ? (JsonbDateFormat)reader.getAnnotation(JsonbDateFormat.class) : null;
            JsonbNumberFormat numberFormat = numberType ? (JsonbNumberFormat)reader.getAnnotation(JsonbNumberFormat.class) : null;
            JohnzonConverter johnzonConverter = (JohnzonConverter)reader.getAnnotation(JohnzonConverter.class);
            JsonbAccessMode.this.validateAnnotations(reader, adapter != null ? adapter : typeAdapter, dateFormat, numberFormat, johnzonConverter);
            if (dateFormat == null && JsonbAccessMode.this.isDateType(reader.getType())) {
                dateFormat = (JsonbDateFormat)reader.getClassOrPackageAnnotation(JsonbDateFormat.class);
            }
            if (numberFormat == null && JsonbAccessMode.this.isNumberType(reader.getType())) {
                numberFormat = (JsonbNumberFormat)reader.getClassOrPackageAnnotation(JsonbNumberFormat.class);
            }
            Adapter adapter2 = adapter == null && typeAdapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null ? (Adapter)JsonbAccessMode.this.defaultConverters.get(new AdapterKey(reader.getType(), String.class)) : (this.converter = JsonbAccessMode.this.toConverter(types, reader.getType(), adapter != null ? adapter : typeAdapter, dateFormat, numberFormat));
            if (serializer != null) {
                Class value = serializer.value();
                JohnzonAdapterFactory.Instance instance = JsonbAccessMode.this.newInstance(value);
                JsonbAccessMode.this.toRelease.add(instance);
                Type[] arguments = types.findParameterizedType(value, JsonbSerializer.class).getActualTypeArguments();
                final boolean global = arguments.length == 1 && arguments[0] != null && arguments[0].equals(reader.getType());
                final JsonbSerializer jsonbSerializer = (JsonbSerializer)instance.getValue();
                this.writer = new ObjectConverter.Writer(){

                    public void writeJson(Object instance, MappingGenerator jsonbGenerator) {
                        JsonGenerator generator = jsonbGenerator.getJsonGenerator();
                        jsonbSerializer.serialize(instance, generator, (SerializationContext)new JohnzonSerializationContext(jsonbGenerator));
                    }

                    public boolean isGlobal() {
                        return global;
                    }
                };
            } else if (johnzonConverter != null) {
                try {
                    MapperConverter mapperConverter = (MapperConverter)johnzonConverter.value().newInstance();
                    if (mapperConverter instanceof Converter) {
                        this.converter = new ConverterAdapter((Converter)mapperConverter);
                    } else if (mapperConverter instanceof ObjectConverter.Writer) {
                        this.writer = (ObjectConverter.Writer)mapperConverter;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    private class ReaderConverters {
        private Adapter<?, ?> converter;
        private ObjectConverter.Reader reader;

        ReaderConverters(AccessMode.DecoratedType annotationHolder) {
            boolean numberType = JsonbAccessMode.this.isNumberType(annotationHolder.getType());
            boolean dateType = JsonbAccessMode.this.isDateType(annotationHolder.getType());
            boolean hasRawType = JsonbAccessMode.this.hasRawType(annotationHolder.getType());
            JsonbTypeDeserializer deserializer = (JsonbTypeDeserializer)annotationHolder.getAnnotation(JsonbTypeDeserializer.class);
            JsonbTypeAdapter adapter = (JsonbTypeAdapter)annotationHolder.getAnnotation(JsonbTypeAdapter.class);
            JsonbTypeAdapter typeAdapter = hasRawType ? JsonbAccessMode.this.getRawType(annotationHolder.getType()).getDeclaredAnnotation(JsonbTypeAdapter.class) : null;
            JsonbDateFormat dateFormat = dateType ? (JsonbDateFormat)annotationHolder.getAnnotation(JsonbDateFormat.class) : null;
            JsonbNumberFormat numberFormat = numberType ? (JsonbNumberFormat)annotationHolder.getAnnotation(JsonbNumberFormat.class) : null;
            JohnzonConverter johnzonConverter = (JohnzonConverter)annotationHolder.getAnnotation(JohnzonConverter.class);
            JsonbAccessMode.this.validateAnnotations(annotationHolder, adapter, dateFormat, numberFormat, johnzonConverter);
            if (dateFormat == null && dateType) {
                dateFormat = (JsonbDateFormat)annotationHolder.getClassOrPackageAnnotation(JsonbDateFormat.class);
            }
            if (numberFormat == null && numberType) {
                numberFormat = (JsonbNumberFormat)annotationHolder.getClassOrPackageAnnotation(JsonbNumberFormat.class);
            }
            Adapter adapter2 = adapter == null && typeAdapter == null && dateFormat == null && numberFormat == null && johnzonConverter == null ? (Adapter)JsonbAccessMode.this.defaultConverters.get(new AdapterKey(annotationHolder.getType(), String.class)) : (this.converter = JsonbAccessMode.this.toConverter(JsonbAccessMode.this.types, annotationHolder.getType(), adapter != null ? adapter : typeAdapter, dateFormat, numberFormat));
            if (deserializer != null) {
                Class value = deserializer.value();
                final JohnzonAdapterFactory.Instance instance = JsonbAccessMode.this.newInstance(value);
                ParameterizedType pt = JsonbAccessMode.this.types.findParameterizedType(value, JsonbDeserializer.class);
                final Class mappedType = JsonbAccessMode.this.types.findParamType(pt, JsonbDeserializer.class);
                JsonbAccessMode.this.toRelease.add(instance);
                final JsonBuilderFactory builderFactoryInstance = (JsonBuilderFactory)JsonbAccessMode.this.builderFactory.get();
                Type[] arguments = JsonbAccessMode.this.types.findParameterizedType(value, JsonbDeserializer.class).getActualTypeArguments();
                final boolean global = arguments.length == 1 && arguments[0] != null && arguments[0].equals(annotationHolder.getType());
                this.reader = new ObjectConverter.Reader(){
                    private final ConcurrentMap<Type, BiFunction<JsonValue, MappingParser, Object>> impl = new ConcurrentHashMap<Type, BiFunction<JsonValue, MappingParser, Object>>();

                    public boolean isGlobal() {
                        return global;
                    }

                    public Object fromJson(JsonValue value, Type targetType, MappingParser parser) {
                        JsonbDeserializer jsonbDeserializer = (JsonbDeserializer)instance.getValue();
                        if (global || targetType == mappedType) {
                            return this.mapItem(value, targetType, parser, jsonbDeserializer);
                        }
                        BiFunction<JsonValue, MappingParser, Object> fn = (BiFunction<JsonValue, MappingParser, Object>)this.impl.get(targetType);
                        if (fn == null) {
                            if (value.getValueType() == JsonValue.ValueType.ARRAY && ParameterizedType.class.isInstance(targetType)) {
                                ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(targetType);
                                Class paramType = JsonbAccessMode.this.types.findParamType(parameterizedType, Collection.class);
                                if (paramType != null && (mappedType == null || mappedType.isAssignableFrom(paramType))) {
                                    Collector collector = Set.class.isAssignableFrom(JsonbAccessMode.this.types.asClass(parameterizedType.getRawType())) ? Collectors.toSet() : Collectors.toList();
                                    fn = (json, mp) -> (Collection)json.asJsonArray().stream().map(i -> this.mapItem((JsonValue)i, paramType, (MappingParser)mp, jsonbDeserializer)).collect(collector);
                                }
                            }
                            if (fn == null) {
                                fn = (json, mp) -> this.mapItem((JsonValue)json, targetType, (MappingParser)mp, jsonbDeserializer);
                            }
                            this.impl.putIfAbsent(targetType, fn);
                        }
                        return fn.apply(value, parser);
                    }

                    private Object mapItem(JsonValue jsonValue, Type targetType, MappingParser parser, JsonbDeserializer jsonbDeserializer) {
                        return jsonbDeserializer.deserialize(JsonValueParserAdapter.createFor(jsonValue, JsonbAccessMode.this.parserFactory), (DeserializationContext)new JohnzonDeserializationContext(parser, builderFactoryInstance, JsonbAccessMode.this.jsonProvider), targetType);
                    }
                };
            } else if (johnzonConverter != null) {
                try {
                    MapperConverter mapperConverter = (MapperConverter)johnzonConverter.value().newInstance();
                    if (mapperConverter instanceof Converter) {
                        this.converter = new ConverterAdapter((Converter)mapperConverter);
                    } else if (mapperConverter instanceof ObjectConverter.Reader) {
                        this.reader = (ObjectConverter.Reader)mapperConverter;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }
}

