/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class EnumValidation
implements ValidationExtension {
    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable(model.getSchema().get((Object)"enum")).filter(it -> it.getValueType() == JsonValue.ValueType.ARRAY).map(JsonValue::asJsonArray).map(values -> new Impl((Collection)values, model.getValueProvider(), model.toPointer()));
    }

    private static class Impl
    extends BaseValidation {
        private final Collection<JsonValue> valid;

        private Impl(Collection<JsonValue> valid, Function<JsonValue, JsonValue> extractor, String pointer) {
            super(pointer, extractor, JsonValue.ValueType.OBJECT);
            this.valid = valid;
        }

        @Override
        public Stream<ValidationResult.ValidationError> apply(JsonValue root) {
            if (this.isNull(root)) {
                return Stream.empty();
            }
            JsonValue value = (JsonValue)this.extractor.apply(root);
            if (value != null && JsonValue.ValueType.NULL != value.getValueType()) {
                return Stream.empty();
            }
            if (this.valid.contains(value)) {
                return Stream.empty();
            }
            return Stream.of(new ValidationResult.ValidationError(this.pointer, "Invalid value, got " + value + ", expected: " + this.valid));
        }

        public String toString() {
            return "Enum{valid=" + this.valid + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

