/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.JohnzonVirtualObject;
import org.apache.johnzon.mapper.JohnzonVirtualObjects;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.converter.DateWithCopyConverter;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class Mappings {
    private static final JohnzonParameterizedType VIRTUAL_TYPE = new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class});
    protected final ConcurrentMap<Type, ClassMapping> classes = new ConcurrentHashMap<Type, ClassMapping>();
    protected final ConcurrentMap<Type, CollectionMapping> collections = new ConcurrentHashMap<Type, CollectionMapping>();
    protected final Comparator<String> fieldOrdering;
    protected final Map<Class<?>, Converter<?>> converters;
    private final boolean supportHiddenConstructors;
    private final boolean supportConstructors;
    private final AccessMode accessMode;
    private final int version;

    public Mappings(Comparator<String> attributeOrder, AccessMode accessMode, boolean supportHiddenConstructors, boolean supportConstructors, int version, Map<Class<?>, Converter<?>> converters) {
        this.fieldOrdering = attributeOrder;
        this.accessMode = accessMode;
        this.supportHiddenConstructors = supportHiddenConstructors;
        this.supportConstructors = supportConstructors;
        this.version = version;
        this.converters = converters;
    }

    public <T> CollectionMapping findCollectionMapping(ParameterizedType genericType) {
        CollectionMapping collectionMapping = (CollectionMapping)this.collections.get(genericType);
        if (collectionMapping == null) {
            collectionMapping = this.createCollectionMapping(genericType);
            if (collectionMapping == null) {
                return null;
            }
            CollectionMapping existing = this.collections.putIfAbsent(genericType, collectionMapping);
            if (existing != null) {
                collectionMapping = existing;
            }
        }
        return collectionMapping;
    }

    private <T> CollectionMapping createCollectionMapping(ParameterizedType aType) {
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        Type raw = aType.getRawType();
        if (fieldArgTypes.length == 1 && Class.class.isInstance(raw)) {
            Class collectionType;
            Class r = (Class)Class.class.cast(raw);
            if (List.class.isAssignableFrom(r)) {
                collectionType = List.class;
            } else if (SortedSet.class.isAssignableFrom(r)) {
                collectionType = SortedSet.class;
            } else if (Set.class.isAssignableFrom(r)) {
                collectionType = Set.class;
            } else if (Queue.class.isAssignableFrom(r)) {
                collectionType = Queue.class;
            } else if (Collection.class.isAssignableFrom(r)) {
                collectionType = Collection.class;
            } else {
                return null;
            }
            CollectionMapping mapping = new CollectionMapping(Mappings.isPrimitive(fieldArgTypes[0]), collectionType, fieldArgTypes[0]);
            this.collections.putIfAbsent(aType, mapping);
            return mapping;
        }
        return null;
    }

    public static boolean isPrimitive(Type type) {
        if (type == String.class) {
            return true;
        }
        if (type == Character.TYPE || type == Character.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    public ClassMapping getClassMapping(Type clazz) {
        return (ClassMapping)this.classes.get(clazz);
    }

    public ClassMapping findOrCreateClassMapping(Type clazz) {
        ClassMapping classMapping = (ClassMapping)this.classes.get(clazz);
        if (classMapping == null) {
            if (!Class.class.isInstance(clazz) || Map.class.isAssignableFrom((Class)Class.class.cast(clazz))) {
                return null;
            }
            classMapping = this.createClassMapping((Class)Class.class.cast(clazz));
            ClassMapping existing = this.classes.putIfAbsent(clazz, classMapping);
            if (existing != null) {
                classMapping = existing;
            }
        }
        return classMapping;
    }

    private ClassMapping createClassMapping(Class<?> inClazz) {
        JohnzonVirtualObject johnzonVirtualObject;
        boolean copyDate = false;
        for (Class<?> itf : inClazz.getInterfaces()) {
            if (!"org.apache.openjpa.enhance.PersistenceCapable".equals(itf.getName())) continue;
            copyDate = true;
            break;
        }
        Class<?> clazz = this.findModelClass(inClazz);
        Map<String, Getter> getters = this.newOrderedMap();
        Map<String, Setter> setters = this.newOrderedMap();
        Map<String, AccessMode.Reader> readers = this.accessMode.findReaders(clazz);
        Map<String, AccessMode.Writer> writers = this.accessMode.findWriters(clazz);
        HashSet<String> virtualFields = new HashSet<String>();
        JohnzonVirtualObjects virtualObjects = clazz.getAnnotation(JohnzonVirtualObjects.class);
        if (virtualObjects != null) {
            for (JohnzonVirtualObject virtualObject2 : virtualObjects.value()) {
                this.handleVirtualObject(virtualFields, virtualObject2, getters, setters, readers, writers, copyDate);
            }
        }
        if ((johnzonVirtualObject = clazz.getAnnotation(JohnzonVirtualObject.class)) != null) {
            this.handleVirtualObject(virtualFields, johnzonVirtualObject, getters, setters, readers, writers, copyDate);
        }
        for (Map.Entry<String, AccessMode.Reader> entry : readers.entrySet()) {
            String key = entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addGetterIfNeeded(getters, key, entry.getValue(), copyDate);
        }
        for (Map.Entry<String, AccessMode.DecoratedType> entry : writers.entrySet()) {
            String key = entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addSetterIfNeeded(setters, key, (AccessMode.Writer)entry.getValue(), copyDate);
        }
        return new ClassMapping(clazz, getters, setters, this.supportHiddenConstructors, this.supportConstructors);
    }

    protected Class<?> findModelClass(Class<?> inClazz) {
        Class<?> clazz;
        for (clazz = inClazz; clazz != null && clazz != Object.class && (clazz.getName().contains("$$") || clazz.getName().contains("$proxy") || clazz.getName().startsWith("org.apache.openjpa.enhance.")); clazz = clazz.getSuperclass()) {
        }
        if (clazz == null || clazz == Object.class) {
            clazz = inClazz;
        }
        return clazz;
    }

    private <T> Map<String, T> newOrderedMap() {
        return this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
    }

    private void addSetterIfNeeded(Map<String, Setter> setters, String key, AccessMode.Writer value, boolean copyDate) {
        JohnzonIgnore writeIgnore = value.getAnnotation(JohnzonIgnore.class);
        if (writeIgnore == null || writeIgnore.minVersion() >= 0) {
            if (key.equals("metaClass")) {
                return;
            }
            Type param = value.getType();
            Class returnType = Class.class.isInstance(param) ? (Class)Class.class.cast(param) : null;
            Setter setter = new Setter(value, Mappings.isPrimitive(param), returnType != null && returnType.isArray(), param, this.findConverter(copyDate, value), writeIgnore != null ? writeIgnore.minVersion() : -1);
            setters.put(key, setter);
        }
    }

    private void addGetterIfNeeded(Map<String, Getter> getters, String key, AccessMode.Reader value, boolean copyDate) {
        JohnzonIgnore readIgnore = value.getAnnotation(JohnzonIgnore.class);
        if (readIgnore == null || readIgnore.minVersion() >= 0) {
            Class returnType = Class.class.isInstance(value.getType()) ? (Class)Class.class.cast(value.getType()) : null;
            ParameterizedType pt = ParameterizedType.class.isInstance(value.getType()) ? (ParameterizedType)ParameterizedType.class.cast(value.getType()) : null;
            Getter getter = new Getter(value, Mappings.isPrimitive(returnType), returnType != null && returnType.isArray(), pt != null && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Collection.class.isAssignableFrom(returnType), pt != null && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Map.class.isAssignableFrom(returnType), this.findConverter(copyDate, value), readIgnore != null ? readIgnore.minVersion() : -1);
            getters.put(key, getter);
        }
    }

    private void handleVirtualObject(Collection<String> virtualFields, JohnzonVirtualObject o, Map<String, Getter> getters, Map<String, Setter> setters, Map<String, AccessMode.Reader> readers, Map<String, AccessMode.Writer> writers, boolean copyDate) {
        String[] path = o.path();
        if (path.length < 1) {
            throw new IllegalArgumentException("@JohnzonVirtualObject need a path");
        }
        for (JohnzonVirtualObject.Field f : o.fields()) {
            virtualFields.add(f.value());
        }
        Map<String, Getter> objectGetters = this.newOrderedMap();
        Map<String, Setter> objectSetters = this.newOrderedMap();
        for (JohnzonVirtualObject.Field f : o.fields()) {
            AccessMode.Writer writer;
            AccessMode.Reader reader;
            String name = f.value();
            if (f.read() && (reader = readers.get(name)) != null) {
                this.addGetterIfNeeded(objectGetters, name, reader, copyDate);
            }
            if (!f.write() || (writer = writers.get(name)) == null) continue;
            this.addSetterIfNeeded(objectSetters, name, writer, copyDate);
        }
        String key = path[0];
        Getter getter = getters.get(key);
        MapBuilderReader newReader = new MapBuilderReader(objectGetters, path, this.version);
        getters.put(key, new Getter(getter == null ? newReader : new CompositeReader(getter.reader, newReader), false, false, false, true, null, -1));
        Setter newSetter = setters.get(key);
        MapUnwrapperWriter newWriter = new MapUnwrapperWriter(objectSetters, path);
        setters.put(key, new Setter(newSetter == null ? newWriter : new CompositeWriter(newSetter.writer, newWriter), false, false, VIRTUAL_TYPE, null, -1));
    }

    private Converter findConverter(boolean copyDate, AccessMode.DecoratedType method) {
        DateWithCopyConverter converter = null;
        JohnzonConverter annotation = method.getAnnotation(JohnzonConverter.class);
        if (annotation != null) {
            try {
                converter = annotation.value().newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (Class.class.isInstance(method.getType()) && Date.class.isAssignableFrom((Class)Class.class.cast(method.getType())) && copyDate) {
            converter = new DateWithCopyConverter((Converter)Converter.class.cast(this.converters.get(Date.class)));
        }
        return converter;
    }

    private static class CompositeWriter
    implements AccessMode.Writer {
        private final AccessMode.Writer[] delegates;

        public CompositeWriter(AccessMode.Writer ... writers) {
            LinkedList<AccessMode.Writer> all = new LinkedList<AccessMode.Writer>();
            for (AccessMode.Writer r : writers) {
                if (CompositeWriter.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeWriter)CompositeWriter.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Writer[all.size()]);
        }

        @Override
        public void write(Object instance, Object value) {
            for (AccessMode.Writer w : this.delegates) {
                w.write(instance, value);
            }
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }
    }

    private static class CompositeReader
    implements AccessMode.Reader {
        private final AccessMode.Reader[] delegates;

        public CompositeReader(AccessMode.Reader ... delegates) {
            LinkedList<AccessMode.Reader> all = new LinkedList<AccessMode.Reader>();
            for (AccessMode.Reader r : delegates) {
                if (CompositeReader.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeReader)CompositeReader.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Reader[all.size()]);
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap map = new LinkedHashMap();
            for (AccessMode.Reader reader : this.delegates) {
                Map readerMap = (Map)reader.read(instance);
                for (Map.Entry entry : readerMap.entrySet()) {
                    Object o = map.get(entry.getKey());
                    if (o == null) {
                        map.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (Map.class.isInstance(o)) continue;
                    throw new IllegalStateException((String)entry.getKey() + " is ambiguous");
                }
            }
            return map;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }
    }

    private static class MapUnwrapperWriter
    implements AccessMode.Writer {
        private final Map<String, Setter> writers;
        private final Map<String, Class<?>> componentTypes;
        private final String[] paths;

        public MapUnwrapperWriter(Map<String, Setter> writers, String[] paths) {
            this.writers = writers;
            this.paths = paths;
            this.componentTypes = new HashMap();
            for (Map.Entry<String, Setter> setter : writers.entrySet()) {
                if (!setter.getValue().array) continue;
                this.componentTypes.put(setter.getKey(), ((Class)Class.class.cast(setter.getValue().paramType)).getComponentType());
            }
        }

        @Override
        public void write(Object instance, Object value) {
            Map nested = null;
            for (String path : this.paths) {
                if ((nested = (Map)Map.class.cast(nested == null ? value : nested.get(path))) != null) continue;
                return;
            }
            for (Map.Entry entry : this.writers.entrySet()) {
                Setter setterValue = (Setter)entry.getValue();
                String key = (String)entry.getKey();
                Object rawValue = nested.get(key);
                Object val = value == null || setterValue.converter == null ? rawValue : ((Converter)Converter.class.cast(setterValue.converter)).toString(rawValue);
                if (val == null) continue;
                if (setterValue.array && Collection.class.isInstance(val)) {
                    Collection collection = (Collection)Collection.class.cast(val);
                    Object[] array = (Object[])Array.newInstance(this.componentTypes.get(key), collection.size());
                    val = collection.toArray(array);
                }
                AccessMode.Writer setterMethod = setterValue.writer;
                setterMethod.write(instance, val);
            }
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }
    }

    private static class MapBuilderReader
    implements AccessMode.Reader {
        private final Map<String, Getter> getters;
        private final Map<String, Object> template;
        private final String[] paths;
        private final int version;

        public MapBuilderReader(Map<String, Getter> objectGetters, String[] paths, int version) {
            this.getters = objectGetters;
            this.paths = paths;
            this.template = new LinkedHashMap<String, Object>();
            this.version = version;
            Map<String, Object> last = this.template;
            for (int i = 1; i < paths.length; ++i) {
                LinkedHashMap<String, Object> newLast = new LinkedHashMap<String, Object>();
                last.put(paths[i], newLast);
                last = newLast;
            }
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.template);
            Map<String, Object> nested = map;
            for (int i = 1; i < this.paths.length; ++i) {
                nested = (Map)Map.class.cast(nested.get(this.paths[i]));
            }
            for (Map.Entry<String, Getter> g : this.getters.entrySet()) {
                Getter getter = g.getValue();
                Object value = getter.reader.read(instance);
                Object val = value == null || getter.converter == null ? value : getter.converter.toString(value);
                if (val == null || getter.version >= 0 && this.version >= getter.version) continue;
                nested.put(g.getKey(), val);
            }
            return map;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }
    }

    public static class Setter {
        public final AccessMode.Writer writer;
        public final int version;
        public final Type paramType;
        public final Converter<?> converter;
        public final boolean primitive;
        public final boolean array;

        public Setter(AccessMode.Writer writer, boolean primitive, boolean array, Type paramType, Converter<?> converter, int version) {
            this.writer = writer;
            this.paramType = paramType;
            this.converter = converter;
            this.version = version;
            this.primitive = primitive;
            this.array = array;
        }
    }

    public static class Getter {
        public final AccessMode.Reader reader;
        public final int version;
        public final Converter<Object> converter;
        public final boolean primitive;
        public final boolean array;
        public final boolean map;
        public final boolean collection;

        public Getter(AccessMode.Reader reader, boolean primitive, boolean array, boolean collection, boolean map, Converter<Object> converter, int version) {
            this.reader = reader;
            this.converter = converter;
            this.version = version;
            this.array = array;
            this.map = map && converter == null;
            this.collection = collection;
            this.primitive = primitive;
        }
    }

    public static class CollectionMapping {
        public final Class<?> raw;
        public final Type arg;
        public final boolean primitive;

        public CollectionMapping(boolean primitive, Class<?> collectionType, Type fieldArgType) {
            this.raw = collectionType;
            this.arg = fieldArgType;
            this.primitive = primitive;
        }
    }

    public static class ClassMapping {
        public final Class<?> clazz;
        public final Map<String, Getter> getters;
        public final Map<String, Setter> setters;
        public final Constructor<?> constructor;
        public final boolean constructorHasArguments;
        public final String[] constructorParameters;
        public final Converter<?>[] constructorParameterConverters;
        public final Type[] constructorParameterTypes;

        protected ClassMapping(Class<?> clazz, Map<String, Getter> getters, Map<String, Setter> setters, boolean acceptHiddenConstructor, boolean useConstructor) {
            this.clazz = clazz;
            this.getters = getters;
            this.setters = setters;
            this.constructor = this.findConstructor(acceptHiddenConstructor, useConstructor);
            boolean bl = this.constructorHasArguments = this.constructor != null && this.constructor.getGenericParameterTypes().length > 0;
            if (this.constructorHasArguments) {
                this.constructorParameterTypes = this.constructor.getGenericParameterTypes();
                this.constructorParameters = new String[this.constructor.getGenericParameterTypes().length];
                ConstructorProperties constructorProperties = this.constructor.getAnnotation(ConstructorProperties.class);
                System.arraycopy(constructorProperties.value(), 0, this.constructorParameters, 0, this.constructorParameters.length);
                this.constructorParameterConverters = new Converter[this.constructor.getGenericParameterTypes().length];
                for (int i = 0; i < this.constructorParameters.length; ++i) {
                    for (Annotation a : this.constructor.getParameterAnnotations()[i]) {
                        if (a.annotationType() != JohnzonConverter.class) continue;
                        try {
                            this.constructorParameterConverters[i] = ((JohnzonConverter)JohnzonConverter.class.cast(a)).value().newInstance();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                }
            } else {
                this.constructorParameterTypes = null;
                this.constructorParameters = null;
                this.constructorParameterConverters = null;
            }
        }

        private Constructor<?> findConstructor(boolean acceptHiddenConstructor, boolean useConstructor) {
            Constructor<?> found = null;
            for (Constructor<?> c : this.clazz.getDeclaredConstructors()) {
                if (c.getParameterTypes().length == 0) {
                    if (!Modifier.isPublic(c.getModifiers()) && acceptHiddenConstructor) {
                        c.setAccessible(true);
                    }
                    found = c;
                    if (useConstructor) continue;
                    break;
                }
                if (c.getAnnotation(ConstructorProperties.class) == null) continue;
                found = c;
                break;
            }
            if (found != null) {
                return found;
            }
            try {
                return this.clazz.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
    }
}

