/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.access.AccessMode;

public abstract class BaseAccessMode
implements AccessMode {
    private final Map<Class<?>, String[]> fieldsToRemove = new HashMap();

    public BaseAccessMode() {
        this.fieldsToRemove.put(Throwable.class, new String[]{"suppressedExceptions", "cause"});
    }

    protected abstract Map<String, AccessMode.Reader> doFindReaders(Class<?> var1);

    protected abstract Map<String, AccessMode.Writer> doFindWriters(Class<?> var1);

    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindReaders(clazz));
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindWriters(clazz));
    }

    public Map<Class<?>, String[]> getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    private <T> Map<String, T> sanitize(Class<?> type, Map<String, T> delegate) {
        for (Map.Entry<Class<?>, String[]> entry : this.fieldsToRemove.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            for (String field : entry.getValue()) {
                delegate.remove(field);
            }
            return delegate;
        }
        return delegate;
    }
}

