/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;

public class MethodAccessMode
extends BaseAccessMode {
    private final boolean supportGetterAsWritter;

    public MethodAccessMode(boolean supportGetterAsWritter) {
        this.supportGetterAsWritter = supportGetterAsWritter;
    }

    @Override
    public Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            Method readMethod = descriptor.getReadMethod();
            if (readMethod == null || readMethod.getDeclaringClass() == Object.class || this.isIgnored(descriptor.getName())) continue;
            readers.put(this.extractKey(descriptor), new MethodReader(readMethod));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (PropertyDescriptor descriptor : propertyDescriptors = this.getPropertyDescriptors(clazz)) {
            if (descriptor.getPropertyType() == Class.class || this.isIgnored(descriptor.getName())) continue;
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod != null) {
                writers.put(this.extractKey(descriptor), new MethodWriter(writeMethod));
                continue;
            }
            if (!this.supportGetterAsWritter || !Collection.class.isAssignableFrom(descriptor.getPropertyType()) || descriptor.getReadMethod() == null) continue;
            writers.put(this.extractKey(descriptor), new MethodGetterAsWriter(descriptor.getReadMethod()));
        }
        return writers;
    }

    private String extractKey(PropertyDescriptor f) {
        JohnzonProperty property = f.getReadMethod() == null ? null : f.getReadMethod().getAnnotation(JohnzonProperty.class);
        return property != null ? property.value() : f.getName();
    }

    protected boolean isIgnored(String name) {
        return name.equals("metaClass") || name.contains("$");
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        PropertyDescriptor[] propertyDescriptors;
        try {
            propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException(e);
        }
        return propertyDescriptors;
    }

    private class MethodGetterAsWriter
    extends MethodReader
    implements AccessMode.Writer {
        public MethodGetterAsWriter(Method readMethod) {
            super(readMethod);
        }

        @Override
        public void write(Object instance, Object value) {
            if (value != null) {
                try {
                    Collection collection = (Collection)Collection.class.cast(this.method.invoke(instance, new Object[0]));
                    if (collection != null) {
                        collection.addAll((Collection)Collection.class.cast(value));
                    }
                }
                catch (Exception e) {
                    throw new MapperException(e);
                }
            }
        }
    }

    public static class MethodReader
    extends MethodDecoratedType
    implements AccessMode.Reader {
        public MethodReader(Method method) {
            super(method);
        }

        @Override
        public Type getType() {
            return this.method.getGenericReturnType();
        }

        @Override
        public Object read(Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    public static class MethodWriter
    extends MethodDecoratedType
    implements AccessMode.Writer {
        public MethodWriter(Method method) {
            super(method);
        }

        @Override
        public Type getType() {
            return this.method.getGenericParameterTypes()[0];
        }

        @Override
        public void write(Object instance, Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }
    }

    protected static abstract class MethodDecoratedType
    implements AccessMode.DecoratedType {
        protected final Method method;

        public MethodDecoratedType(Method method) {
            this.method = method;
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return this.method.getAnnotation(clazz);
        }
    }
}

