/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonReaderFactory;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.apache.johnzon.mapper.access.MethodAccessMode;
import org.apache.johnzon.mapper.converter.BigDecimalConverter;
import org.apache.johnzon.mapper.converter.BigIntegerConverter;
import org.apache.johnzon.mapper.converter.BooleanConverter;
import org.apache.johnzon.mapper.converter.ByteConverter;
import org.apache.johnzon.mapper.converter.CachedDelegateConverter;
import org.apache.johnzon.mapper.converter.CharacterConverter;
import org.apache.johnzon.mapper.converter.ClassConverter;
import org.apache.johnzon.mapper.converter.DateConverter;
import org.apache.johnzon.mapper.converter.DoubleConverter;
import org.apache.johnzon.mapper.converter.FloatConverter;
import org.apache.johnzon.mapper.converter.IntegerConverter;
import org.apache.johnzon.mapper.converter.LongConverter;
import org.apache.johnzon.mapper.converter.ShortConverter;
import org.apache.johnzon.mapper.converter.StringConverter;

public class MapperBuilder {
    private static final Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS = new HashMap();
    private JsonReaderFactory readerFactory;
    private JsonGeneratorFactory generatorFactory;
    private boolean doCloseOnStreams = false;
    private boolean supportHiddenAccess = true;
    private int version = -1;
    private int maxSize = -1;
    private int bufferSize = -1;
    private String bufferStrategy;
    private Comparator<String> attributeOrder = null;
    private boolean skipNull = true;
    private boolean skipEmptyArray = false;
    private boolean supportsComments = false;
    protected boolean pretty;
    private AccessMode accessMode = new MethodAccessMode(false);
    private boolean treatByteArrayAsBase64;
    private final Map<Type, Converter<?>> converters = new HashMap(DEFAULT_CONVERTERS);
    private boolean supportConstructors;
    private Charset encoding = Charset.forName(System.getProperty("johnzon.mapper.encoding", "UTF-8"));

    public Mapper build() {
        if (this.readerFactory == null || this.generatorFactory == null) {
            JsonProvider provider = JsonProvider.provider();
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (this.bufferStrategy != null) {
                config.put("org.apache.johnzon.buffer-strategy", this.bufferStrategy);
            }
            if (this.pretty) {
                config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            }
            if (this.generatorFactory == null) {
                this.generatorFactory = provider.createGeneratorFactory(config);
            }
            config.remove("javax.json.stream.JsonGenerator.prettyPrinting");
            if (this.supportsComments) {
                config.put("org.apache.johnzon.supports-comments", "true");
            }
            if (this.maxSize > 0) {
                config.put("org.apache.johnzon.max-string-length", this.maxSize);
            }
            if (this.bufferSize > 0) {
                config.put("org.apache.johnzon.default-char-buffer", this.bufferSize);
            }
            if (this.readerFactory == null) {
                this.readerFactory = provider.createReaderFactory(config);
            }
        }
        return new Mapper(this.readerFactory, this.generatorFactory, this.doCloseOnStreams, this.converters, this.version, this.attributeOrder, this.skipNull, this.skipEmptyArray, this.accessMode, this.supportHiddenAccess, this.supportConstructors, this.treatByteArrayAsBase64, this.encoding);
    }

    public MapperBuilder setIgnoreFieldsForType(Class<?> type, String ... fields) {
        if (BaseAccessMode.class.isInstance(this.accessMode)) {
            if (fields == null || fields.length == 0) {
                ((BaseAccessMode)BaseAccessMode.class.cast(this.accessMode)).getFieldsToRemove().remove(type);
            } else {
                ((BaseAccessMode)BaseAccessMode.class.cast(this.accessMode)).getFieldsToRemove().put(type, fields);
            }
        } else {
            throw new IllegalStateException("AccessMode is not an BaseAccessMode");
        }
        return this;
    }

    public MapperBuilder setSupportGetterForCollections(boolean useGetterForCollections) {
        this.accessMode = new MethodAccessMode(useGetterForCollections);
        return this;
    }

    public MapperBuilder setSupportsComments(boolean supportsComments) {
        this.supportsComments = supportsComments;
        return this;
    }

    public MapperBuilder setPretty(boolean pretty) {
        this.pretty = pretty;
        return this;
    }

    public MapperBuilder setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public MapperBuilder setBufferStrategy(String bufferStrategy) {
        this.bufferStrategy = bufferStrategy;
        return this;
    }

    public MapperBuilder setMaxSize(int size) {
        this.maxSize = size;
        return this;
    }

    public MapperBuilder setAccessMode(AccessMode mode) {
        this.accessMode = mode;
        return this;
    }

    public MapperBuilder setAccessModeName(String mode) {
        if ("field".equalsIgnoreCase(mode)) {
            this.accessMode = new FieldAccessMode();
        } else if ("method".equalsIgnoreCase(mode)) {
            this.accessMode = new MethodAccessMode(true);
        } else if ("strict-method".equalsIgnoreCase(mode)) {
            this.accessMode = new MethodAccessMode(false);
        } else if ("both".equalsIgnoreCase(mode)) {
            this.accessMode = new FieldAndMethodAccessMode();
        } else {
            throw new IllegalArgumentException("Mode " + mode + " unsupported");
        }
        return this;
    }

    public MapperBuilder setSupportHiddenAccess(boolean supportHiddenAccess) {
        this.supportHiddenAccess = supportHiddenAccess;
        return this;
    }

    public MapperBuilder setAttributeOrder(Comparator<String> attributeOrder) {
        this.attributeOrder = attributeOrder;
        return this;
    }

    public MapperBuilder setReaderFactory(JsonReaderFactory readerFactory) {
        this.readerFactory = readerFactory;
        return this;
    }

    public MapperBuilder setGeneratorFactory(JsonGeneratorFactory generatorFactory) {
        this.generatorFactory = generatorFactory;
        return this;
    }

    public MapperBuilder setDoCloseOnStreams(boolean doCloseOnStreams) {
        this.doCloseOnStreams = doCloseOnStreams;
        return this;
    }

    @Deprecated
    public MapperBuilder addPropertyEditor(Class<?> clazz, Converter<?> converter) {
        this.converters.put(clazz, converter);
        return this;
    }

    public MapperBuilder addConverter(Type clazz, Converter<?> converter) {
        this.converters.put(clazz, converter);
        return this;
    }

    public MapperBuilder setVersion(int version) {
        this.version = version;
        return this;
    }

    public MapperBuilder setSkipNull(boolean skipNull) {
        this.skipNull = skipNull;
        return this;
    }

    public MapperBuilder setSkipEmptyArray(boolean skipEmptyArray) {
        this.skipEmptyArray = skipEmptyArray;
        return this;
    }

    public MapperBuilder setTreatByteArrayAsBase64(boolean treatByteArrayAsBase64) {
        this.treatByteArrayAsBase64 = treatByteArrayAsBase64;
        return this;
    }

    public MapperBuilder setSupportConstructors(boolean supportConstructors) {
        this.supportConstructors = supportConstructors;
        return this;
    }

    public MapperBuilder setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
        return this;
    }

    static {
        DEFAULT_CONVERTERS.put(Date.class, new DateConverter("yyyyMMddHHmmssZ"));
        DEFAULT_CONVERTERS.put(Class.class, new ClassConverter());
        DEFAULT_CONVERTERS.put(String.class, new StringConverter());
        DEFAULT_CONVERTERS.put(BigDecimal.class, new BigDecimalConverter());
        DEFAULT_CONVERTERS.put(BigInteger.class, new BigIntegerConverter());
        DEFAULT_CONVERTERS.put(Byte.class, new CachedDelegateConverter<Byte>(new ByteConverter()));
        DEFAULT_CONVERTERS.put(Character.class, new CharacterConverter());
        DEFAULT_CONVERTERS.put(Double.class, new DoubleConverter());
        DEFAULT_CONVERTERS.put(Float.class, new FloatConverter());
        DEFAULT_CONVERTERS.put(Integer.class, new IntegerConverter());
        DEFAULT_CONVERTERS.put(Long.class, new LongConverter());
        DEFAULT_CONVERTERS.put(Short.class, new ShortConverter());
        DEFAULT_CONVERTERS.put(Boolean.class, new CachedDelegateConverter<Boolean>(new BooleanConverter()));
        DEFAULT_CONVERTERS.put(Byte.TYPE, DEFAULT_CONVERTERS.get(Byte.class));
        DEFAULT_CONVERTERS.put(Character.TYPE, new CharacterConverter());
        DEFAULT_CONVERTERS.put(Double.TYPE, DEFAULT_CONVERTERS.get(Double.class));
        DEFAULT_CONVERTERS.put(Float.TYPE, DEFAULT_CONVERTERS.get(Float.class));
        DEFAULT_CONVERTERS.put(Integer.TYPE, DEFAULT_CONVERTERS.get(Integer.class));
        DEFAULT_CONVERTERS.put(Long.TYPE, DEFAULT_CONVERTERS.get(Long.class));
        DEFAULT_CONVERTERS.put(Short.TYPE, DEFAULT_CONVERTERS.get(Short.class));
        DEFAULT_CONVERTERS.put(Boolean.TYPE, DEFAULT_CONVERTERS.get(Boolean.class));
    }
}

