/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public abstract class BaseAccessMode
implements AccessMode {
    private final Map<Class<?>, String[]> fieldsToRemove = new HashMap();

    public BaseAccessMode() {
        this.fieldsToRemove.put(Throwable.class, new String[]{"suppressedExceptions", "cause"});
    }

    protected abstract Map<String, AccessMode.Reader> doFindReaders(Class<?> var1);

    protected abstract Map<String, AccessMode.Writer> doFindWriters(Class<?> var1);

    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindReaders(clazz));
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        return this.sanitize(clazz, this.doFindWriters(clazz));
    }

    public Map<Class<?>, String[]> getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    private <T> Map<String, T> sanitize(Class<?> type, Map<String, T> delegate) {
        for (Map.Entry<Class<?>, String[]> entry : this.fieldsToRemove.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            for (String field : entry.getValue()) {
                delegate.remove(field);
            }
            return delegate;
        }
        return delegate;
    }

    protected Type fixType(Class<?> clazz, Type type) {
        if (TypeVariable.class.isInstance(type)) {
            return this.fixTypeVariable(clazz, type);
        }
        if (ParameterizedType.class.isInstance(type)) {
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            if (actualTypeArguments.length == 1 && Class.class.isInstance(pt.getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) && ((Class)Class.class.cast(pt.getRawType())).getName().startsWith("java.util.") && TypeVariable.class.isInstance(actualTypeArguments[0])) {
                return new JohnzonParameterizedType(pt.getRawType(), this.fixTypeVariable(clazz, actualTypeArguments[0]));
            }
            if (actualTypeArguments.length == 2 && Class.class.isInstance(pt.getRawType()) && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) && ((Class)Class.class.cast(pt.getRawType())).getName().startsWith("java.util.") && TypeVariable.class.isInstance(actualTypeArguments[1])) {
                return new JohnzonParameterizedType(pt.getRawType(), actualTypeArguments[0], this.fixTypeVariable(clazz, actualTypeArguments[1]));
            }
        }
        return type;
    }

    private Type fixTypeVariable(Class<?> clazz, Type type) {
        ParameterizedType pt;
        Type genParent;
        TypeVariable<Class<?>>[] typeParameters;
        int idx;
        TypeVariable typeVariable = (TypeVariable)TypeVariable.class.cast(type);
        if (typeVariable.getGenericDeclaration() == clazz.getSuperclass() && (idx = Arrays.asList(typeParameters = clazz.getSuperclass().getTypeParameters()).indexOf(typeVariable)) >= 0 && ParameterizedType.class.isInstance(genParent = clazz.getGenericSuperclass()) && (pt = (ParameterizedType)ParameterizedType.class.cast(genParent)).getActualTypeArguments().length == typeParameters.length) {
            return pt.getActualTypeArguments()[idx];
        }
        return type;
    }
}

