/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.FieldAccessMode;
import org.apache.johnzon.mapper.access.MethodAccessMode;

public class FieldAndMethodAccessMode
extends BaseAccessMode {
    private final FieldAccessMode fields = new FieldAccessMode();
    private final MethodAccessMode methods = new MethodAccessMode(false);

    @Override
    public Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>(this.fields.findReaders(clazz));
        for (Map.Entry<String, AccessMode.Reader> entry : this.methods.findReaders(clazz).entrySet()) {
            AccessMode.Reader existing = (AccessMode.Reader)readers.get(entry.getKey());
            if (existing == null) {
                readers.put(entry.getKey(), entry.getValue());
                continue;
            }
            readers.put(entry.getKey(), new CompositeReader(existing, (AccessMode.DecoratedType)entry.getValue()));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>(this.fields.findWriters(clazz));
        for (Map.Entry<String, AccessMode.Writer> entry : this.methods.findWriters(clazz).entrySet()) {
            AccessMode.Writer existing = (AccessMode.Writer)writers.get(entry.getKey());
            if (existing == null) {
                writers.put(entry.getKey(), entry.getValue());
                continue;
            }
            writers.put(entry.getKey(), new CompositeWriter(existing, (AccessMode.DecoratedType)entry.getValue()));
        }
        return writers;
    }

    private static final class CompositeWriter
    extends CompositeDecoratedType
    implements AccessMode.Writer {
        private final AccessMode.Writer writer;

        private CompositeWriter(AccessMode.Writer type1, AccessMode.DecoratedType type2) {
            super(type1, type2);
            this.writer = type1;
        }

        @Override
        public void write(Object instance, Object value) {
            this.writer.write(instance, value);
        }
    }

    private static final class CompositeReader
    extends CompositeDecoratedType
    implements AccessMode.Reader {
        private final AccessMode.Reader reader;

        private CompositeReader(AccessMode.Reader type1, AccessMode.DecoratedType type2) {
            super(type1, type2);
            this.reader = type1;
        }

        @Override
        public Object read(Object instance) {
            return this.reader.read(instance);
        }
    }

    private static abstract class CompositeDecoratedType
    implements AccessMode.DecoratedType {
        protected final AccessMode.DecoratedType type1;
        private final AccessMode.DecoratedType type2;

        private CompositeDecoratedType(AccessMode.DecoratedType type1, AccessMode.DecoratedType type2) {
            this.type1 = type1;
            this.type2 = type2;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            T found = this.type1.getAnnotation(clazz);
            return found == null ? this.type2.getAnnotation(clazz) : found;
        }

        @Override
        public Type getType() {
            return this.type1.getType();
        }
    }
}

