/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.JohnzonConverter;
import org.apache.johnzon.mapper.JohnzonIgnore;
import org.apache.johnzon.mapper.JohnzonVirtualObject;
import org.apache.johnzon.mapper.JohnzonVirtualObjects;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.converter.DateWithCopyConverter;
import org.apache.johnzon.mapper.converter.EnumConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.reflection.Converters;
import org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public class Mappings {
    private static final JohnzonParameterizedType VIRTUAL_TYPE = new JohnzonParameterizedType((Type)((Object)Map.class), new Type[]{String.class, Object.class});
    protected final ConcurrentMap<Type, ClassMapping> classes = new ConcurrentHashMap<Type, ClassMapping>();
    protected final ConcurrentMap<Type, CollectionMapping> collections = new ConcurrentHashMap<Type, CollectionMapping>();
    protected final Comparator<String> fieldOrdering;
    protected final ConcurrentMap<AdapterKey, Adapter<?, ?>> adapters;
    private final AccessMode accessMode;
    private final int version;

    public Mappings(Comparator<String> attributeOrder, AccessMode accessMode, int version, ConcurrentMap<AdapterKey, Adapter<?, ?>> adapters) {
        this.fieldOrdering = attributeOrder;
        this.accessMode = accessMode;
        this.version = version;
        this.adapters = adapters;
    }

    public <T> CollectionMapping findCollectionMapping(ParameterizedType genericType) {
        CollectionMapping collectionMapping = (CollectionMapping)this.collections.get(genericType);
        if (collectionMapping == null) {
            collectionMapping = this.createCollectionMapping(genericType);
            if (collectionMapping == null) {
                return null;
            }
            CollectionMapping existing = this.collections.putIfAbsent(genericType, collectionMapping);
            if (existing != null) {
                collectionMapping = existing;
            }
        }
        return collectionMapping;
    }

    private <T> CollectionMapping createCollectionMapping(ParameterizedType aType) {
        Type[] fieldArgTypes = aType.getActualTypeArguments();
        Type raw = aType.getRawType();
        if (fieldArgTypes.length == 1 && Class.class.isInstance(raw)) {
            Class collectionType;
            Class r = (Class)Class.class.cast(raw);
            if (List.class.isAssignableFrom(r)) {
                collectionType = List.class;
            } else if (SortedSet.class.isAssignableFrom(r)) {
                collectionType = SortedSet.class;
            } else if (Set.class.isAssignableFrom(r)) {
                collectionType = Set.class;
            } else if (Deque.class.isAssignableFrom(r)) {
                collectionType = Deque.class;
            } else if (Queue.class.isAssignableFrom(r)) {
                collectionType = Queue.class;
            } else if (Collection.class.isAssignableFrom(r)) {
                collectionType = Collection.class;
            } else {
                return null;
            }
            CollectionMapping mapping = new CollectionMapping(Mappings.isPrimitive(fieldArgTypes[0]), collectionType, fieldArgTypes[0]);
            this.collections.putIfAbsent(aType, mapping);
            return mapping;
        }
        return null;
    }

    public static boolean isPrimitive(Type type) {
        if (type == String.class) {
            return true;
        }
        if (type == Character.TYPE || type == Character.class) {
            return true;
        }
        if (type == Long.TYPE || type == Long.class) {
            return true;
        }
        if (type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class) {
            return true;
        }
        if (type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class) {
            return true;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return true;
        }
        if (type == BigDecimal.class) {
            return true;
        }
        return type == BigInteger.class;
    }

    public ClassMapping getClassMapping(Type clazz) {
        return (ClassMapping)this.classes.get(clazz);
    }

    public ClassMapping findOrCreateClassMapping(Type clazz) {
        ClassMapping classMapping = (ClassMapping)this.classes.get(clazz);
        if (classMapping == null) {
            if (!Class.class.isInstance(clazz) || Map.class.isAssignableFrom((Class)Class.class.cast(clazz))) {
                return null;
            }
            classMapping = this.createClassMapping((Class)Class.class.cast(clazz));
            ClassMapping existing = this.classes.putIfAbsent(clazz, classMapping);
            if (existing != null) {
                classMapping = existing;
            }
        }
        return classMapping;
    }

    protected ClassMapping createClassMapping(Class<?> inClazz) {
        JohnzonVirtualObject johnzonVirtualObject;
        boolean copyDate = false;
        for (Class<?> itf : inClazz.getInterfaces()) {
            if (!"org.apache.openjpa.enhance.PersistenceCapable".equals(itf.getName())) continue;
            copyDate = true;
            break;
        }
        Class<?> clazz = this.findModelClass(inClazz);
        Comparator<String> fieldComparator = this.accessMode.fieldComparator(inClazz);
        fieldComparator = fieldComparator == null ? this.fieldOrdering : fieldComparator;
        TreeMap<String, Getter> getters = fieldComparator == null ? this.newOrderedMap(Getter.class) : new TreeMap(fieldComparator);
        TreeMap<String, Setter> setters = fieldComparator == null ? this.newOrderedMap(Setter.class) : new TreeMap(fieldComparator);
        Map<String, AccessMode.Reader> readers = this.accessMode.findReaders(clazz);
        Map<String, AccessMode.Writer> writers = this.accessMode.findWriters(clazz);
        HashSet<String> virtualFields = new HashSet<String>();
        JohnzonVirtualObjects virtualObjects = clazz.getAnnotation(JohnzonVirtualObjects.class);
        if (virtualObjects != null) {
            for (JohnzonVirtualObject virtualObject2 : virtualObjects.value()) {
                this.handleVirtualObject(virtualFields, virtualObject2, getters, setters, readers, writers, copyDate);
            }
        }
        if ((johnzonVirtualObject = clazz.getAnnotation(JohnzonVirtualObject.class)) != null) {
            this.handleVirtualObject(virtualFields, johnzonVirtualObject, getters, setters, readers, writers, copyDate);
        }
        for (Map.Entry<String, AccessMode.Reader> entry : readers.entrySet()) {
            String key = entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addGetterIfNeeded(getters, key, entry.getValue(), copyDate);
        }
        for (Map.Entry<String, AccessMode.DecoratedType> entry : writers.entrySet()) {
            String key = entry.getKey();
            if (virtualFields.contains(key)) continue;
            this.addSetterIfNeeded(setters, key, (AccessMode.Writer)entry.getValue(), copyDate);
        }
        return new ClassMapping(clazz, this.accessMode.findFactory(clazz), getters, setters);
    }

    protected Class<?> findModelClass(Class<?> inClazz) {
        Class<?> clazz;
        for (clazz = inClazz; clazz != null && clazz != Object.class && (clazz.getName().contains("$$") || clazz.getName().contains("$proxy") || clazz.getName().startsWith("org.apache.openjpa.enhance.")); clazz = clazz.getSuperclass()) {
        }
        if (clazz == null || clazz == Object.class) {
            clazz = inClazz;
        }
        return clazz;
    }

    private <T> Map<String, T> newOrderedMap(Class<T> value) {
        return this.fieldOrdering != null ? new TreeMap(this.fieldOrdering) : new HashMap();
    }

    private void addSetterIfNeeded(Map<String, Setter> setters, String key, AccessMode.Writer value, boolean copyDate) {
        JohnzonIgnore writeIgnore = value.getAnnotation(JohnzonIgnore.class);
        if (writeIgnore == null || writeIgnore.minVersion() >= 0) {
            if (key.equals("metaClass")) {
                return;
            }
            Type param = value.getType();
            Class returnType = Class.class.isInstance(param) ? (Class)Class.class.cast(param) : null;
            Setter setter = new Setter(value, Mappings.isPrimitive(param), returnType != null && returnType.isArray(), param, this.findConverter(copyDate, value), writeIgnore != null ? writeIgnore.minVersion() : -1);
            setters.put(key, setter);
        }
    }

    private void addGetterIfNeeded(Map<String, Getter> getters, String key, AccessMode.Reader value, boolean copyDate) {
        JohnzonIgnore readIgnore = value.getAnnotation(JohnzonIgnore.class);
        if (readIgnore == null || readIgnore.minVersion() >= 0) {
            Class returnType = Class.class.isInstance(value.getType()) ? (Class)Class.class.cast(value.getType()) : null;
            ParameterizedType pt = ParameterizedType.class.isInstance(value.getType()) ? (ParameterizedType)ParameterizedType.class.cast(value.getType()) : null;
            Getter getter = new Getter(value, Mappings.isPrimitive(returnType), returnType != null && returnType.isArray(), pt != null && Collection.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Collection.class.isAssignableFrom(returnType), pt != null && Map.class.isAssignableFrom((Class)Class.class.cast(pt.getRawType())) || returnType != null && Map.class.isAssignableFrom(returnType), this.findConverter(copyDate, value), readIgnore != null ? readIgnore.minVersion() : -1);
            getters.put(key, getter);
        }
    }

    private void handleVirtualObject(Collection<String> virtualFields, JohnzonVirtualObject o, Map<String, Getter> getters, Map<String, Setter> setters, Map<String, AccessMode.Reader> readers, Map<String, AccessMode.Writer> writers, boolean copyDate) {
        String[] path = o.path();
        if (path.length < 1) {
            throw new IllegalArgumentException("@JohnzonVirtualObject need a path");
        }
        for (JohnzonVirtualObject.Field f : o.fields()) {
            virtualFields.add(f.value());
        }
        Map<String, Getter> objectGetters = this.newOrderedMap(Getter.class);
        Map<String, Setter> objectSetters = this.newOrderedMap(Setter.class);
        for (JohnzonVirtualObject.Field f : o.fields()) {
            AccessMode.Writer writer;
            AccessMode.Reader reader;
            String name = f.value();
            if (f.read() && (reader = readers.get(name)) != null) {
                this.addGetterIfNeeded(objectGetters, name, reader, copyDate);
            }
            if (!f.write() || (writer = writers.get(name)) == null) continue;
            this.addSetterIfNeeded(objectSetters, name, writer, copyDate);
        }
        String key = path[0];
        Getter getter = getters.get(key);
        MapBuilderReader newReader = new MapBuilderReader(objectGetters, path, this.version);
        getters.put(key, new Getter(getter == null ? newReader : new CompositeReader(getter.reader, newReader), false, false, false, true, null, -1));
        Setter newSetter = setters.get(key);
        MapUnwrapperWriter newWriter = new MapUnwrapperWriter(objectSetters, path);
        setters.put(key, new Setter(newSetter == null ? newWriter : new CompositeWriter(newSetter.writer, newWriter), false, false, VIRTUAL_TYPE, null, -1));
    }

    private Adapter findConverter(boolean copyDate, AccessMode.DecoratedType decoratedType) {
        Type type;
        Type rawType;
        Adapter converter = decoratedType.findConverter();
        if (converter != null) {
            return converter;
        }
        JohnzonConverter annotation = decoratedType.getAnnotation(JohnzonConverter.class);
        Type typeToTest = decoratedType.getType();
        if (annotation != null) {
            try {
                converter = new ConverterAdapter(annotation.value().newInstance());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else if (ParameterizedType.class.isInstance(decoratedType.getType()) && Class.class.isInstance(rawType = (type = (ParameterizedType)ParameterizedType.class.cast(decoratedType.getType())).getRawType()) && Collection.class.isAssignableFrom((Class)Class.class.cast(rawType)) && type.getActualTypeArguments().length >= 1) {
            typeToTest = type.getActualTypeArguments()[0];
        }
        if (converter == null && Class.class.isInstance(typeToTest)) {
            type = (Class)Class.class.cast(typeToTest);
            if (Date.class.isAssignableFrom((Class<?>)type) && copyDate) {
                converter = new DateWithCopyConverter((Adapter)Adapter.class.cast(this.adapters.get(new AdapterKey((Type)((Object)Date.class), (Type)((Object)String.class)))));
            } else if (((Class)type).isEnum()) {
                AdapterKey key = new AdapterKey((Type)((Object)String.class), type);
                converter = (ConverterAdapter)this.adapters.get(key);
                if (converter == null) {
                    converter = new ConverterAdapter(new EnumConverter(type));
                    this.adapters.put(key, converter);
                }
            } else {
                for (Map.Entry adapterEntry : this.adapters.entrySet()) {
                    if (((AdapterKey)adapterEntry.getKey()).getFrom() == ((AdapterKey)adapterEntry.getKey()).getTo() || ((AdapterKey)adapterEntry.getKey()).getFrom() != type || ConverterAdapter.class.isInstance(adapterEntry.getValue()) && ((ConverterAdapter)ConverterAdapter.class.cast(adapterEntry.getValue())).getConverter().getClass().getName().startsWith("org.apache.johnzon.mapper.")) continue;
                    if (converter != null) {
                        throw new IllegalArgumentException("Ambiguous adapter for " + decoratedType);
                    }
                    converter = (Adapter)adapterEntry.getValue();
                }
            }
        }
        return converter;
    }

    private static class CompositeWriter
    implements AccessMode.Writer {
        private final AccessMode.Writer[] delegates;

        public CompositeWriter(AccessMode.Writer ... writers) {
            LinkedList<AccessMode.Writer> all = new LinkedList<AccessMode.Writer>();
            for (AccessMode.Writer r : writers) {
                if (CompositeWriter.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeWriter)CompositeWriter.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Writer[all.size()]);
        }

        @Override
        public void write(Object instance, Object value) {
            for (AccessMode.Writer w : this.delegates) {
                w.write(instance, value);
            }
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            for (AccessMode.Writer r : this.delegates) {
                Adapter<?, ?> converter = r.findConverter();
                if (converter == null) continue;
                return converter;
            }
            return null;
        }

        @Override
        public boolean isNillable() {
            for (AccessMode.Writer r : this.delegates) {
                if (!r.isNillable()) continue;
                return true;
            }
            return false;
        }
    }

    private static class CompositeReader
    implements AccessMode.Reader {
        private final AccessMode.Reader[] delegates;

        public CompositeReader(AccessMode.Reader ... delegates) {
            LinkedList<AccessMode.Reader> all = new LinkedList<AccessMode.Reader>();
            for (AccessMode.Reader r : delegates) {
                if (CompositeReader.class.isInstance(r)) {
                    all.addAll(Arrays.asList(((CompositeReader)CompositeReader.class.cast((Object)r)).delegates));
                    continue;
                }
                all.add(r);
            }
            this.delegates = all.toArray(new AccessMode.Reader[all.size()]);
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap map = new LinkedHashMap();
            for (AccessMode.Reader reader : this.delegates) {
                Map readerMap = (Map)reader.read(instance);
                for (Map.Entry entry : readerMap.entrySet()) {
                    Object o = map.get(entry.getKey());
                    if (o == null) {
                        map.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (Map.class.isInstance(o)) continue;
                    throw new IllegalStateException((String)entry.getKey() + " is ambiguous");
                }
            }
            return map;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            for (AccessMode.Reader r : this.delegates) {
                Adapter<?, ?> converter = r.findConverter();
                if (converter == null) continue;
                return converter;
            }
            return null;
        }

        @Override
        public boolean isNillable() {
            for (AccessMode.Reader r : this.delegates) {
                if (!r.isNillable()) continue;
                return true;
            }
            return false;
        }
    }

    private static class MapUnwrapperWriter
    implements AccessMode.Writer {
        private final Map<String, Setter> writers;
        private final Map<String, Class<?>> componentTypes;
        private final String[] paths;

        public MapUnwrapperWriter(Map<String, Setter> writers, String[] paths) {
            this.writers = writers;
            this.paths = paths;
            this.componentTypes = new HashMap();
            for (Map.Entry<String, Setter> setter : writers.entrySet()) {
                if (!setter.getValue().array) continue;
                this.componentTypes.put(setter.getKey(), ((Class)Class.class.cast(setter.getValue().paramType)).getComponentType());
            }
        }

        @Override
        public void write(Object instance, Object value) {
            Map nested = null;
            for (String path : this.paths) {
                if ((nested = (Map)Map.class.cast(nested == null ? value : nested.get(path))) != null) continue;
                return;
            }
            for (Map.Entry entry : this.writers.entrySet()) {
                Setter setterValue = (Setter)entry.getValue();
                String key = (String)entry.getKey();
                Object rawValue = nested.get(key);
                Object val = value == null || setterValue.converter == null ? rawValue : ((Converter)Converter.class.cast(setterValue.converter)).toString(rawValue);
                if (val == null) continue;
                if (setterValue.array && Collection.class.isInstance(val)) {
                    Collection collection = (Collection)Collection.class.cast(val);
                    Object[] array = (Object[])Array.newInstance(this.componentTypes.get(key), collection.size());
                    val = collection.toArray(array);
                }
                AccessMode.Writer setterMethod = setterValue.writer;
                setterMethod.write(instance, val);
            }
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }
    }

    private static class MapBuilderReader
    implements AccessMode.Reader {
        private final Map<String, Getter> getters;
        private final Map<String, Object> template;
        private final String[] paths;
        private final int version;

        public MapBuilderReader(Map<String, Getter> objectGetters, String[] paths, int version) {
            this.getters = objectGetters;
            this.paths = paths;
            this.template = new LinkedHashMap<String, Object>();
            this.version = version;
            Map<String, Object> last = this.template;
            for (int i = 1; i < paths.length; ++i) {
                LinkedHashMap<String, Object> newLast = new LinkedHashMap<String, Object>();
                last.put(paths[i], newLast);
                last = newLast;
            }
        }

        @Override
        public Object read(Object instance) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.template);
            Map<String, Object> nested = map;
            for (int i = 1; i < this.paths.length; ++i) {
                nested = (Map)Map.class.cast(nested.get(this.paths[i]));
            }
            for (Map.Entry<String, Getter> g : this.getters.entrySet()) {
                Getter getter = g.getValue();
                Object value = getter.reader.read(instance);
                Object val = value == null || getter.converter == null ? value : getter.converter.from(value);
                if (val == null || getter.version >= 0 && this.version >= getter.version) continue;
                nested.put(g.getKey(), val);
            }
            return map;
        }

        @Override
        public Type getType() {
            return VIRTUAL_TYPE;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            throw new UnsupportedOperationException("getAnnotation shouldn't get called for virtual fields");
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }
    }

    public static class Setter {
        public final AccessMode.Writer writer;
        public final int version;
        public final Type paramType;
        public final Adapter<?, ?> converter;
        public final Adapter<?, ?> itemConverter;
        public final boolean primitive;
        public final boolean array;

        public Setter(AccessMode.Writer writer, boolean primitive, boolean array, Type paramType, Adapter<?, ?> converter, int version) {
            this.writer = writer;
            this.paramType = paramType;
            this.version = version;
            this.primitive = primitive;
            this.array = array;
            if (converter != null && Converters.matches(writer.getType(), converter)) {
                this.converter = converter;
                this.itemConverter = null;
            } else if (converter != null) {
                this.converter = null;
                this.itemConverter = converter;
            } else {
                this.converter = null;
                this.itemConverter = null;
            }
        }

        public String toString() {
            return "Setter{writer=" + this.writer + ", version=" + this.version + ", paramType=" + this.paramType + ", converter=" + this.converter + ", itemConverter=" + this.itemConverter + ", primitive=" + this.primitive + ", array=" + this.array + '}';
        }
    }

    public static class Getter {
        public final AccessMode.Reader reader;
        public final int version;
        public final Adapter converter;
        public final Adapter itemConverter;
        public final boolean primitive;
        public final boolean array;
        public final boolean map;
        public final boolean collection;

        public Getter(AccessMode.Reader reader, boolean primitive, boolean array, boolean collection, boolean map, Adapter<?, ?> converter, int version) {
            this.reader = reader;
            this.version = version;
            this.array = array;
            this.collection = collection;
            this.primitive = primitive;
            if (converter != null && Converters.matches(reader.getType(), converter)) {
                this.converter = converter;
                this.itemConverter = null;
            } else if (converter != null) {
                this.converter = null;
                this.itemConverter = converter;
            } else {
                this.converter = null;
                this.itemConverter = null;
            }
            this.map = map && this.converter == null;
        }

        public String toString() {
            return "Getter{reader=" + this.reader + ", version=" + this.version + ", converter=" + this.converter + ", itemConverter=" + this.itemConverter + ", primitive=" + this.primitive + ", array=" + this.array + ", map=" + this.map + ", collection=" + this.collection + '}';
        }
    }

    public static class CollectionMapping {
        public final Class<?> raw;
        public final Type arg;
        public final boolean primitive;

        public CollectionMapping(boolean primitive, Class<?> collectionType, Type fieldArgType) {
            this.raw = collectionType;
            this.arg = fieldArgType;
            this.primitive = primitive;
        }
    }

    public static class ClassMapping {
        public final Class<?> clazz;
        public final AccessMode.Factory factory;
        public final Map<String, Getter> getters;
        public final Map<String, Setter> setters;

        protected ClassMapping(Class<?> clazz, AccessMode.Factory factory, Map<String, Getter> getters, Map<String, Setter> setters) {
            this.clazz = clazz;
            this.factory = factory;
            this.getters = getters;
            this.setters = setters;
        }
    }
}

