/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.xml.bind.DatatypeConverter;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.MapperConfig;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.MappingGenerator;
import org.apache.johnzon.mapper.Mappings;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.JsonPointerTracker;

public class MappingGeneratorImpl
implements MappingGenerator {
    private final MapperConfig config;
    private final JsonGenerator generator;
    private final Mappings mappings;
    private final Boolean isDeduplicateObjects;
    private Map<Object, String> jsonPointers;

    MappingGeneratorImpl(MapperConfig config, JsonGenerator jsonGenerator, Mappings mappings, Boolean isDeduplicateObjects) {
        this.config = config;
        this.generator = jsonGenerator;
        this.mappings = mappings;
        this.isDeduplicateObjects = isDeduplicateObjects;
        this.jsonPointers = isDeduplicateObjects != false ? new HashMap() : Collections.emptyMap();
    }

    @Override
    public JsonGenerator getJsonGenerator() {
        return this.generator;
    }

    @Override
    public MappingGenerator writeObject(Object object, JsonGenerator generator) {
        if (object == null) {
            return this;
        }
        if (object instanceof JsonValue) {
            generator.write((JsonValue)object);
        } else {
            this.doWriteObject(object, generator, false, null, this.isDeduplicateObjects != false ? new JsonPointerTracker(null, "/") : null);
        }
        return this;
    }

    public void doWriteObject(Object object, JsonGenerator generator, boolean writeBody, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        try {
            if (object instanceof Map) {
                if (writeBody) {
                    generator.writeStartObject();
                }
                this.writeMapBody((Map)object, null);
                if (writeBody) {
                    generator.writeEnd();
                }
                return;
            }
            if (this.writePrimitives(object)) {
                return;
            }
            Class<?> objectClass = object.getClass();
            if (objectClass.isEnum()) {
                Adapter adapter = this.config.findAdapter(objectClass);
                String adaptedValue = adapter.from(object).toString();
                generator.write(adaptedValue);
                return;
            }
            if (object instanceof Iterable) {
                this.doWriteIterable((Iterable)object, ignoredProperties, jsonPointer);
                return;
            }
            if (writeBody) {
                generator.writeStartObject();
            }
            ObjectConverter.Writer objectConverter = this.config.findObjectConverterWriter(objectClass);
            if (writeBody && objectConverter != null) {
                objectConverter.writeJson(object, this);
            } else {
                this.doWriteObjectBody(object, ignoredProperties, jsonPointer);
            }
            if (writeBody) {
                generator.writeEnd();
            }
        }
        catch (InvocationTargetException e) {
            throw new MapperException(e);
        }
        catch (IllegalAccessException e) {
            throw new MapperException(e);
        }
    }

    private JsonGenerator writeMapBody(Map<?, ?> object, Adapter itemConverter) throws InvocationTargetException, IllegalAccessException {
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value == null) {
                if (this.config.isSkipNull()) continue;
                this.generator.writeNull(key == null ? "null" : key.toString());
                continue;
            }
            Class<?> valueClass = value.getClass();
            this.writeValue(valueClass, true, false, false, false, false, itemConverter, key == null ? "null" : key.toString(), value, null, null, null);
        }
        return this.generator;
    }

    private boolean writePrimitives(Object value) {
        boolean handled = false;
        if (value == null) {
            return true;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.generator.write(value.toString());
            handled = true;
        } else if (type == Long.TYPE || type == Long.class) {
            this.generator.write(((Long)Long.class.cast(value)).longValue());
            handled = true;
        } else if (MappingGeneratorImpl.isInt(type)) {
            this.generator.write(((Number)Number.class.cast(value)).intValue());
            handled = true;
        } else if (MappingGeneratorImpl.isFloat(type)) {
            double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
            if (!Double.isNaN(doubleValue)) {
                this.generator.write(doubleValue);
            }
            handled = true;
        } else {
            if (type == Boolean.TYPE || type == Boolean.class) {
                this.generator.write(((Boolean)Boolean.class.cast(value)).booleanValue());
                return true;
            }
            if (type == BigDecimal.class) {
                this.generator.write((BigDecimal)BigDecimal.class.cast(value));
                handled = true;
            } else if (type == BigInteger.class) {
                this.generator.write((BigInteger)BigInteger.class.cast(value));
                handled = true;
            } else if (type == Character.TYPE || type == Character.class) {
                this.generator.write(((Character)Character.class.cast(value)).toString());
                handled = true;
            }
        }
        return handled;
    }

    private boolean writePrimitives(String key, Class<?> type, Object value) {
        boolean handled = false;
        if (type == String.class) {
            this.generator.write(key, value.toString());
            handled = true;
        } else if (type == Long.TYPE || type == Long.class) {
            this.generator.write(key, ((Long)Long.class.cast(value)).longValue());
            handled = true;
        } else if (MappingGeneratorImpl.isInt(type)) {
            this.generator.write(key, ((Number)Number.class.cast(value)).intValue());
            handled = true;
        } else if (MappingGeneratorImpl.isFloat(type)) {
            double doubleValue = ((Number)Number.class.cast(value)).doubleValue();
            if (!Double.isNaN(doubleValue)) {
                this.generator.write(key, doubleValue);
            }
            handled = true;
        } else if (type == Boolean.TYPE || type == Boolean.class) {
            this.generator.write(key, ((Boolean)Boolean.class.cast(value)).booleanValue());
            handled = true;
        } else if (type == BigDecimal.class) {
            this.generator.write(key, (BigDecimal)BigDecimal.class.cast(value));
            handled = true;
        } else if (type == BigInteger.class) {
            this.generator.write(key, (BigInteger)BigInteger.class.cast(value));
            handled = true;
        } else if (type == Character.TYPE || type == Character.class) {
            this.generator.write(key, ((Character)Character.class.cast(value)).toString());
            handled = true;
        }
        return handled;
    }

    private static boolean isInt(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class;
    }

    private static boolean isFloat(Class<?> type) {
        return type == Double.TYPE || type == Double.class || type == Float.TYPE || type == Float.class;
    }

    private void doWriteObjectBody(Object object, Collection<String> ignored, JsonPointerTracker jsonPointer) throws IllegalAccessException, InvocationTargetException {
        Map any;
        Class<?> objectClass;
        Mappings.ClassMapping classMapping;
        if (jsonPointer != null) {
            this.jsonPointers.put(object, jsonPointer.toString());
        }
        if ((classMapping = this.mappings.findOrCreateClassMapping(objectClass = object.getClass())) == null) {
            throw new MapperException("No mapping for " + objectClass.getName());
        }
        if (classMapping.writer != null) {
            classMapping.writer.writeJson(object, this);
            return;
        }
        if (classMapping.adapter != null) {
            this.doWriteObjectBody(classMapping.adapter.to(object), ignored, jsonPointer);
            return;
        }
        for (Map.Entry<String, Mappings.Getter> getterEntry : classMapping.getters.entrySet()) {
            Mappings.Getter getter = getterEntry.getValue();
            if (ignored != null && ignored.contains(getterEntry.getKey()) || getter.version >= 0 && this.config.getVersion() >= getter.version) continue;
            Object value = getter.reader.read(object);
            if (JsonValue.class.isInstance(value)) {
                this.generator.write(getterEntry.getKey(), (JsonValue)JsonValue.class.cast(value));
                continue;
            }
            if (value == null) {
                if (this.config.isSkipNull() && !getter.reader.isNillable()) continue;
                this.generator.writeNull(getterEntry.getKey());
                continue;
            }
            Object val = getter.converter == null ? value : getter.converter.from(value);
            String valJsonPointer = this.jsonPointers.get(val);
            if (valJsonPointer != null) {
                this.generator.write(getterEntry.getKey(), valJsonPointer);
                continue;
            }
            this.writeValue(val.getClass(), getter.dynamic, getter.primitive, getter.array, getter.collection, getter.map, getter.itemConverter, getterEntry.getKey(), val, getter.objectConverter, getter.ignoreNested, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, getterEntry.getKey()) : null);
        }
        if (classMapping.anyGetter != null && (any = (Map)Map.class.cast(classMapping.anyGetter.reader.read(object))) != null) {
            this.writeMapBody(any, null);
        }
    }

    private void writeValue(Class<?> type, boolean dynamic, boolean primitive, boolean array, boolean collection, boolean map, Adapter itemConverter, String key, Object value, ObjectConverter.Writer objectConverter, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) throws InvocationTargetException, IllegalAccessException {
        if (this.config.getSerializeValueFilter().shouldIgnore(key, value)) {
            return;
        }
        if (array || dynamic && type.isArray()) {
            int length = Array.getLength(value);
            if (length == 0 && this.config.isSkipEmptyArray()) {
                return;
            }
            if (this.config.isTreatByteArrayAsBase64() && type == byte[].class) {
                String base64EncodedByteArray = DatatypeConverter.printBase64Binary((byte[])((byte[])value));
                this.generator.write(key, base64EncodedByteArray);
                return;
            }
            if (this.config.isTreatByteArrayAsBase64URL() && type == byte[].class) {
                this.generator.write(key, String.valueOf(((Adapter)Adapter.class.cast(this.config.getAdapters().get(new AdapterKey((Type)((Object)byte[].class), (Type)((Object)String.class))))).to(value)));
                return;
            }
            this.generator.writeStartArray(key);
            for (int i = 0; i < length; ++i) {
                Object o = Array.get(value, i);
                String valJsonPointer = this.jsonPointers.get(o);
                if (valJsonPointer != null) {
                    this.writePrimitives(valJsonPointer);
                    continue;
                }
                this.writeItem(itemConverter != null ? itemConverter.from(o) : o, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
            }
            this.generator.writeEnd();
        } else if (collection || dynamic && Collection.class.isAssignableFrom(type)) {
            this.generator.writeStartArray(key);
            int i = 0;
            for (Object o : (Collection)Collection.class.cast(value)) {
                String valJsonPointer = this.jsonPointers.get(o);
                if (valJsonPointer != null) {
                    this.writePrimitives(valJsonPointer);
                } else {
                    ObjectConverter.Writer objectConverterToUse = objectConverter;
                    if (o != null && objectConverterToUse == null) {
                        objectConverterToUse = this.config.findObjectConverterWriter(o.getClass());
                    }
                    if (objectConverterToUse != null) {
                        this.generator.writeStartObject();
                        objectConverterToUse.writeJson(o, this);
                        this.generator.writeEnd();
                    } else {
                        this.writeItem(itemConverter != null ? itemConverter.from(o) : o, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
                    }
                }
                ++i;
            }
            this.generator.writeEnd();
        } else if (map || dynamic && Map.class.isAssignableFrom(type)) {
            this.generator.writeStartObject(key);
            this.writeMapBody((Map)value, itemConverter);
            this.generator.writeEnd();
        } else if (primitive || dynamic && Mappings.isPrimitive(type)) {
            this.writePrimitives(key, type, value);
        } else {
            Adapter converter = this.config.findAdapter(type);
            if (converter != null) {
                Object adapted = this.doConvertFrom(value, converter);
                if (this.writePrimitives(key, adapted.getClass(), adapted)) {
                    return;
                }
                this.writeValue(String.class, true, true, false, false, false, null, key, adapted, null, ignoredProperties, jsonPointer);
                return;
            }
            ObjectConverter.Writer objectConverterToUse = objectConverter;
            if (objectConverterToUse == null) {
                objectConverterToUse = this.config.findObjectConverterWriter(type);
            }
            if (objectConverterToUse != null) {
                this.generator.writeStartObject(key);
                objectConverterToUse.writeJson(value, this);
                this.generator.writeEnd();
                return;
            }
            if (this.writePrimitives(key, type, value)) {
                return;
            }
            this.generator.writeStartObject(key);
            this.doWriteObjectBody(value, ignoredProperties, jsonPointer);
            this.generator.writeEnd();
        }
    }

    private void writeItem(Object o, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        if (o == null) {
            this.generator.writeNull();
        } else if (!this.writePrimitives(o)) {
            if (Collection.class.isInstance(o)) {
                this.doWriteIterable((Iterable)Collection.class.cast(o), ignoredProperties, jsonPointer);
            } else if (o.getClass().isArray()) {
                int length = Array.getLength(o);
                if (length > 0 || !this.config.isSkipEmptyArray()) {
                    this.generator.writeStartArray();
                    for (int i = 0; i < length; ++i) {
                        Object t = Array.get(o, i);
                        if (t == null) {
                            this.generator.writeNull();
                            continue;
                        }
                        this.writeItem(t, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
                    }
                    this.generator.writeEnd();
                }
            } else {
                String valJsonPointer = this.jsonPointers.get(o);
                if (valJsonPointer != null) {
                    this.generator.write(valJsonPointer);
                } else {
                    this.doWriteObject(o, this.generator, true, ignoredProperties, jsonPointer);
                }
            }
        }
    }

    private <T> void doWriteIterable(Iterable<T> object, Collection<String> ignoredProperties, JsonPointerTracker jsonPointer) {
        if (object == null) {
            this.generator.writeStartArray().writeEnd();
        } else {
            this.generator.writeStartArray();
            int i = 0;
            for (T t : object) {
                if (JsonValue.class.isInstance(t)) {
                    this.generator.write((JsonValue)JsonValue.class.cast(t));
                } else if (t == null) {
                    this.generator.writeNull();
                } else {
                    this.writeItem(t, ignoredProperties, this.isDeduplicateObjects != false ? new JsonPointerTracker(jsonPointer, i) : null);
                }
                ++i;
            }
            this.generator.writeEnd();
        }
    }

    private <T> Object doConvertFrom(T value, Adapter<T, Object> converter) {
        if (converter == null) {
            throw new MapperException("can't convert " + value + " to String");
        }
        return converter.from(value);
    }
}

