/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.JohnzonAny;
import org.apache.johnzon.mapper.JohnzonProperty;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.access.BaseAccessMode;
import org.apache.johnzon.mapper.access.Meta;

public class FieldAccessMode
extends BaseAccessMode {
    public FieldAccessMode(boolean useConstructor, boolean acceptHiddenConstructor) {
        super(useConstructor, acceptHiddenConstructor);
    }

    @Override
    public Map<String, AccessMode.Reader> doFindReaders(Class<?> clazz) {
        HashMap<String, AccessMode.Reader> readers = new HashMap<String, AccessMode.Reader>();
        for (Map.Entry<String, Field> f : this.fields(clazz, true).entrySet()) {
            String key = f.getKey();
            if (this.isIgnored(key) || Meta.getAnnotation(f.getValue(), JohnzonAny.class) != null) continue;
            Field field = f.getValue();
            readers.put(this.extractKey(field, key), new FieldReader(field, this.fixType(clazz, field.getGenericType())));
        }
        return readers;
    }

    @Override
    public Map<String, AccessMode.Writer> doFindWriters(Class<?> clazz) {
        HashMap<String, AccessMode.Writer> writers = new HashMap<String, AccessMode.Writer>();
        for (Map.Entry<String, Field> f : this.fields(clazz, false).entrySet()) {
            String key = f.getKey();
            if (this.isIgnored(key)) continue;
            Field field = f.getValue();
            writers.put(this.extractKey(field, key), new FieldWriter(field, this.fixType(clazz, field.getGenericType())));
        }
        return writers;
    }

    private String extractKey(Field f, String key) {
        JohnzonProperty property = Meta.getAnnotation(f, JohnzonProperty.class);
        return property != null ? property.value() : key;
    }

    protected boolean isIgnored(String key) {
        return key.contains("$");
    }

    protected Map<String, Field> fields(Class<?> clazz, boolean includeFinalFields) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field f : current.getDeclaredFields()) {
                String name = f.getName();
                int modifiers = f.getModifiers();
                if (fields.containsKey(name) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || !includeFinalFields && Modifier.isFinal(modifiers)) continue;
                fields.put(name, f);
            }
        }
        return fields;
    }

    public static class FieldReader
    extends FieldDecoratedType
    implements AccessMode.Reader {
        public FieldReader(Field field, Type type) {
            super(field, type);
        }

        @Override
        public Object read(Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            return null;
        }

        @Override
        public Type getType() {
            return this.type;
        }
    }

    public static class FieldWriter
    extends FieldDecoratedType
    implements AccessMode.Writer {
        public FieldWriter(Field field, Type type) {
            super(field, type);
        }

        @Override
        public void write(Object instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (Exception e) {
                throw new MapperException(e);
            }
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            return null;
        }
    }

    public static abstract class FieldDecoratedType
    implements AccessMode.DecoratedType {
        protected final Field field;
        protected final Type type;

        public FieldDecoratedType(Field field, Type type) {
            this.field = field;
            if (!field.isAccessible()) {
                this.field.setAccessible(true);
            }
            this.type = type;
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            Class<?> declaringClass = this.field.getDeclaringClass();
            T annotation = Meta.getAnnotation(declaringClass, clazz);
            return annotation == null ? Meta.getAnnotation(declaringClass.getPackage(), clazz) : annotation;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        public Field getField() {
            return this.field;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return Meta.getAnnotation(this.field, clazz);
        }

        @Override
        public boolean isNillable() {
            return false;
        }
    }
}

