/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper.map;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MapperException;
import org.apache.johnzon.mapper.converter.BigDecimalConverter;
import org.apache.johnzon.mapper.converter.BigIntegerConverter;
import org.apache.johnzon.mapper.converter.ClassConverter;
import org.apache.johnzon.mapper.converter.DateConverter;
import org.apache.johnzon.mapper.converter.LocaleConverter;
import org.apache.johnzon.mapper.converter.StringConverter;
import org.apache.johnzon.mapper.converter.URIConverter;
import org.apache.johnzon.mapper.converter.URLConverter;
import org.apache.johnzon.mapper.converter.UUIDConverter;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.util.DateUtil;

public class LazyConverterMap
extends ConcurrentHashMap<AdapterKey, Adapter<?, ?>> {
    private static final Adapter<?, ?> NO_ADAPTER = new Adapter<Object, Object>(){

        @Override
        public Object to(Object b) {
            throw new UnsupportedOperationException("shouldn't be called");
        }

        @Override
        public Object from(Object a) {
            return this.to((Object)null);
        }
    };
    private boolean useShortISO8601Format = true;
    private DateTimeFormatter dateTimeFormatter;

    public void setUseShortISO8601Format(boolean useShortISO8601Format) {
        this.useShortISO8601Format = useShortISO8601Format;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public Adapter<?, ?> get(Object key) {
        Adapter found = (Adapter)super.get(key);
        if (found == NO_ADAPTER) {
            return null;
        }
        if (found == null) {
            Adapter<?, ?> adapter;
            if (!AdapterKey.class.isInstance(key)) {
                return null;
            }
            AdapterKey k = (AdapterKey)AdapterKey.class.cast(key);
            if (k.getTo() == String.class && (adapter = this.doLazyLookup(k)) != null) {
                return adapter;
            }
            this.add(k, NO_ADAPTER);
            return null;
        }
        return found;
    }

    @Override
    public Set<Map.Entry<AdapterKey, Adapter<?, ?>>> entrySet() {
        return super.entrySet().stream().filter(it -> it.getValue() != NO_ADAPTER).collect(Collectors.toSet());
    }

    public Set<AdapterKey> adapterKeys() {
        return Stream.concat(super.keySet().stream().filter(it -> super.get(it) != NO_ADAPTER), Stream.of(Date.class, URI.class, URL.class, Class.class, String.class, BigDecimal.class, BigInteger.class, Locale.class, Period.class, Duration.class, Calendar.class, GregorianCalendar.class, TimeZone.class, ZoneId.class, ZoneOffset.class, SimpleTimeZone.class, Instant.class, LocalDateTime.class, LocalDate.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class).map(it -> new AdapterKey((Type)it, (Type)((Object)String.class), true))).collect(Collectors.toSet());
    }

    private Adapter<?, ?> doLazyLookup(AdapterKey key) {
        Type from = key.getFrom();
        if (from == Date.class) {
            return this.addDateConverter(key);
        }
        if (from == URI.class) {
            return this.add(key, new ConverterAdapter<URI>(new URIConverter(), (Type)((Object)URI.class)));
        }
        if (from == URL.class) {
            return this.add(key, new ConverterAdapter<URL>(new URLConverter(), (Type)((Object)URL.class)));
        }
        if (from == Class.class) {
            return this.add(key, new ConverterAdapter(new ClassConverter(), (Type)((Object)Class.class)));
        }
        if (from == String.class) {
            return this.add(key, new ConverterAdapter<String>(new StringConverter(), (Type)((Object)String.class)));
        }
        if (from == BigDecimal.class) {
            return this.add(key, new ConverterAdapter<BigDecimal>(new BigDecimalConverter(), (Type)((Object)BigDecimal.class)));
        }
        if (from == BigInteger.class) {
            return this.add(key, new ConverterAdapter<BigInteger>(new BigIntegerConverter(), (Type)((Object)BigInteger.class)));
        }
        if (from == Locale.class) {
            return this.add(key, new LocaleConverter());
        }
        if (from == Period.class) {
            return this.add(key, new ConverterAdapter<Period>(new Converter<Period>(){

                @Override
                public String toString(Period instance) {
                    return instance.toString();
                }

                @Override
                public Period fromString(String text) {
                    return Period.parse(text);
                }
            }, (Type)((Object)Period.class)));
        }
        if (from == Duration.class) {
            return this.add(key, new ConverterAdapter<Duration>(new Converter<Duration>(){

                @Override
                public String toString(Duration instance) {
                    return instance.toString();
                }

                @Override
                public Duration fromString(String text) {
                    return Duration.parse(text);
                }
            }, (Type)((Object)Duration.class)));
        }
        if (from == Calendar.class) {
            return this.addCalendarConverter(key);
        }
        if (from == GregorianCalendar.class) {
            return this.addGregorianCalendar(key);
        }
        if (from == TimeZone.class) {
            return this.add(key, new ConverterAdapter<TimeZone>(new Converter<TimeZone>(){

                @Override
                public String toString(TimeZone instance) {
                    return instance.getID();
                }

                @Override
                public TimeZone fromString(String text) {
                    LazyConverterMap.checkForDeprecatedTimeZone(text);
                    return TimeZone.getTimeZone(text);
                }
            }, (Type)((Object)TimeZone.class)));
        }
        if (from == ZoneId.class) {
            return this.add(key, new ConverterAdapter<ZoneId>(new Converter<ZoneId>(){

                @Override
                public String toString(ZoneId instance) {
                    return instance.getId();
                }

                @Override
                public ZoneId fromString(String text) {
                    return ZoneId.of(text);
                }
            }, (Type)((Object)ZoneId.class)));
        }
        if (from == ZoneOffset.class) {
            return this.add(key, new ConverterAdapter<ZoneOffset>(new Converter<ZoneOffset>(){

                @Override
                public String toString(ZoneOffset instance) {
                    return instance.getId();
                }

                @Override
                public ZoneOffset fromString(String text) {
                    return ZoneOffset.of(text);
                }
            }, (Type)((Object)ZoneOffset.class)));
        }
        if (from == SimpleTimeZone.class) {
            return this.add(key, new ConverterAdapter<SimpleTimeZone>(new Converter<SimpleTimeZone>(){

                @Override
                public String toString(SimpleTimeZone instance) {
                    return instance.getID();
                }

                @Override
                public SimpleTimeZone fromString(String text) {
                    LazyConverterMap.checkForDeprecatedTimeZone(text);
                    TimeZone timeZone = TimeZone.getTimeZone(text);
                    return new SimpleTimeZone(timeZone.getRawOffset(), timeZone.getID());
                }
            }, (Type)((Object)SimpleTimeZone.class)));
        }
        if (from == Instant.class) {
            return this.addInstantConverter(key);
        }
        if (from == LocalDate.class) {
            return this.addLocalDateConverter(key);
        }
        if (from == LocalTime.class) {
            return this.add(key, new ConverterAdapter<LocalTime>(new Converter<LocalTime>(){

                @Override
                public String toString(LocalTime instance) {
                    return instance.toString();
                }

                @Override
                public LocalTime fromString(String text) {
                    return LocalTime.parse(text);
                }
            }, (Type)((Object)LocalTime.class)));
        }
        if (from == LocalDateTime.class) {
            return this.addLocalDateTimeConverter(key);
        }
        if (from == ZonedDateTime.class) {
            return this.addZonedDateTimeConverter(key);
        }
        if (from == OffsetDateTime.class) {
            return this.addOffsetDateTimeConverter(key);
        }
        if (from == OffsetTime.class) {
            return this.add(key, new ConverterAdapter<OffsetTime>(new Converter<OffsetTime>(){

                @Override
                public String toString(OffsetTime instance) {
                    return instance.toString();
                }

                @Override
                public OffsetTime fromString(String text) {
                    return OffsetTime.parse(text);
                }
            }, (Type)((Object)OffsetTime.class)));
        }
        if (from == UUID.class) {
            return this.add(key, new ConverterAdapter<UUID>(new UUIDConverter(), (Type)((Object)UUID.class)));
        }
        return null;
    }

    private Adapter<?, ?> addOffsetDateTimeConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<OffsetDateTime>(new Converter<OffsetDateTime>(){

                @Override
                public String toString(OffsetDateTime instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                @Override
                public OffsetDateTime fromString(String text) {
                    try {
                        return DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC).toOffsetDateTime();
                    }
                    catch (DateTimeParseException dpe) {
                        return OffsetDateTime.parse(text);
                    }
                }
            }, (Type)((Object)OffsetDateTime.class)));
        }
        return this.add(key, new ConverterAdapter<OffsetDateTime>(new Converter<OffsetDateTime>(){

            @Override
            public String toString(OffsetDateTime instance) {
                return instance.toString();
            }

            @Override
            public OffsetDateTime fromString(String text) {
                return OffsetDateTime.parse(text);
            }
        }, (Type)((Object)OffsetDateTime.class)));
    }

    private Adapter<?, ?> addZonedDateTimeConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<ZonedDateTime>(new Converter<ZonedDateTime>(){

                @Override
                public String toString(ZonedDateTime instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                @Override
                public ZonedDateTime fromString(String text) {
                    try {
                        return DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC);
                    }
                    catch (DateTimeParseException dpe) {
                        return ZonedDateTime.parse(text);
                    }
                }
            }, (Type)((Object)ZonedDateTime.class)));
        }
        return this.add(key, new ConverterAdapter<ZonedDateTime>(new Converter<ZonedDateTime>(){

            @Override
            public String toString(ZonedDateTime instance) {
                return instance.toString();
            }

            @Override
            public ZonedDateTime fromString(String text) {
                return ZonedDateTime.parse(text);
            }
        }, (Type)((Object)ZonedDateTime.class)));
    }

    private Adapter<?, ?> addLocalDateTimeConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<LocalDateTime>(new Converter<LocalDateTime>(){

                @Override
                public String toString(LocalDateTime instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(ZoneOffset.UTC), zoneIDUTC));
                }

                @Override
                public LocalDateTime fromString(String text) {
                    try {
                        return DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC).toLocalDateTime();
                    }
                    catch (DateTimeParseException dpe) {
                        return LocalDateTime.parse(text);
                    }
                }
            }, (Type)((Object)LocalDateTime.class)));
        }
        return this.add(key, new ConverterAdapter<LocalDateTime>(new Converter<LocalDateTime>(){

            @Override
            public String toString(LocalDateTime instance) {
                return instance.toString();
            }

            @Override
            public LocalDateTime fromString(String text) {
                return LocalDateTime.parse(text);
            }
        }, (Type)((Object)LocalDateTime.class)));
    }

    private Adapter<?, ?> addLocalDateConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<LocalDate>(new Converter<LocalDate>(){

                @Override
                public String toString(LocalDate instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(TimeUnit.DAYS.toMillis(instance.toEpochDay())), zoneIDUTC));
                }

                @Override
                public LocalDate fromString(String text) {
                    try {
                        return DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC).toLocalDate();
                    }
                    catch (DateTimeParseException dpe) {
                        return LocalDate.parse(text);
                    }
                }
            }, (Type)((Object)LocalDate.class)));
        }
        return this.add(key, new ConverterAdapter<LocalDate>(new Converter<LocalDate>(){

            @Override
            public String toString(LocalDate instance) {
                return instance.toString();
            }

            @Override
            public LocalDate fromString(String text) {
                return LocalDate.parse(text);
            }
        }, (Type)((Object)LocalDate.class)));
    }

    private Adapter<?, ?> addInstantConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<Instant>(new Converter<Instant>(){

                @Override
                public String toString(Instant instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance, zoneIDUTC));
                }

                @Override
                public Instant fromString(String text) {
                    return DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC).toInstant();
                }
            }, (Type)((Object)Instant.class)));
        }
        return this.add(key, new ConverterAdapter<Instant>(new Converter<Instant>(){

            @Override
            public String toString(Instant instance) {
                return instance.toString();
            }

            @Override
            public Instant fromString(String text) {
                return Instant.parse(text);
            }
        }, (Type)((Object)Instant.class)));
    }

    private Adapter<?, ?> addGregorianCalendar(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<GregorianCalendar>(new Converter<GregorianCalendar>(){

                @Override
                public String toString(GregorianCalendar instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(), instance.getTimeZone().toZoneId()));
                }

                @Override
                public GregorianCalendar fromString(String text) {
                    ZonedDateTime zonedDateTime = DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC);
                    Calendar instance = GregorianCalendar.getInstance();
                    instance.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
                    instance.setTime(Date.from(zonedDateTime.toInstant()));
                    return (GregorianCalendar)GregorianCalendar.class.cast(instance);
                }
            }, (Type)((Object)GregorianCalendar.class)));
        }
        return this.add(key, new ConverterAdapter<GregorianCalendar>(new Converter<GregorianCalendar>(){

            @Override
            public String toString(GregorianCalendar instance) {
                return LazyConverterMap.this.toStringCalendar(instance);
            }

            @Override
            public GregorianCalendar fromString(String text) {
                return (GregorianCalendar)LazyConverterMap.this.fromCalendar(text, GregorianCalendar::from);
            }
        }, (Type)((Object)GregorianCalendar.class)));
    }

    private Adapter<?, ?> addCalendarConverter(AdapterKey key) {
        if (this.dateTimeFormatter != null) {
            final ZoneId zoneIDUTC = ZoneId.of("UTC");
            return this.add(key, new ConverterAdapter<Calendar>(new Converter<Calendar>(){

                @Override
                public String toString(Calendar instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(), instance.getTimeZone().toZoneId()));
                }

                @Override
                public Calendar fromString(String text) {
                    ZonedDateTime zonedDateTime = DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC);
                    Calendar instance = Calendar.getInstance();
                    instance.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
                    instance.setTime(Date.from(zonedDateTime.toInstant()));
                    return instance;
                }
            }, (Type)((Object)Calendar.class)));
        }
        return this.add(key, new ConverterAdapter<Calendar>(new Converter<Calendar>(){

            @Override
            public String toString(Calendar instance) {
                return LazyConverterMap.this.toStringCalendar(instance);
            }

            @Override
            public Calendar fromString(String text) {
                return LazyConverterMap.this.fromCalendar(text, zdt -> {
                    Calendar instance = Calendar.getInstance();
                    instance.clear();
                    instance.setTimeZone(TimeZone.getTimeZone(zdt.getZone()));
                    instance.setTimeInMillis(zdt.toInstant().toEpochMilli());
                    return instance;
                });
            }
        }, (Type)((Object)Calendar.class)));
    }

    private Adapter<?, ?> addDateConverter(AdapterKey key) {
        if (this.useShortISO8601Format) {
            return this.add(key, new ConverterAdapter<Date>(DateConverter.ISO_8601_SHORT, (Type)((Object)Date.class)));
        }
        final ZoneId zoneIDUTC = ZoneId.of("UTC");
        if (this.dateTimeFormatter != null) {
            return this.add(key, new ConverterAdapter<Date>(new Converter<Date>(){

                @Override
                public String toString(Date instance) {
                    return LazyConverterMap.this.dateTimeFormatter.format(ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC));
                }

                @Override
                public Date fromString(String text) {
                    try {
                        return Date.from(DateUtil.parseZonedDateTime(text, LazyConverterMap.this.dateTimeFormatter, zoneIDUTC).toInstant());
                    }
                    catch (DateTimeParseException dpe) {
                        return Date.from(LocalDateTime.parse(text).toInstant(ZoneOffset.UTC));
                    }
                }
            }, (Type)((Object)Date.class)));
        }
        return this.add(key, new ConverterAdapter<Date>(new Converter<Date>(){

            @Override
            public String toString(Date instance) {
                return ZonedDateTime.ofInstant(instance.toInstant(), zoneIDUTC).format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
            }

            @Override
            public Date fromString(String text) {
                try {
                    return Date.from(ZonedDateTime.parse(text).toInstant());
                }
                catch (DateTimeParseException dte) {
                    return Date.from(LocalDateTime.parse(text).toInstant(ZoneOffset.UTC));
                }
            }
        }, (Type)((Object)Date.class)));
    }

    private static void checkForDeprecatedTimeZone(String text) {
        switch (text) {
            case "CST": {
                throw new MapperException("Deprecated timezone: '" + text + '\"');
            }
        }
    }

    private String toStringCalendar(Calendar instance) {
        if (!this.hasTime(instance)) {
            LocalDate localDate = LocalDate.of(instance.get(1), instance.get(2) + 1, instance.get(5));
            return localDate.toString() + (instance.getTimeZone() != null ? instance.getTimeZone().toZoneId().getRules().getOffset(Instant.ofEpochMilli(TimeUnit.DAYS.toMillis(localDate.toEpochDay()))) : "");
        }
        return ZonedDateTime.ofInstant(instance.toInstant(), instance.getTimeZone().toZoneId()).format(DateTimeFormatter.ISO_DATE_TIME);
    }

    private boolean hasTime(Calendar instance) {
        if (!instance.isSet(11)) {
            return false;
        }
        return instance.get(11) != 0 || instance.isSet(12) && instance.get(12) != 0 || instance.isSet(13) && instance.get(13) != 0;
    }

    private <T extends Calendar> T fromCalendar(String text, Function<ZonedDateTime, T> calendarSupplier) {
        switch (text.length()) {
            case 10: {
                ZonedDateTime date = LocalDate.parse(text).atTime(0, 0, 0).atZone(ZoneId.of("UTC"));
                return (T)((Calendar)calendarSupplier.apply(date));
            }
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(text);
        return (T)((Calendar)calendarSupplier.apply(zonedDateTime));
    }

    private Adapter<?, ?> add(AdapterKey key, Adapter<?, ?> converter) {
        Adapter<?, ?> existing = this.putIfAbsent(key, converter);
        return existing == null ? converter : existing;
    }
}

