/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class Release {
    private static final String UDDI_VERSION = "3.0";
    private static final String JAR_NAME = "juddi-client";
    private static String registryVersion = null;
    public static final String UNKNOWN = "unknown";

    private Release() {
    }

    public static String getjUDDIClientVersion() {
        return Release.getRegistryVersion();
    }

    public static String getRegistryVersion() {
        if (registryVersion == null) {
            registryVersion = Release.getVersionFromManifest(JAR_NAME);
        }
        return registryVersion;
    }

    public static String getUDDIVersion() {
        return UDDI_VERSION;
    }

    public static String getVersionFromManifest(String jarName) {
        try {
            Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resEnum.hasMoreElements()) {
                try {
                    Manifest manifest;
                    Attributes mainAttribs;
                    String version;
                    InputStream is;
                    URL url = resEnum.nextElement();
                    if (!url.toString().toLowerCase().contains(jarName) || (is = url.openStream()) == null || (version = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue("Bundle-Version")) == null) continue;
                    return version;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return UNKNOWN;
    }
}

