/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.uddi.api_v2.Address;
import org.uddi.api_v2.AddressLine;
import org.uddi.api_v2.AssertionStatusReport;
import org.uddi.api_v2.BindingDetail;
import org.uddi.api_v2.BindingTemplate;
import org.uddi.api_v2.BindingTemplates;
import org.uddi.api_v2.BusinessDetailExt;
import org.uddi.api_v2.BusinessEntityExt;
import org.uddi.api_v2.BusinessService;
import org.uddi.api_v2.BusinessServices;
import org.uddi.api_v2.Contact;
import org.uddi.api_v2.Contacts;
import org.uddi.api_v2.DeleteBusiness;
import org.uddi.api_v2.DeletePublisherAssertions;
import org.uddi.api_v2.DeleteService;
import org.uddi.api_v2.DeleteTModel;
import org.uddi.api_v2.Description;
import org.uddi.api_v2.Direction;
import org.uddi.api_v2.DiscoveryURL;
import org.uddi.api_v2.ErrInfo;
import org.uddi.api_v2.FindBusiness;
import org.uddi.api_v2.GetAssertionStatusReport;
import org.uddi.api_v2.GetBusinessDetail;
import org.uddi.api_v2.GetPublisherAssertions;
import org.uddi.api_v2.GetServiceDetail;
import org.uddi.api_v2.GetTModelDetail;
import org.uddi.api_v2.IdentifierBag;
import org.uddi.api_v2.InstanceDetails;
import org.uddi.api_v2.KeyType;
import org.uddi.api_v2.KeysOwned;
import org.uddi.api_v2.Name;
import org.uddi.api_v2.OverviewDoc;
import org.uddi.api_v2.Phone;
import org.uddi.api_v2.PublisherAssertion;
import org.uddi.api_v2.PublisherAssertions;
import org.uddi.api_v2.RegisteredInfo;
import org.uddi.api_v2.RelatedBusinessInfos;
import org.uddi.api_v2.SaveBinding;
import org.uddi.api_v2.SaveBusiness;
import org.uddi.api_v2.SaveTModel;
import org.uddi.api_v2.ServiceDetail;
import org.uddi.api_v2.ServiceInfo;
import org.uddi.api_v2.ServiceInfos;
import org.uddi.api_v2.ServiceList;
import org.uddi.api_v2.SetPublisherAssertions;
import org.uddi.api_v2.TModel;
import org.uddi.api_v2.TModelBag;
import org.uddi.api_v2.TModelInfos;
import org.uddi.api_v2.TModelInstanceInfo;
import org.uddi.api_v2.TModelList;
import org.uddi.api_v2.Truncated;
import org.uddi.api_v2.URLType;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AddPublisherAssertions;
import org.uddi.api_v3.AssertionStatusItem;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessInfos;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.CompletionStatus;
import org.uddi.api_v3.DeleteBinding;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.Email;
import org.uddi.api_v3.FindBinding;
import org.uddi.api_v3.FindQualifiers;
import org.uddi.api_v3.FindRelatedBusinesses;
import org.uddi.api_v3.FindService;
import org.uddi.api_v3.FindTModel;
import org.uddi.api_v3.GetBindingDetail;
import org.uddi.api_v3.GetRegisteredInfo;
import org.uddi.api_v3.HostingRedirector;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.PersonName;
import org.uddi.api_v3.RelatedBusinessInfo;
import org.uddi.api_v3.RelatedBusinessesList;
import org.uddi.api_v3.Result;
import org.uddi.api_v3.SaveService;
import org.uddi.api_v3.SharedRelationships;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInfo;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.v2_service.DispositionReport;
import org.uddi.v3_service.DispositionReportFaultMessage;

public class MapUDDIv3Tov2 {
    public static final String VERSION = "2.0";

    public static org.uddi.api_v2.BusinessEntity MapBusiness(BusinessEntity be, String operator) {
        if (be == null) {
            return null;
        }
        org.uddi.api_v2.BusinessEntity item = new org.uddi.api_v2.BusinessEntity();
        item.setBusinessKey(be.getBusinessKey());
        if (item.getBusinessKey() == null) {
            item.setBusinessKey("");
        }
        item.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(be.getCategoryBag()));
        item.setContacts(MapUDDIv3Tov2.MapContacts(be.getContacts()));
        item.setDiscoveryURLs(MapUDDIv3Tov2.MapDiscoveryURLs(be.getDiscoveryURLs()));
        item.setIdentifierBag(MapUDDIv3Tov2.mapIdentBag(be.getIdentifierBag()));
        item.setOperator(operator);
        item.getDescription().addAll(MapUDDIv3Tov2.mapDescription(be.getDescription()));
        item.getName().addAll(MapUDDIv3Tov2.mapName(be.getName()));
        if (be.getBusinessServices() != null && !be.getBusinessServices().getBusinessService().isEmpty()) {
            item.setBusinessServices(new BusinessServices());
            item.getBusinessServices().getBusinessService().addAll(MapUDDIv3Tov2.MapService(be.getBusinessServices().getBusinessService()));
        }
        return item;
    }

    public static BusinessService MapService(org.uddi.api_v3.BusinessService be) {
        if (be == null) {
            return null;
        }
        BusinessService item = new BusinessService();
        item.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(be.getCategoryBag()));
        item.getDescription().addAll(MapUDDIv3Tov2.mapDescription(be.getDescription()));
        item.setBusinessKey(be.getBusinessKey());
        item.setServiceKey(be.getServiceKey());
        item.getName().addAll(MapUDDIv3Tov2.mapName(be.getName()));
        if (be.getBindingTemplates() != null && !be.getBindingTemplates().getBindingTemplate().isEmpty()) {
            item.setBindingTemplates(new BindingTemplates());
            item.getBindingTemplates().getBindingTemplate().addAll(MapUDDIv3Tov2.MapBinding(be.getBindingTemplates().getBindingTemplate()));
        }
        return item;
    }

    public static List<BusinessService> MapService(List<org.uddi.api_v3.BusinessService> be) {
        if (be == null) {
            return null;
        }
        ArrayList<BusinessService> item = new ArrayList<BusinessService>();
        for (int i = 0; i < be.size(); ++i) {
            item.add(MapUDDIv3Tov2.MapService(be.get(i)));
        }
        return item;
    }

    public static BindingTemplate MapBinding(org.uddi.api_v3.BindingTemplate be) {
        if (be == null) {
            return null;
        }
        BindingTemplate item = new BindingTemplate();
        item.getDescription().addAll(MapUDDIv3Tov2.mapDescription(be.getDescription()));
        item.setBindingKey(be.getBindingKey());
        item.setServiceKey(be.getServiceKey());
        item.setAccessPoint(MapUDDIv3Tov2.mapAccessPoint(be.getAccessPoint()));
        item.setHostingRedirector(MapUDDIv3Tov2.mapHostingRedir(be.getHostingRedirector()));
        item.setTModelInstanceDetails(MapUDDIv3Tov2.mapTModelInstanceDetails(be.getTModelInstanceDetails()));
        return item;
    }

    public static List<BindingTemplate> MapBinding(List<org.uddi.api_v3.BindingTemplate> be) {
        if (be == null) {
            return null;
        }
        ArrayList<BindingTemplate> item = new ArrayList<BindingTemplate>();
        for (int i = 0; i < be.size(); ++i) {
            item.add(MapUDDIv3Tov2.MapBinding(be.get(i)));
        }
        return item;
    }

    public static TModel MapTModel(org.uddi.api_v3.TModel be) {
        if (be == null) {
            return null;
        }
        TModel item = new TModel();
        item.setTModelKey(be.getTModelKey());
        item.setName(new Name(be.getName().getValue(), be.getName().getLang()));
        item.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(be.getCategoryBag()));
        item.getDescription().addAll(MapUDDIv3Tov2.mapDescription(be.getDescription()));
        item.setIdentifierBag(MapUDDIv3Tov2.mapIdentBag(be.getIdentifierBag()));
        item.setOverviewDoc(MapUDDIv3Tov2.mapOverviewDoc(be.getOverviewDoc()));
        return item;
    }

    private static List<Name> mapName(List<org.uddi.api_v3.Name> name) {
        ArrayList<Name> items = new ArrayList<Name>();
        for (int i = 0; i < name.size(); ++i) {
            Name n = new Name(name.get(i).getValue(), name.get(i).getLang());
            items.add(n);
        }
        return items;
    }

    private static org.uddi.api_v2.CategoryBag mapCategoryBag(CategoryBag categoryBag) {
        if (categoryBag == null) {
            return null;
        }
        org.uddi.api_v2.CategoryBag c = new org.uddi.api_v2.CategoryBag();
        c.getKeyedReference().addAll(MapUDDIv3Tov2.mapKeyedReference(categoryBag.getKeyedReference()));
        return c;
    }

    private static List<Description> mapDescription(List<org.uddi.api_v3.Description> description) {
        ArrayList<Description> ret = new ArrayList<Description>();
        if (description == null || description.isEmpty()) {
            return ret;
        }
        for (int i = 0; i < description.size(); ++i) {
            ret.add(new Description(description.get(i).getValue(), description.get(i).getLang()));
        }
        return ret;
    }

    private static IdentifierBag mapIdentBag(org.uddi.api_v3.IdentifierBag identifierBag) {
        if (identifierBag == null) {
            return null;
        }
        IdentifierBag r = new IdentifierBag();
        r.getKeyedReference().addAll(MapUDDIv3Tov2.mapKeyedReference(identifierBag.getKeyedReference()));
        return r;
    }

    private static OverviewDoc mapOverviewDoc(List<org.uddi.api_v3.OverviewDoc> overviewDoc) {
        if (overviewDoc == null || overviewDoc.isEmpty()) {
            return null;
        }
        OverviewDoc r = new OverviewDoc();
        r.getDescription().addAll(MapUDDIv3Tov2.mapDescription(overviewDoc.get(0).getDescription()));
        if (overviewDoc.get(0).getOverviewURL() != null && overviewDoc.get(0).getOverviewURL().getValue() != null) {
            r.setOverviewURL(overviewDoc.get(0).getOverviewURL().getValue());
        }
        return r;
    }

    private static org.uddi.api_v2.AccessPoint mapAccessPoint(AccessPoint accessPoint) {
        if (accessPoint == null) {
            return null;
        }
        return new org.uddi.api_v2.AccessPoint(accessPoint.getValue(), MapUDDIv3Tov2.mapURLType(accessPoint.getValue(), accessPoint.getUseType()));
    }

    private static org.uddi.api_v2.HostingRedirector mapHostingRedir(HostingRedirector hostingRedirector) {
        if (hostingRedirector == null) {
            return null;
        }
        org.uddi.api_v2.HostingRedirector r = new org.uddi.api_v2.HostingRedirector();
        r.setBindingKey(hostingRedirector.getBindingKey());
        return r;
    }

    private static org.uddi.api_v2.TModelInstanceDetails mapTModelInstanceDetails(TModelInstanceDetails tModelInstanceDetails) {
        if (tModelInstanceDetails == null) {
            return new org.uddi.api_v2.TModelInstanceDetails();
        }
        org.uddi.api_v2.TModelInstanceDetails r = new org.uddi.api_v2.TModelInstanceDetails();
        r.getTModelInstanceInfo().addAll(MapUDDIv3Tov2.MapTModelInstanceInfo(tModelInstanceDetails.getTModelInstanceInfo()));
        return r;
    }

    private static List<org.uddi.api_v2.KeyedReference> mapKeyedReference(List<KeyedReference> keyedReference) {
        ArrayList<org.uddi.api_v2.KeyedReference> r = new ArrayList<org.uddi.api_v2.KeyedReference>();
        if (keyedReference == null) {
            return r;
        }
        for (int i = 0; i < keyedReference.size(); ++i) {
            r.add(new org.uddi.api_v2.KeyedReference(keyedReference.get(i).getTModelKey(), keyedReference.get(i).getKeyName(), keyedReference.get(i).getKeyValue()));
        }
        return r;
    }

    private static URLType mapURLType(String url, String useType) {
        try {
            return URLType.fromValue((String)useType);
        }
        catch (Exception exception) {
            if (url == null) {
                return URLType.OTHER;
            }
            if (url.toLowerCase().startsWith("http:")) {
                return URLType.HTTP;
            }
            if (url.toLowerCase().startsWith("https:")) {
                return URLType.HTTPS;
            }
            if (url.toLowerCase().startsWith("ftp:")) {
                return URLType.FTP;
            }
            if (url.toLowerCase().startsWith("mailto:")) {
                return URLType.MAILTO;
            }
            if (url.toLowerCase().startsWith("phone:")) {
                return URLType.PHONE;
            }
            if (url.toLowerCase().startsWith("fax:")) {
                return URLType.FAX;
            }
            return URLType.OTHER;
        }
    }

    private static List<TModelInstanceInfo> MapTModelInstanceInfo(List<org.uddi.api_v3.TModelInstanceInfo> tModelInstanceInfo) {
        ArrayList<TModelInstanceInfo> r = new ArrayList<TModelInstanceInfo>();
        if (tModelInstanceInfo == null) {
            return r;
        }
        for (int i = 0; i < tModelInstanceInfo.size(); ++i) {
            TModelInstanceInfo t = new TModelInstanceInfo();
            t.setTModelKey(tModelInstanceInfo.get(i).getTModelKey());
            t.getDescription().addAll(MapUDDIv3Tov2.mapDescription(tModelInstanceInfo.get(i).getDescription()));
            if (tModelInstanceInfo.get(i).getInstanceDetails() != null) {
                t.setInstanceDetails(new InstanceDetails());
                t.getInstanceDetails().getDescription().addAll(MapUDDIv3Tov2.mapDescription(tModelInstanceInfo.get(i).getInstanceDetails().getDescription()));
                t.getInstanceDetails().setInstanceParms(StringEscapeUtils.escapeXml((String)tModelInstanceInfo.get(i).getInstanceDetails().getInstanceParms()));
                t.getInstanceDetails().setOverviewDoc(MapUDDIv3Tov2.mapOverviewDoc(tModelInstanceInfo.get(i).getInstanceDetails().getOverviewDoc()));
            }
            r.add(t);
        }
        return r;
    }

    public static org.uddi.api_v2.FindBinding MapFindBinding(FindBinding body) {
        org.uddi.api_v2.FindBinding r = new org.uddi.api_v2.FindBinding();
        r.setFindQualifiers(MapUDDIv3Tov2.MapFindQualifiers(body.getFindQualifiers()));
        if (r.getFindQualifiers() == null) {
            r.setFindQualifiers(new org.uddi.api_v2.FindQualifiers());
        }
        r.setMaxRows(body.getMaxRows());
        r.setTModelBag(MapUDDIv3Tov2.MapTModelBag(body.getTModelBag()));
        if (r.getTModelBag() == null) {
            r.setTModelBag(new TModelBag());
            r.getTModelBag().getTModelKey().add("");
        }
        r.setServiceKey(body.getServiceKey());
        if (r.getServiceKey() == null) {
            r.setServiceKey("");
        }
        r.setGeneric(VERSION);
        return r;
    }

    public static FindBusiness MapFindBusiness(org.uddi.api_v3.FindBusiness body) {
        FindBusiness r = new FindBusiness();
        r.setFindQualifiers(MapUDDIv3Tov2.MapFindQualifiers(body.getFindQualifiers()));
        r.setMaxRows(body.getMaxRows());
        r.setTModelBag(MapUDDIv3Tov2.MapTModelBag(body.getTModelBag()));
        r.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(body.getCategoryBag()));
        r.setGeneric(VERSION);
        r.setDiscoveryURLs(MapUDDIv3Tov2.MapDiscoveryURLs(body.getDiscoveryURLs()));
        r.setIdentifierBag(MapUDDIv3Tov2.mapIdentBag(body.getIdentifierBag()));
        r.getName().addAll(MapUDDIv3Tov2.mapName(body.getName()));
        if (MapUDDIv3Tov2.ContainsWildCard(r.getName())) {
            // empty if block
        }
        return r;
    }

    public static org.uddi.api_v2.FindRelatedBusinesses MapFindRelatedBusiness(FindRelatedBusinesses body) {
        org.uddi.api_v2.FindRelatedBusinesses r = new org.uddi.api_v2.FindRelatedBusinesses();
        r.setFindQualifiers(MapUDDIv3Tov2.MapFindQualifiers(body.getFindQualifiers()));
        r.setMaxRows(body.getMaxRows());
        r.setBusinessKey(body.getBusinessKey());
        if (body.getKeyedReference() != null) {
            r.setKeyedReference(new org.uddi.api_v2.KeyedReference(body.getKeyedReference().getTModelKey(), body.getKeyedReference().getKeyName(), body.getKeyedReference().getKeyValue()));
        }
        r.setGeneric(VERSION);
        return r;
    }

    public static org.uddi.api_v2.FindService MapFindService(FindService body) {
        org.uddi.api_v2.FindService r = new org.uddi.api_v2.FindService();
        r.setFindQualifiers(MapUDDIv3Tov2.MapFindQualifiers(body.getFindQualifiers()));
        r.setMaxRows(body.getMaxRows());
        r.setTModelBag(MapUDDIv3Tov2.MapTModelBag(body.getTModelBag()));
        r.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(body.getCategoryBag()));
        r.setGeneric(VERSION);
        r.setBusinessKey(body.getBusinessKey());
        r.getName().addAll(MapUDDIv3Tov2.mapName(body.getName()));
        return r;
    }

    public static org.uddi.api_v2.FindTModel MapFindTModel(FindTModel body) {
        org.uddi.api_v2.FindTModel r = new org.uddi.api_v2.FindTModel();
        r.setFindQualifiers(MapUDDIv3Tov2.MapFindQualifiers(body.getFindQualifiers()));
        r.setMaxRows(body.getMaxRows());
        r.setCategoryBag(MapUDDIv3Tov2.mapCategoryBag(body.getCategoryBag()));
        r.setGeneric(VERSION);
        if (body.getName() != null) {
            r.setName(new Name(body.getName().getValue(), body.getName().getLang()));
        }
        return r;
    }

    public static org.uddi.api_v2.GetBindingDetail MapGetBindingDetail(GetBindingDetail body) {
        org.uddi.api_v2.GetBindingDetail r = new org.uddi.api_v2.GetBindingDetail();
        r.getBindingKey().addAll(body.getBindingKey());
        r.setGeneric(VERSION);
        return r;
    }

    public static GetBusinessDetail MapGetBusinessDetail(org.uddi.api_v3.GetBusinessDetail body) {
        GetBusinessDetail r = new GetBusinessDetail();
        r.getBusinessKey().addAll(body.getBusinessKey());
        r.setGeneric(VERSION);
        return r;
    }

    public static GetServiceDetail MapGetServiceDetail(org.uddi.api_v3.GetServiceDetail body) {
        GetServiceDetail r = new GetServiceDetail();
        r.getServiceKey().addAll(body.getServiceKey());
        r.setGeneric(VERSION);
        return r;
    }

    public static GetTModelDetail MapGetTModelDetail(org.uddi.api_v3.GetTModelDetail body) {
        GetTModelDetail r = new GetTModelDetail();
        r.getTModelKey().addAll(body.getTModelKey());
        r.setGeneric(VERSION);
        return r;
    }

    public static org.uddi.api_v2.AddPublisherAssertions MapAddPublisherAssertions(AddPublisherAssertions body) {
        if (body == null) {
            return null;
        }
        org.uddi.api_v2.AddPublisherAssertions r = new org.uddi.api_v2.AddPublisherAssertions();
        r.setAuthInfo(body.getAuthInfo());
        r.setGeneric(VERSION);
        r.getPublisherAssertion().addAll(MapUDDIv3Tov2.MapPublisherAssertion(body.getPublisherAssertion()));
        return r;
    }

    public static org.uddi.api_v2.DeleteBinding MapDeleteBinding(DeleteBinding body) {
        org.uddi.api_v2.DeleteBinding r = new org.uddi.api_v2.DeleteBinding();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getBindingKey().addAll(body.getBindingKey());
        return r;
    }

    public static DeleteBusiness MapDeleteBusiness(org.uddi.api_v3.DeleteBusiness body) {
        DeleteBusiness r = new DeleteBusiness();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getBusinessKey().addAll(body.getBusinessKey());
        return r;
    }

    public static DeletePublisherAssertions MapDeletePublisherAssertions(org.uddi.api_v3.DeletePublisherAssertions body) {
        if (body == null) {
            return null;
        }
        DeletePublisherAssertions r = new DeletePublisherAssertions();
        r.setAuthInfo(body.getAuthInfo());
        r.setGeneric(VERSION);
        r.getPublisherAssertion().addAll(MapUDDIv3Tov2.MapPublisherAssertion(body.getPublisherAssertion()));
        return r;
    }

    public static DeleteService MapDeleteService(org.uddi.api_v3.DeleteService body) {
        DeleteService r = new DeleteService();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getServiceKey().addAll(body.getServiceKey());
        return r;
    }

    public static DeleteTModel MapDeleteTModel(org.uddi.api_v3.DeleteTModel body) {
        DeleteTModel r = new DeleteTModel();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getTModelKey().addAll(body.getTModelKey());
        return r;
    }

    public static SaveBinding MapSaveBinding(org.uddi.api_v3.SaveBinding body) {
        SaveBinding r = new SaveBinding();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getBindingTemplate().addAll(MapUDDIv3Tov2.MapBinding(body.getBindingTemplate()));
        return r;
    }

    public static SaveBusiness MapSaveBusiness(org.uddi.api_v3.SaveBusiness body) {
        SaveBusiness r = new SaveBusiness();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getBusinessEntity().addAll(MapUDDIv3Tov2.MapBusinessList(body.getBusinessEntity(), null));
        return r;
    }

    public static org.uddi.api_v2.SaveService MapSaveService(SaveService body) {
        org.uddi.api_v2.SaveService r = new org.uddi.api_v2.SaveService();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getBusinessService().addAll(MapUDDIv3Tov2.MapService(body.getBusinessService()));
        return r;
    }

    public static SaveTModel MapSaveTModel(org.uddi.api_v3.SaveTModel body) {
        SaveTModel r = new SaveTModel();
        r.setGeneric(VERSION);
        r.setAuthInfo(body.getAuthInfo());
        r.getTModel().addAll(MapUDDIv3Tov2.MapTModelList(body.getTModel()));
        return r;
    }

    public static GetPublisherAssertions MapGetPublisherAssertions(String authInfo) {
        GetPublisherAssertions r = new GetPublisherAssertions();
        r.setAuthInfo(authInfo);
        r.setGeneric(VERSION);
        return r;
    }

    public static org.uddi.api_v2.GetRegisteredInfo MapGetRegisteredInfo(GetRegisteredInfo body) {
        org.uddi.api_v2.GetRegisteredInfo r = new org.uddi.api_v2.GetRegisteredInfo();
        r.setAuthInfo(body.getAuthInfo());
        r.setGeneric(VERSION);
        return r;
    }

    private static org.uddi.api_v2.FindQualifiers MapFindQualifiers(FindQualifiers findQualifiers) {
        if (findQualifiers == null || findQualifiers.getFindQualifier().isEmpty()) {
            return null;
        }
        org.uddi.api_v2.FindQualifiers r = new org.uddi.api_v2.FindQualifiers();
        for (int i = 0; i < findQualifiers.getFindQualifier().size(); ++i) {
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("exactMatch") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:exactmatch")) {
                r.getFindQualifier().add("exactNameMatch");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseSensitiveMatch") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:casesensitivematch")) {
                r.getFindQualifier().add("caseSensitiveMatch");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("orAllKeys") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:orallkeys")) {
                r.getFindQualifier().add("orAllKeys");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("orLikeKeys") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:orlikekeys")) {
                r.getFindQualifier().add("orLikeKeys");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("andAllKeys") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:andallkeys")) {
                r.getFindQualifier().add("andAllKeys");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByDateAsc") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydateasc")) {
                r.getFindQualifier().add("sortByDateAsc");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByDateDesc") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbydatedesc")) {
                r.getFindQualifier().add("sortByDateDesc");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByNameAsc") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynameasc")) {
                r.getFindQualifier().add("sortByNameAsc");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("sortByNameDesc") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:sortbynamedesc")) {
                r.getFindQualifier().add("sortByNameDesc");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("serviceSubset") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:servicesubset")) {
                r.getFindQualifier().add("serviceSubset");
                continue;
            }
            if (((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("combineCategoryBags") || ((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:combinecategorybags")) {
                r.getFindQualifier().add("combineCategoryBags");
                continue;
            }
            if (!((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("approximateMatch") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:approximatematch") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("caseInsensitiveMatch") && !((String)findQualifiers.getFindQualifier().get(i)).equalsIgnoreCase("uddi:uddi.org:findqualifier:caseinsensitivematch")) continue;
        }
        return r;
    }

    private static TModelBag MapTModelBag(org.uddi.api_v3.TModelBag tModelBag) {
        if (tModelBag == null || tModelBag.getTModelKey().isEmpty()) {
            return null;
        }
        TModelBag r = new TModelBag();
        r.getTModelKey().addAll(tModelBag.getTModelKey());
        return r;
    }

    private static org.uddi.api_v2.DiscoveryURLs MapDiscoveryURLs(DiscoveryURLs discoveryURLs) {
        if (discoveryURLs == null) {
            return null;
        }
        org.uddi.api_v2.DiscoveryURLs r = new org.uddi.api_v2.DiscoveryURLs();
        for (int i = 0; i < discoveryURLs.getDiscoveryURL().size(); ++i) {
            DiscoveryURL d = new DiscoveryURL();
            d.setUseType(((org.uddi.api_v3.DiscoveryURL)discoveryURLs.getDiscoveryURL().get(i)).getUseType());
            d.setValue(((org.uddi.api_v3.DiscoveryURL)discoveryURLs.getDiscoveryURL().get(i)).getValue());
            r.getDiscoveryURL().add(d);
        }
        return r;
    }

    private static List<org.uddi.api_v2.BusinessEntity> MapBusinessList(List<BusinessEntity> businessEntity, String operator) {
        ArrayList<org.uddi.api_v2.BusinessEntity> r = new ArrayList<org.uddi.api_v2.BusinessEntity>();
        if (businessEntity == null) {
            return r;
        }
        for (int i = 0; i < businessEntity.size(); ++i) {
            r.add(MapUDDIv3Tov2.MapBusiness(businessEntity.get(i), operator));
        }
        return r;
    }

    private static List<TModel> MapTModelList(List<org.uddi.api_v3.TModel> tModel) {
        ArrayList<TModel> r = new ArrayList<TModel>();
        if (tModel == null) {
            return r;
        }
        for (int i = 0; i < tModel.size(); ++i) {
            r.add(MapUDDIv3Tov2.MapTModel(tModel.get(i)));
        }
        return r;
    }

    public static SetPublisherAssertions MapSetPublisherAssertions(List<org.uddi.api_v3.PublisherAssertion> value) {
        if (value == null) {
            return null;
        }
        SetPublisherAssertions r = new SetPublisherAssertions();
        r.setGeneric(VERSION);
        r.getPublisherAssertion().addAll(MapUDDIv3Tov2.MapPublisherAssertion(value));
        return r;
    }

    public static BindingDetail MapBindingDetail(org.uddi.api_v3.BindingDetail findBinding, String operator) {
        if (findBinding == null) {
            return null;
        }
        BindingDetail r = new BindingDetail();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        if (findBinding.getListDescription() == null) {
            r.setTruncated(Truncated.TRUE);
        } else if (findBinding.getListDescription().getActualCount() == findBinding.getListDescription().getIncludeCount()) {
            r.setTruncated(Truncated.FALSE);
        } else {
            r.setTruncated(Truncated.TRUE);
        }
        r.getBindingTemplate().addAll(MapUDDIv3Tov2.MapBinding(findBinding.getBindingTemplate()));
        return r;
    }

    public static DispositionReport MapException(DispositionReportFaultMessage ex, String operator) {
        if (ex == null) {
            return null;
        }
        DispositionReport r = new DispositionReport(ex.getMessage() + (ex.detail != null ? ex.detail.getMessage() : ""), MapUDDIv3Tov2.MapDispositionReport(ex.getFaultInfo(), operator));
        return r;
    }

    private static org.uddi.api_v2.DispositionReport MapDispositionReport(org.uddi.api_v3.DispositionReport faultInfo, String operator) {
        if (faultInfo == null) {
            return null;
        }
        org.uddi.api_v2.DispositionReport r = new org.uddi.api_v2.DispositionReport();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.setTruncated(Truncated.FALSE);
        r.getResult().addAll(MapUDDIv3Tov2.MapResults(faultInfo.getResult()));
        return r;
    }

    private static List<org.uddi.api_v2.Result> MapResults(List<Result> result) {
        ArrayList<org.uddi.api_v2.Result> r = new ArrayList<org.uddi.api_v2.Result>();
        if (result == null) {
            return r;
        }
        for (int i = 0; i < result.size(); ++i) {
            org.uddi.api_v2.Result x = new org.uddi.api_v2.Result();
            x.setErrno(result.get(i).getErrno());
            x.setErrno(result.get(i).getErrno());
            if (result.get(i).getKeyType() != null) {
                switch (result.get(i).getKeyType()) {
                    case BINDING_KEY: {
                        x.setKeyType(KeyType.BINDING_KEY);
                        break;
                    }
                    case BUSINESS_KEY: {
                        x.setKeyType(KeyType.BUSINESS_KEY);
                        break;
                    }
                    case SERVICE_KEY: {
                        x.setKeyType(KeyType.SERVICE_KEY);
                        break;
                    }
                    case T_MODEL_KEY: {
                        x.setKeyType(KeyType.T_MODEL_KEY);
                    }
                }
            }
            x.setErrInfo(new ErrInfo());
            x.getErrInfo().setErrCode(result.get(i).getErrInfo().getErrCode());
            x.getErrInfo().setValue(result.get(i).getErrInfo().getValue());
            r.add(x);
        }
        return r;
    }

    public static org.uddi.api_v2.BusinessList MapBusinessListEntity(BusinessList findBusiness, String operator) {
        if (findBusiness == null) {
            return null;
        }
        org.uddi.api_v2.BusinessList r = new org.uddi.api_v2.BusinessList();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.setBusinessInfos(MapUDDIv3Tov2.MapBusinessInfos(findBusiness.getBusinessInfos()));
        if (findBusiness.isTruncated() != null && findBusiness.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        return r;
    }

    public static org.uddi.api_v2.RelatedBusinessesList MapRelatedBusinessList(RelatedBusinessesList findRelatedBusinesses, String operator) {
        if (findRelatedBusinesses == null) {
            return null;
        }
        org.uddi.api_v2.RelatedBusinessesList r = new org.uddi.api_v2.RelatedBusinessesList();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.setBusinessKey(findRelatedBusinesses.getBusinessKey());
        if (findRelatedBusinesses.isTruncated() != null && findRelatedBusinesses.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        r.setRelatedBusinessInfos(new RelatedBusinessInfos());
        if (findRelatedBusinesses.getRelatedBusinessInfos() != null) {
            for (int i = 0; i < findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().size(); ++i) {
                org.uddi.api_v2.RelatedBusinessInfo x = new org.uddi.api_v2.RelatedBusinessInfo();
                x.setBusinessKey(((RelatedBusinessInfo)findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i)).getBusinessKey());
                x.getDescription().addAll(MapUDDIv3Tov2.mapDescription(((RelatedBusinessInfo)findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i)).getDescription()));
                x.getName().addAll(MapUDDIv3Tov2.mapName(((RelatedBusinessInfo)findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i)).getName()));
                x.getSharedRelationships().addAll(MapUDDIv3Tov2.MapSharedRelationships(((RelatedBusinessInfo)findRelatedBusinesses.getRelatedBusinessInfos().getRelatedBusinessInfo().get(i)).getSharedRelationships()));
                r.getRelatedBusinessInfos().getRelatedBusinessInfo().add(x);
            }
        }
        return r;
    }

    public static ServiceList MapServiceList(org.uddi.api_v3.ServiceList findService, String operator) {
        if (findService == null) {
            return null;
        }
        ServiceList r = new ServiceList();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.setServiceInfos(MapUDDIv3Tov2.MapServiceInfos(findService.getServiceInfos()));
        if (findService.isTruncated() != null && findService.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        return r;
    }

    public static BusinessDetailExt MapBusinessDetailExt(BusinessDetail businessDetail, String operator) {
        if (businessDetail == null) {
            return null;
        }
        BusinessDetailExt r = new BusinessDetailExt();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        if (businessDetail.isTruncated() != null && businessDetail.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        for (int i = 0; i < businessDetail.getBusinessEntity().size(); ++i) {
            BusinessEntityExt x = new BusinessEntityExt();
            x.setBusinessEntity(MapUDDIv3Tov2.MapBusiness((BusinessEntity)businessDetail.getBusinessEntity().get(i), operator));
            r.getBusinessEntityExt().add(x);
        }
        return r;
    }

    public static ServiceDetail MapServiceDetail(org.uddi.api_v3.ServiceDetail serviceDetail, String operator) {
        if (serviceDetail == null) {
            return null;
        }
        ServiceDetail r = new ServiceDetail();
        if (serviceDetail.isTruncated() != null && serviceDetail.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.getBusinessService().addAll(MapUDDIv3Tov2.MapService(serviceDetail.getBusinessService()));
        return r;
    }

    public static TModelList MapTModelListElement(org.uddi.api_v3.TModelList findTModel, String operator) {
        TModelList r = new TModelList();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        r.setTModelInfos(new TModelInfos());
        if (findTModel == null) {
            r.setTruncated(Truncated.FALSE);
            return r;
        }
        if (findTModel.isTruncated() != null && findTModel.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        if (findTModel.getTModelInfos() != null) {
            r.getTModelInfos().getTModelInfo().addAll(MapUDDIv3Tov2.MapTModelInfo(findTModel.getTModelInfos().getTModelInfo()));
        }
        return r;
    }

    public static org.uddi.api_v2.BusinessDetail MapBusinessDetail(BusinessDetail businessDetail, String operator) {
        if (businessDetail == null) {
            return null;
        }
        org.uddi.api_v2.BusinessDetail r = new org.uddi.api_v2.BusinessDetail();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        if (businessDetail.isTruncated() != null && businessDetail.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        r.getBusinessEntity().addAll(MapUDDIv3Tov2.MapBusinessList(businessDetail.getBusinessEntity(), operator));
        return r;
    }

    public static org.uddi.api_v2.TModelDetail MapTModelDetail(TModelDetail tModelDetail, String operator) {
        if (tModelDetail == null) {
            return null;
        }
        org.uddi.api_v2.TModelDetail r = new org.uddi.api_v2.TModelDetail();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        if (tModelDetail.isTruncated() != null && tModelDetail.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        r.getTModel().addAll(MapUDDIv3Tov2.MapTModelList(tModelDetail.getTModel()));
        return r;
    }

    private static org.uddi.api_v2.BusinessInfos MapBusinessInfos(BusinessInfos businessInfos) {
        org.uddi.api_v2.BusinessInfos r = new org.uddi.api_v2.BusinessInfos();
        if (businessInfos == null || businessInfos.getBusinessInfo().isEmpty()) {
            return r;
        }
        for (int i = 0; i < businessInfos.getBusinessInfo().size(); ++i) {
            org.uddi.api_v2.BusinessInfo x = new org.uddi.api_v2.BusinessInfo();
            x.setBusinessKey(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getBusinessKey());
            x.setServiceInfos(MapUDDIv3Tov2.MapServiceInfos(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getServiceInfos()));
            x.getDescription().addAll(MapUDDIv3Tov2.mapDescription(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getDescription()));
            x.getName().addAll(MapUDDIv3Tov2.mapName(((BusinessInfo)businessInfos.getBusinessInfo().get(i)).getName()));
            r.getBusinessInfo().add(x);
        }
        return r;
    }

    private static ServiceInfos MapServiceInfos(org.uddi.api_v3.ServiceInfos serviceInfos) {
        ServiceInfos r = new ServiceInfos();
        if (serviceInfos == null) {
            return r;
        }
        for (int i = 0; i < serviceInfos.getServiceInfo().size(); ++i) {
            ServiceInfo x = new ServiceInfo();
            x.setBusinessKey(((org.uddi.api_v3.ServiceInfo)serviceInfos.getServiceInfo().get(i)).getBusinessKey());
            x.setServiceKey(((org.uddi.api_v3.ServiceInfo)serviceInfos.getServiceInfo().get(i)).getServiceKey());
            x.getName().addAll(MapUDDIv3Tov2.mapName(((org.uddi.api_v3.ServiceInfo)serviceInfos.getServiceInfo().get(i)).getName()));
            r.getServiceInfo().add(x);
        }
        return r;
    }

    private static List<org.uddi.api_v2.TModelInfo> MapTModelInfo(List<TModelInfo> tModelInfo) {
        ArrayList<org.uddi.api_v2.TModelInfo> r = new ArrayList<org.uddi.api_v2.TModelInfo>();
        if (tModelInfo == null) {
            return r;
        }
        for (int i = 0; i < tModelInfo.size(); ++i) {
            org.uddi.api_v2.TModelInfo x = new org.uddi.api_v2.TModelInfo();
            x.setTModelKey(tModelInfo.get(i).getTModelKey());
            x.setName(new Name(tModelInfo.get(i).getName().getValue(), tModelInfo.get(i).getName().getLang()));
            r.add(x);
        }
        return r;
    }

    public static RegisteredInfo MapRegisteredInfo(org.uddi.api_v3.RegisteredInfo registeredInfo, String operator) {
        if (registeredInfo == null) {
            return null;
        }
        RegisteredInfo r = new RegisteredInfo();
        r.setGeneric(VERSION);
        r.setOperator(operator);
        if (registeredInfo.isTruncated() != null && registeredInfo.isTruncated().booleanValue()) {
            r.setTruncated(Truncated.TRUE);
        } else {
            r.setTruncated(Truncated.FALSE);
        }
        if (registeredInfo.getBusinessInfos() != null) {
            r.setBusinessInfos(new org.uddi.api_v2.BusinessInfos());
            for (int i = 0; i < registeredInfo.getBusinessInfos().getBusinessInfo().size(); ++i) {
                org.uddi.api_v2.BusinessInfo x = new org.uddi.api_v2.BusinessInfo();
                x.setBusinessKey(((BusinessInfo)registeredInfo.getBusinessInfos().getBusinessInfo().get(i)).getBusinessKey());
                x.getName().addAll(MapUDDIv3Tov2.mapName(((BusinessInfo)registeredInfo.getBusinessInfos().getBusinessInfo().get(i)).getName()));
                x.getDescription().addAll(MapUDDIv3Tov2.mapDescription(((BusinessInfo)registeredInfo.getBusinessInfos().getBusinessInfo().get(i)).getDescription()));
                x.setServiceInfos(MapUDDIv3Tov2.MapServiceInfos(((BusinessInfo)registeredInfo.getBusinessInfos().getBusinessInfo().get(i)).getServiceInfos()));
            }
        }
        if (registeredInfo.getTModelInfos() != null) {
            r.setTModelInfos(new TModelInfos());
            r.getTModelInfos().getTModelInfo().addAll(MapUDDIv3Tov2.MapTModelInfo(registeredInfo.getTModelInfos().getTModelInfo()));
        }
        return r;
    }

    public static PublisherAssertions MapPublisherAssertions(List<org.uddi.api_v3.PublisherAssertion> publisherAssertions, String operator, String user) {
        if (publisherAssertions == null) {
            return null;
        }
        PublisherAssertions r = new PublisherAssertions();
        r.getPublisherAssertion().addAll(MapUDDIv3Tov2.MapPublisherAssertion(publisherAssertions));
        r.setGeneric(VERSION);
        r.setAuthorizedName(user);
        r.setOperator(operator);
        return r;
    }

    private static List<PublisherAssertion> MapPublisherAssertion(List<org.uddi.api_v3.PublisherAssertion> publisherAssertion) {
        ArrayList<PublisherAssertion> r = new ArrayList<PublisherAssertion>();
        for (int i = 0; i < publisherAssertion.size(); ++i) {
            PublisherAssertion x = new PublisherAssertion();
            x.setFromKey(publisherAssertion.get(i).getFromKey());
            x.setToKey(publisherAssertion.get(i).getToKey());
            if (publisherAssertion.get(i).getKeyedReference() != null) {
                x.setKeyedReference(new org.uddi.api_v2.KeyedReference(publisherAssertion.get(i).getKeyedReference().getTModelKey(), publisherAssertion.get(i).getKeyedReference().getKeyName(), publisherAssertion.get(i).getKeyedReference().getKeyValue()));
            }
            r.add(x);
        }
        return r;
    }

    private static boolean ContainsWildCard(List<Name> name) {
        for (int i = 0; i < name.size(); ++i) {
            if (name.get(i).getValue() != null && name.get(i).getValue().contains("%")) {
                return true;
            }
            if (name.get(i).getValue() != null && name.get(i).getValue().contains("_")) {
                return true;
            }
            if (name.get(i).getLang() != null && name.get(i).getLang().contains("%")) {
                return true;
            }
            if (name.get(i).getLang() == null || !name.get(i).getLang().contains("_")) continue;
            return true;
        }
        return false;
    }

    public static GetAssertionStatusReport MapGetAssertionStatusReport(String authInfo, CompletionStatus completionStatus) {
        GetAssertionStatusReport r = new GetAssertionStatusReport();
        r.setAuthInfo(authInfo);
        switch (completionStatus) {
            case STATUS_BOTH_INCOMPLETE: {
                r.setCompletionStatus(null);
                break;
            }
            case STATUS_COMPLETE: {
                r.setCompletionStatus("status:complete");
                break;
            }
            case STATUS_FROM_KEY_INCOMPLETE: {
                r.setCompletionStatus("status:fromKey_incomplete");
                break;
            }
            case STATUS_TO_KEY_INCOMPLETE: {
                r.setCompletionStatus("status:toKey_incomplete");
            }
        }
        r.setGeneric(VERSION);
        return r;
    }

    private static Contacts MapContacts(org.uddi.api_v3.Contacts contacts) {
        if (contacts == null) {
            return null;
        }
        Contacts c = new Contacts();
        c.getContact().addAll(MapUDDIv3Tov2.MapContactList(contacts.getContact()));
        return c;
    }

    private static List<Contact> MapContactList(List<org.uddi.api_v3.Contact> contact) {
        ArrayList<Contact> r = new ArrayList<Contact>();
        if (contact == null) {
            return r;
        }
        for (int i = 0; i < contact.size(); ++i) {
            Contact c = new Contact();
            c.setUseType(contact.get(i).getUseType());
            c.setPersonName(((PersonName)contact.get(i).getPersonName().get(0)).getValue());
            c.getAddress().addAll(MapUDDIv3Tov2.MapAddress(contact.get(i).getAddress()));
            c.getDescription().addAll(MapUDDIv3Tov2.mapDescription(contact.get(i).getDescription()));
            c.getEmail().addAll(MapUDDIv3Tov2.MapEmail(contact.get(i).getEmail()));
            c.getPhone().addAll(MapUDDIv3Tov2.MapPhone(contact.get(i).getPhone()));
            r.add(c);
        }
        return r;
    }

    private static List<Address> MapAddress(List<org.uddi.api_v3.Address> address) {
        ArrayList<Address> r = new ArrayList<Address>();
        if (address == null) {
            return r;
        }
        for (int i = 0; i < address.size(); ++i) {
            Address x = new Address();
            x.setSortCode(address.get(i).getSortCode());
            x.setTModelKey(address.get(i).getTModelKey());
            x.setUseType(address.get(i).getUseType());
            x.getAddressLine().addAll(MapUDDIv3Tov2.MapAddressLine(address.get(i).getAddressLine()));
            r.add(x);
        }
        return r;
    }

    private static List<org.uddi.api_v2.Email> MapEmail(List<Email> email) {
        ArrayList<org.uddi.api_v2.Email> r = new ArrayList<org.uddi.api_v2.Email>();
        if (email == null) {
            return r;
        }
        for (int i = 0; i < email.size(); ++i) {
            org.uddi.api_v2.Email x = new org.uddi.api_v2.Email();
            x.setUseType(email.get(i).getUseType());
            x.setValue(email.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    private static List<Phone> MapPhone(List<org.uddi.api_v3.Phone> phone) {
        ArrayList<Phone> r = new ArrayList<Phone>();
        if (phone == null) {
            return r;
        }
        for (int i = 0; i < phone.size(); ++i) {
            Phone x = new Phone();
            x.setUseType(phone.get(i).getUseType());
            x.setValue(phone.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    private static List<AddressLine> MapAddressLine(List<org.uddi.api_v3.AddressLine> addressLine) {
        ArrayList<AddressLine> r = new ArrayList<AddressLine>();
        if (addressLine == null) {
            return r;
        }
        for (int i = 0; i < addressLine.size(); ++i) {
            AddressLine x = new AddressLine();
            x.setKeyName(addressLine.get(i).getKeyName());
            x.setKeyValue(addressLine.get(i).getKeyValue());
            x.setValue(addressLine.get(i).getValue());
            r.add(x);
        }
        return r;
    }

    public static AssertionStatusReport MapAssertionStatusReport(List<AssertionStatusItem> assertionStatusReport) {
        if (assertionStatusReport == null) {
            return null;
        }
        AssertionStatusReport r = new AssertionStatusReport();
        r.setGeneric(VERSION);
        for (int i = 0; i < assertionStatusReport.size(); ++i) {
            org.uddi.api_v2.AssertionStatusItem x = new org.uddi.api_v2.AssertionStatusItem();
            switch (assertionStatusReport.get(i).getCompletionStatus()) {
                case STATUS_BOTH_INCOMPLETE: {
                    x.setCompletionStatus(null);
                    break;
                }
                case STATUS_COMPLETE: {
                    x.setCompletionStatus("status:complete");
                    break;
                }
                case STATUS_FROM_KEY_INCOMPLETE: {
                    x.setCompletionStatus("status:fromKey_incomplete");
                    break;
                }
                case STATUS_TO_KEY_INCOMPLETE: {
                    x.setCompletionStatus("status:toKey_incomplete");
                }
            }
            x.setFromKey(assertionStatusReport.get(i).getFromKey());
            x.setToKey(assertionStatusReport.get(i).getToKey());
            if (assertionStatusReport.get(i).getKeyedReference() != null) {
                x.setKeyedReference(new org.uddi.api_v2.KeyedReference(assertionStatusReport.get(i).getKeyedReference().getTModelKey(), assertionStatusReport.get(i).getKeyedReference().getKeyName(), assertionStatusReport.get(i).getKeyedReference().getKeyValue()));
            }
            x.setKeysOwned(new KeysOwned());
            r.getAssertionStatusItem().add(x);
        }
        return r;
    }

    private static List<org.uddi.api_v2.SharedRelationships> MapSharedRelationships(List<SharedRelationships> sharedRelationships) {
        ArrayList<org.uddi.api_v2.SharedRelationships> r = new ArrayList<org.uddi.api_v2.SharedRelationships>();
        if (sharedRelationships == null) {
            return r;
        }
        for (int i = 0; i < sharedRelationships.size(); ++i) {
            org.uddi.api_v2.SharedRelationships x = new org.uddi.api_v2.SharedRelationships();
            x.getKeyedReference().addAll(MapUDDIv3Tov2.mapKeyedReference(sharedRelationships.get(i).getKeyedReference()));
            if (sharedRelationships.get(i).getDirection() != null) {
                switch (sharedRelationships.get(i).getDirection()) {
                    case FROM_KEY: {
                        x.setDirection(Direction.FROM_KEY);
                        break;
                    }
                    case TO_KEY: {
                        x.setDirection(Direction.TO_KEY);
                    }
                }
            }
            r.add(x);
        }
        return r;
    }
}

