/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.header;

import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;

class ConnectHeader
implements Header {
    private static final SchemaAndValue NULL_SCHEMA_AND_VALUE = new SchemaAndValue(null, null);
    private final String key;
    private final SchemaAndValue schemaAndValue;

    protected ConnectHeader(String key, SchemaAndValue schemaAndValue) {
        Objects.requireNonNull(key, "Null header keys are not permitted");
        this.key = key;
        this.schemaAndValue = schemaAndValue != null ? schemaAndValue : NULL_SCHEMA_AND_VALUE;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object value() {
        return this.schemaAndValue.value();
    }

    @Override
    public Schema schema() {
        Schema schema = this.schemaAndValue.schema();
        if (schema == null && this.value() instanceof Struct) {
            schema = ((Struct)this.value()).schema();
        }
        return schema;
    }

    @Override
    public Header rename(String key) {
        Objects.requireNonNull(key, "Null header keys are not permitted");
        if (this.key.equals(key)) {
            return this;
        }
        return new ConnectHeader(key, this.schemaAndValue);
    }

    @Override
    public Header with(Schema schema, Object value) {
        return new ConnectHeader(this.key, new SchemaAndValue(schema, value));
    }

    public int hashCode() {
        return Objects.hash(this.key, this.schemaAndValue);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Header) {
            Header that = (Header)obj;
            return Objects.equals(this.key, that.key()) && Objects.equals(this.schema(), that.schema()) && Objects.equals(this.value(), that.value());
        }
        return false;
    }

    public String toString() {
        return "ConnectHeader(key=" + this.key + ", value=" + this.value() + ", schema=" + this.schema() + ")";
    }
}

