/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.DefaultReplicationPolicy;
import org.apache.kafka.connect.mirror.ReplicationPolicy;

public class MirrorClientConfig
extends AbstractConfig {
    public static final String REPLICATION_POLICY_CLASS = "replication.policy.class";
    private static final String REPLICATION_POLICY_CLASS_DOC = "Class which defines the remote topic naming convention.";
    public static final Class<?> REPLICATION_POLICY_CLASS_DEFAULT = DefaultReplicationPolicy.class;
    public static final String REPLICATION_POLICY_SEPARATOR = "replication.policy.separator";
    private static final String REPLICATION_POLICY_SEPARATOR_DOC = "Separator used in remote topic naming convention.";
    public static final String REPLICATION_POLICY_SEPARATOR_DEFAULT = ".";
    public static final String ADMIN_CLIENT_PREFIX = "admin.";
    public static final String CONSUMER_CLIENT_PREFIX = "consumer.";
    public static final String PRODUCER_CLIENT_PREFIX = "producer.";
    static final ConfigDef CLIENT_CONFIG_DEF = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
    static final ConfigDef CONFIG_DEF = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("replication.policy.class", ConfigDef.Type.CLASS, REPLICATION_POLICY_CLASS_DEFAULT, ConfigDef.Importance.LOW, "Class which defines the remote topic naming convention.").define("replication.policy.separator", ConfigDef.Type.STRING, (Object)".", ConfigDef.Importance.LOW, "Separator used in remote topic naming convention.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();

    MirrorClientConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props, true);
    }

    public ReplicationPolicy replicationPolicy() {
        return (ReplicationPolicy)this.getConfiguredInstance(REPLICATION_POLICY_CLASS, ReplicationPolicy.class);
    }

    public Map<String, Object> adminConfig() {
        return this.clientConfig(ADMIN_CLIENT_PREFIX);
    }

    public Map<String, Object> consumerConfig() {
        return this.clientConfig(CONSUMER_CLIENT_PREFIX);
    }

    public Map<String, Object> producerConfig() {
        return this.clientConfig(PRODUCER_CLIENT_PREFIX);
    }

    private Map<String, Object> clientConfig(String prefix) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(this.valuesWithPrefixOverride(prefix));
        props.keySet().retainAll(CLIENT_CONFIG_DEF.names());
        props.entrySet().removeIf(x -> x.getValue() == null);
        return props;
    }
}

